/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * A resource message representing a data stream.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaDataStream extends com.google.api.client.json.GenericJson {

  /**
   * Data specific to Android app streams. Must be populated if type is ANDROID_APP_DATA_STREAM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData androidAppStreamData;

  /**
   * Output only. Time when this stream was originally created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Human-readable display name for the Data Stream. Required for web data streams. The max allowed
   * display name length is 255 UTF-16 code units.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Data specific to iOS app streams. Must be populated if type is IOS_APP_DATA_STREAM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData iosAppStreamData;

  /**
   * Output only. Resource name of this Data Stream. Format:
   * properties/{property_id}/dataStreams/{stream_id} Example: "properties/1000/dataStreams/2000"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Required. Immutable. The type of this DataStream resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Output only. Time when stream payload fields were last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Data specific to web streams. Must be populated if type is WEB_DATA_STREAM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsAdminV1betaDataStreamWebStreamData webStreamData;

  /**
   * Data specific to Android app streams. Must be populated if type is ANDROID_APP_DATA_STREAM.
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData getAndroidAppStreamData() {
    return androidAppStreamData;
  }

  /**
   * Data specific to Android app streams. Must be populated if type is ANDROID_APP_DATA_STREAM.
   * @param androidAppStreamData androidAppStreamData or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStream setAndroidAppStreamData(GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData androidAppStreamData) {
    this.androidAppStreamData = androidAppStreamData;
    return this;
  }

  /**
   * Output only. Time when this stream was originally created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Time when this stream was originally created.
   * @param createTime createTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStream setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Human-readable display name for the Data Stream. Required for web data streams. The max allowed
   * display name length is 255 UTF-16 code units.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Human-readable display name for the Data Stream. Required for web data streams. The max allowed
   * display name length is 255 UTF-16 code units.
   * @param displayName displayName or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStream setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Data specific to iOS app streams. Must be populated if type is IOS_APP_DATA_STREAM.
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData getIosAppStreamData() {
    return iosAppStreamData;
  }

  /**
   * Data specific to iOS app streams. Must be populated if type is IOS_APP_DATA_STREAM.
   * @param iosAppStreamData iosAppStreamData or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStream setIosAppStreamData(GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData iosAppStreamData) {
    this.iosAppStreamData = iosAppStreamData;
    return this;
  }

  /**
   * Output only. Resource name of this Data Stream. Format:
   * properties/{property_id}/dataStreams/{stream_id} Example: "properties/1000/dataStreams/2000"
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Resource name of this Data Stream. Format:
   * properties/{property_id}/dataStreams/{stream_id} Example: "properties/1000/dataStreams/2000"
   * @param name name or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStream setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Required. Immutable. The type of this DataStream resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Required. Immutable. The type of this DataStream resource.
   * @param type type or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStream setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Output only. Time when stream payload fields were last updated.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. Time when stream payload fields were last updated.
   * @param updateTime updateTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStream setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  /**
   * Data specific to web streams. Must be populated if type is WEB_DATA_STREAM.
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStreamWebStreamData getWebStreamData() {
    return webStreamData;
  }

  /**
   * Data specific to web streams. Must be populated if type is WEB_DATA_STREAM.
   * @param webStreamData webStreamData or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStream setWebStreamData(GoogleAnalyticsAdminV1betaDataStreamWebStreamData webStreamData) {
    this.webStreamData = webStreamData;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataStream set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaDataStream) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataStream clone() {
    return (GoogleAnalyticsAdminV1betaDataStream) super.clone();
  }

}
