/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * Data specific to Android app streams.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData extends com.google.api.client.json.GenericJson {

  /**
   * Output only. ID of the corresponding Android app in Firebase, if any. This ID can change if the
   * Android app is deleted and recreated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String firebaseAppId;

  /**
   * Immutable. The package name for the app being measured. Example: "com.example.myandroidapp"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String packageName;

  /**
   * Output only. ID of the corresponding Android app in Firebase, if any. This ID can change if the
   * Android app is deleted and recreated.
   * @return value or {@code null} for none
   */
  public java.lang.String getFirebaseAppId() {
    return firebaseAppId;
  }

  /**
   * Output only. ID of the corresponding Android app in Firebase, if any. This ID can change if the
   * Android app is deleted and recreated.
   * @param firebaseAppId firebaseAppId or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData setFirebaseAppId(java.lang.String firebaseAppId) {
    this.firebaseAppId = firebaseAppId;
    return this;
  }

  /**
   * Immutable. The package name for the app being measured. Example: "com.example.myandroidapp"
   * @return value or {@code null} for none
   */
  public java.lang.String getPackageName() {
    return packageName;
  }

  /**
   * Immutable. The package name for the app being measured. Example: "com.example.myandroidapp"
   * @param packageName packageName or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData setPackageName(java.lang.String packageName) {
    this.packageName = packageName;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData clone() {
    return (GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData) super.clone();
  }

}
