/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * Data specific to iOS app streams.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData extends com.google.api.client.json.GenericJson {

  /**
   * Required. Immutable. The Apple App Store Bundle ID for the app Example: "com.example.myiosapp"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bundleId;

  /**
   * Output only. ID of the corresponding iOS app in Firebase, if any. This ID can change if the iOS
   * app is deleted and recreated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String firebaseAppId;

  /**
   * Required. Immutable. The Apple App Store Bundle ID for the app Example: "com.example.myiosapp"
   * @return value or {@code null} for none
   */
  public java.lang.String getBundleId() {
    return bundleId;
  }

  /**
   * Required. Immutable. The Apple App Store Bundle ID for the app Example: "com.example.myiosapp"
   * @param bundleId bundleId or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData setBundleId(java.lang.String bundleId) {
    this.bundleId = bundleId;
    return this;
  }

  /**
   * Output only. ID of the corresponding iOS app in Firebase, if any. This ID can change if the iOS
   * app is deleted and recreated.
   * @return value or {@code null} for none
   */
  public java.lang.String getFirebaseAppId() {
    return firebaseAppId;
  }

  /**
   * Output only. ID of the corresponding iOS app in Firebase, if any. This ID can change if the iOS
   * app is deleted and recreated.
   * @param firebaseAppId firebaseAppId or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData setFirebaseAppId(java.lang.String firebaseAppId) {
    this.firebaseAppId = firebaseAppId;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData clone() {
    return (GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData) super.clone();
  }

}
