/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * Data specific to web streams.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaDataStreamWebStreamData extends com.google.api.client.json.GenericJson {

  /**
   * Immutable. Domain name of the web app being measured, or empty. Example:
   * "http://www.google.com", "https://www.google.com"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultUri;

  /**
   * Output only. ID of the corresponding web app in Firebase, if any. This ID can change if the web
   * app is deleted and recreated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String firebaseAppId;

  /**
   * Output only. Analytics "Measurement ID", without the "G-" prefix. Example: "G-1A2BCD345E" would
   * just be "1A2BCD345E"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String measurementId;

  /**
   * Immutable. Domain name of the web app being measured, or empty. Example:
   * "http://www.google.com", "https://www.google.com"
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultUri() {
    return defaultUri;
  }

  /**
   * Immutable. Domain name of the web app being measured, or empty. Example:
   * "http://www.google.com", "https://www.google.com"
   * @param defaultUri defaultUri or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStreamWebStreamData setDefaultUri(java.lang.String defaultUri) {
    this.defaultUri = defaultUri;
    return this;
  }

  /**
   * Output only. ID of the corresponding web app in Firebase, if any. This ID can change if the web
   * app is deleted and recreated.
   * @return value or {@code null} for none
   */
  public java.lang.String getFirebaseAppId() {
    return firebaseAppId;
  }

  /**
   * Output only. ID of the corresponding web app in Firebase, if any. This ID can change if the web
   * app is deleted and recreated.
   * @param firebaseAppId firebaseAppId or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStreamWebStreamData setFirebaseAppId(java.lang.String firebaseAppId) {
    this.firebaseAppId = firebaseAppId;
    return this;
  }

  /**
   * Output only. Analytics "Measurement ID", without the "G-" prefix. Example: "G-1A2BCD345E" would
   * just be "1A2BCD345E"
   * @return value or {@code null} for none
   */
  public java.lang.String getMeasurementId() {
    return measurementId;
  }

  /**
   * Output only. Analytics "Measurement ID", without the "G-" prefix. Example: "G-1A2BCD345E" would
   * just be "1A2BCD345E"
   * @param measurementId measurementId or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStreamWebStreamData setMeasurementId(java.lang.String measurementId) {
    this.measurementId = measurementId;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataStreamWebStreamData set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaDataStreamWebStreamData) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataStreamWebStreamData clone() {
    return (GoogleAnalyticsAdminV1betaDataStreamWebStreamData) super.clone();
  }

}
