/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * A link between a GA4 property and a Firebase project.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaFirebaseLink extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Time when this FirebaseLink was originally created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. Example format: properties/1234/firebaseLinks/5678
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Immutable. Firebase project resource name. When creating a FirebaseLink, you may provide this
   * resource name using either a project number or project ID. Once this resource has been created,
   * returned FirebaseLinks will always have a project_name that contains a project number. Format:
   * 'projects/{project number}' Example: 'projects/1234'
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String project;

  /**
   * Output only. Time when this FirebaseLink was originally created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Time when this FirebaseLink was originally created.
   * @param createTime createTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaFirebaseLink setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. Example format: properties/1234/firebaseLinks/5678
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Example format: properties/1234/firebaseLinks/5678
   * @param name name or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaFirebaseLink setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Immutable. Firebase project resource name. When creating a FirebaseLink, you may provide this
   * resource name using either a project number or project ID. Once this resource has been created,
   * returned FirebaseLinks will always have a project_name that contains a project number. Format:
   * 'projects/{project number}' Example: 'projects/1234'
   * @return value or {@code null} for none
   */
  public java.lang.String getProject() {
    return project;
  }

  /**
   * Immutable. Firebase project resource name. When creating a FirebaseLink, you may provide this
   * resource name using either a project number or project ID. Once this resource has been created,
   * returned FirebaseLinks will always have a project_name that contains a project number. Format:
   * 'projects/{project number}' Example: 'projects/1234'
   * @param project project or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaFirebaseLink setProject(java.lang.String project) {
    this.project = project;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaFirebaseLink set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaFirebaseLink) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaFirebaseLink clone() {
    return (GoogleAnalyticsAdminV1betaFirebaseLink) super.clone();
  }

}
