/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * A link between a GA4 property and a Google Ads account.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaGoogleAdsLink extends com.google.api.client.json.GenericJson {

  /**
   * Enable personalized advertising features with this integration. Automatically publish my Google
   * Analytics audience lists and Google Analytics remarketing events/parameters to the linked
   * Google Ads account. If this field is not set on create/update, it will be defaulted to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean adsPersonalizationEnabled;

  /**
   * Output only. If true, this link is for a Google Ads manager account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canManageClients;

  /**
   * Output only. Time when this link was originally created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. Email address of the user that created the link. An empty string will be returned
   * if the email address can't be retrieved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creatorEmailAddress;

  /**
   * Immutable. Google Ads customer ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customerId;

  /**
   * Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note:
   * googleAdsLinkId is not the Google Ads customer ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. Time when this link was last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Enable personalized advertising features with this integration. Automatically publish my Google
   * Analytics audience lists and Google Analytics remarketing events/parameters to the linked
   * Google Ads account. If this field is not set on create/update, it will be defaulted to true.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAdsPersonalizationEnabled() {
    return adsPersonalizationEnabled;
  }

  /**
   * Enable personalized advertising features with this integration. Automatically publish my Google
   * Analytics audience lists and Google Analytics remarketing events/parameters to the linked
   * Google Ads account. If this field is not set on create/update, it will be defaulted to true.
   * @param adsPersonalizationEnabled adsPersonalizationEnabled or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaGoogleAdsLink setAdsPersonalizationEnabled(java.lang.Boolean adsPersonalizationEnabled) {
    this.adsPersonalizationEnabled = adsPersonalizationEnabled;
    return this;
  }

  /**
   * Output only. If true, this link is for a Google Ads manager account.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanManageClients() {
    return canManageClients;
  }

  /**
   * Output only. If true, this link is for a Google Ads manager account.
   * @param canManageClients canManageClients or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaGoogleAdsLink setCanManageClients(java.lang.Boolean canManageClients) {
    this.canManageClients = canManageClients;
    return this;
  }

  /**
   * Output only. Time when this link was originally created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Time when this link was originally created.
   * @param createTime createTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaGoogleAdsLink setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. Email address of the user that created the link. An empty string will be returned
   * if the email address can't be retrieved.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreatorEmailAddress() {
    return creatorEmailAddress;
  }

  /**
   * Output only. Email address of the user that created the link. An empty string will be returned
   * if the email address can't be retrieved.
   * @param creatorEmailAddress creatorEmailAddress or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaGoogleAdsLink setCreatorEmailAddress(java.lang.String creatorEmailAddress) {
    this.creatorEmailAddress = creatorEmailAddress;
    return this;
  }

  /**
   * Immutable. Google Ads customer ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomerId() {
    return customerId;
  }

  /**
   * Immutable. Google Ads customer ID.
   * @param customerId customerId or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaGoogleAdsLink setCustomerId(java.lang.String customerId) {
    this.customerId = customerId;
    return this;
  }

  /**
   * Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note:
   * googleAdsLinkId is not the Google Ads customer ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note:
   * googleAdsLinkId is not the Google Ads customer ID.
   * @param name name or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaGoogleAdsLink setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. Time when this link was last updated.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. Time when this link was last updated.
   * @param updateTime updateTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaGoogleAdsLink setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaGoogleAdsLink set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaGoogleAdsLink) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaGoogleAdsLink clone() {
    return (GoogleAnalyticsAdminV1betaGoogleAdsLink) super.clone();
  }

}
