/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * A resource message representing a Google Analytics GA4 property.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaProperty extends com.google.api.client.json.GenericJson {

  /**
   * Immutable. The resource name of the parent account Format: accounts/{account_id} Example:
   * "accounts/123"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String account;

  /**
   * Output only. Time when the entity was originally created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The currency type used in reports involving monetary values. Format:
   * https://en.wikipedia.org/wiki/ISO_4217 Examples: "USD", "EUR", "JPY"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currencyCode;

  /**
   * Output only. If set, the time at which this property was trashed. If not set, then this
   * property is not currently in the trash can.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String deleteTime;

  /**
   * Required. Human-readable display name for this property. The max allowed display name length is
   * 100 UTF-16 code units.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. If set, the time at which this trashed property will be permanently deleted. If
   * not set, then this property is not currently in the trash can and is not slated to be deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * Industry associated with this property Example: AUTOMOTIVE, FOOD_AND_DRINK
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String industryCategory;

  /**
   * Output only. Resource name of this property. Format: properties/{property_id} Example:
   * "properties/1000"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Immutable. Resource name of this property's logical parent. Note: The Property-Moving UI can be
   * used to change the parent. Format: accounts/{account}, properties/{property} Example:
   * "accounts/100", "properties/101"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parent;

  /**
   * Immutable. The property type for this Property resource. When creating a property, if the type
   * is "PROPERTY_TYPE_UNSPECIFIED", then "ORDINARY_PROPERTY" will be implied. "SUBPROPERTY" and
   * "ROLLUP_PROPERTY" types cannot yet be created via Google Analytics Admin API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String propertyType;

  /**
   * Output only. The Google Analytics service level that applies to this property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serviceLevel;

  /**
   * Required. Reporting Time Zone, used as the day boundary for reports, regardless of where the
   * data originates. If the time zone honors DST, Analytics will automatically adjust for the
   * changes. NOTE: Changing the time zone only affects data going forward, and is not applied
   * retroactively. Format: https://www.iana.org/time-zones Example: "America/Los_Angeles"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * Output only. Time when entity payload fields were last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Immutable. The resource name of the parent account Format: accounts/{account_id} Example:
   * "accounts/123"
   * @return value or {@code null} for none
   */
  public java.lang.String getAccount() {
    return account;
  }

  /**
   * Immutable. The resource name of the parent account Format: accounts/{account_id} Example:
   * "accounts/123"
   * @param account account or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setAccount(java.lang.String account) {
    this.account = account;
    return this;
  }

  /**
   * Output only. Time when the entity was originally created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Time when the entity was originally created.
   * @param createTime createTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The currency type used in reports involving monetary values. Format:
   * https://en.wikipedia.org/wiki/ISO_4217 Examples: "USD", "EUR", "JPY"
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrencyCode() {
    return currencyCode;
  }

  /**
   * The currency type used in reports involving monetary values. Format:
   * https://en.wikipedia.org/wiki/ISO_4217 Examples: "USD", "EUR", "JPY"
   * @param currencyCode currencyCode or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setCurrencyCode(java.lang.String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Output only. If set, the time at which this property was trashed. If not set, then this
   * property is not currently in the trash can.
   * @return value or {@code null} for none
   */
  public String getDeleteTime() {
    return deleteTime;
  }

  /**
   * Output only. If set, the time at which this property was trashed. If not set, then this
   * property is not currently in the trash can.
   * @param deleteTime deleteTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setDeleteTime(String deleteTime) {
    this.deleteTime = deleteTime;
    return this;
  }

  /**
   * Required. Human-readable display name for this property. The max allowed display name length is
   * 100 UTF-16 code units.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Required. Human-readable display name for this property. The max allowed display name length is
   * 100 UTF-16 code units.
   * @param displayName displayName or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. If set, the time at which this trashed property will be permanently deleted. If
   * not set, then this property is not currently in the trash can and is not slated to be deleted.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * Output only. If set, the time at which this trashed property will be permanently deleted. If
   * not set, then this property is not currently in the trash can and is not slated to be deleted.
   * @param expireTime expireTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * Industry associated with this property Example: AUTOMOTIVE, FOOD_AND_DRINK
   * @return value or {@code null} for none
   */
  public java.lang.String getIndustryCategory() {
    return industryCategory;
  }

  /**
   * Industry associated with this property Example: AUTOMOTIVE, FOOD_AND_DRINK
   * @param industryCategory industryCategory or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setIndustryCategory(java.lang.String industryCategory) {
    this.industryCategory = industryCategory;
    return this;
  }

  /**
   * Output only. Resource name of this property. Format: properties/{property_id} Example:
   * "properties/1000"
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Resource name of this property. Format: properties/{property_id} Example:
   * "properties/1000"
   * @param name name or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Immutable. Resource name of this property's logical parent. Note: The Property-Moving UI can be
   * used to change the parent. Format: accounts/{account}, properties/{property} Example:
   * "accounts/100", "properties/101"
   * @return value or {@code null} for none
   */
  public java.lang.String getParent() {
    return parent;
  }

  /**
   * Immutable. Resource name of this property's logical parent. Note: The Property-Moving UI can be
   * used to change the parent. Format: accounts/{account}, properties/{property} Example:
   * "accounts/100", "properties/101"
   * @param parent parent or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setParent(java.lang.String parent) {
    this.parent = parent;
    return this;
  }

  /**
   * Immutable. The property type for this Property resource. When creating a property, if the type
   * is "PROPERTY_TYPE_UNSPECIFIED", then "ORDINARY_PROPERTY" will be implied. "SUBPROPERTY" and
   * "ROLLUP_PROPERTY" types cannot yet be created via Google Analytics Admin API.
   * @return value or {@code null} for none
   */
  public java.lang.String getPropertyType() {
    return propertyType;
  }

  /**
   * Immutable. The property type for this Property resource. When creating a property, if the type
   * is "PROPERTY_TYPE_UNSPECIFIED", then "ORDINARY_PROPERTY" will be implied. "SUBPROPERTY" and
   * "ROLLUP_PROPERTY" types cannot yet be created via Google Analytics Admin API.
   * @param propertyType propertyType or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setPropertyType(java.lang.String propertyType) {
    this.propertyType = propertyType;
    return this;
  }

  /**
   * Output only. The Google Analytics service level that applies to this property.
   * @return value or {@code null} for none
   */
  public java.lang.String getServiceLevel() {
    return serviceLevel;
  }

  /**
   * Output only. The Google Analytics service level that applies to this property.
   * @param serviceLevel serviceLevel or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setServiceLevel(java.lang.String serviceLevel) {
    this.serviceLevel = serviceLevel;
    return this;
  }

  /**
   * Required. Reporting Time Zone, used as the day boundary for reports, regardless of where the
   * data originates. If the time zone honors DST, Analytics will automatically adjust for the
   * changes. NOTE: Changing the time zone only affects data going forward, and is not applied
   * retroactively. Format: https://www.iana.org/time-zones Example: "America/Los_Angeles"
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * Required. Reporting Time Zone, used as the day boundary for reports, regardless of where the
   * data originates. If the time zone honors DST, Analytics will automatically adjust for the
   * changes. NOTE: Changing the time zone only affects data going forward, and is not applied
   * retroactively. Format: https://www.iana.org/time-zones Example: "America/Los_Angeles"
   * @param timeZone timeZone or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * Output only. Time when entity payload fields were last updated.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. Time when entity payload fields were last updated.
   * @param updateTime updateTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaProperty set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaProperty) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaProperty clone() {
    return (GoogleAnalyticsAdminV1betaProperty) super.clone();
  }

}
