/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * A virtual resource representing metadata for a GA4 property.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaPropertySummary extends com.google.api.client.json.GenericJson {

  /**
   * Display name for the property referred to in this property summary.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Resource name of this property's logical parent. Note: The Property-Moving UI can be used to
   * change the parent. Format: accounts/{account}, properties/{property} Example: "accounts/100",
   * "properties/200"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parent;

  /**
   * Resource name of property referred to by this property summary Format: properties/{property_id}
   * Example: "properties/1000"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String property;

  /**
   * The property's property type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String propertyType;

  /**
   * Display name for the property referred to in this property summary.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Display name for the property referred to in this property summary.
   * @param displayName displayName or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaPropertySummary setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Resource name of this property's logical parent. Note: The Property-Moving UI can be used to
   * change the parent. Format: accounts/{account}, properties/{property} Example: "accounts/100",
   * "properties/200"
   * @return value or {@code null} for none
   */
  public java.lang.String getParent() {
    return parent;
  }

  /**
   * Resource name of this property's logical parent. Note: The Property-Moving UI can be used to
   * change the parent. Format: accounts/{account}, properties/{property} Example: "accounts/100",
   * "properties/200"
   * @param parent parent or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaPropertySummary setParent(java.lang.String parent) {
    this.parent = parent;
    return this;
  }

  /**
   * Resource name of property referred to by this property summary Format: properties/{property_id}
   * Example: "properties/1000"
   * @return value or {@code null} for none
   */
  public java.lang.String getProperty() {
    return property;
  }

  /**
   * Resource name of property referred to by this property summary Format: properties/{property_id}
   * Example: "properties/1000"
   * @param property property or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaPropertySummary setProperty(java.lang.String property) {
    this.property = property;
    return this;
  }

  /**
   * The property's property type.
   * @return value or {@code null} for none
   */
  public java.lang.String getPropertyType() {
    return propertyType;
  }

  /**
   * The property's property type.
   * @param propertyType propertyType or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaPropertySummary setPropertyType(java.lang.String propertyType) {
    this.propertyType = propertyType;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaPropertySummary set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaPropertySummary) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaPropertySummary clone() {
    return (GoogleAnalyticsAdminV1betaPropertySummary) super.clone();
  }

}
