/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta;

/**
 * Service definition for AnalyticsData (v1beta).
 *
 * <p>
 * Accesses report data in Google Analytics.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/analytics/devguides/reporting/data/v1/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link AnalyticsDataRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class AnalyticsData extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Google Analytics Data API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://analyticsdata.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://analyticsdata.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public AnalyticsData(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  AnalyticsData(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Properties collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code AnalyticsData analyticsdata = new AnalyticsData(...);}
   *   {@code AnalyticsData.Properties.List request = analyticsdata.properties().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Properties properties() {
    return new Properties();
  }

  /**
   * The "properties" collection of methods.
   */
  public class Properties {

    /**
     * Returns multiple pivot reports in a batch. All reports must be for the same GA4 Property.
     *
     * Create a request for the method "properties.batchRunPivotReports".
     *
     * This request holds the parameters needed by the analyticsdata server.  After setting any optional
     * parameters, call the {@link BatchRunPivotReports#execute()} method to invoke the remote
     * operation.
     *
     * @param property A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     *        not the body. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). This
     *        property must be specified for the batch. The property within RunPivotReportRequest may
     *        either be unspecified or consistent with this property. Example: properties/1234
     * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.BatchRunPivotReportsRequest}
     * @return the request
     */
    public BatchRunPivotReports batchRunPivotReports(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.BatchRunPivotReportsRequest content) throws java.io.IOException {
      BatchRunPivotReports result = new BatchRunPivotReports(property, content);
      initialize(result);
      return result;
    }

    public class BatchRunPivotReports extends AnalyticsDataRequest<com.google.api.services.analyticsdata.v1beta.model.BatchRunPivotReportsResponse> {

      private static final String REST_PATH = "v1beta/{+property}:batchRunPivotReports";

      private final java.util.regex.Pattern PROPERTY_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+$");

      /**
       * Returns multiple pivot reports in a batch. All reports must be for the same GA4 Property.
       *
       * Create a request for the method "properties.batchRunPivotReports".
       *
       * This request holds the parameters needed by the the analyticsdata server.  After setting any
       * optional parameters, call the {@link BatchRunPivotReports#execute()} method to invoke the
       * remote operation. <p> {@link BatchRunPivotReports#initialize(com.google.api.client.googleapis.s
       * ervices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param property A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     *        not the body. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). This
     *        property must be specified for the batch. The property within RunPivotReportRequest may
     *        either be unspecified or consistent with this property. Example: properties/1234
       * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.BatchRunPivotReportsRequest}
       * @since 1.13
       */
      protected BatchRunPivotReports(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.BatchRunPivotReportsRequest content) {
        super(AnalyticsData.this, "POST", REST_PATH, content, com.google.api.services.analyticsdata.v1beta.model.BatchRunPivotReportsResponse.class);
        this.property = com.google.api.client.util.Preconditions.checkNotNull(property, "Required parameter property must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
      }

      @Override
      public BatchRunPivotReports set$Xgafv(java.lang.String $Xgafv) {
        return (BatchRunPivotReports) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchRunPivotReports setAccessToken(java.lang.String accessToken) {
        return (BatchRunPivotReports) super.setAccessToken(accessToken);
      }

      @Override
      public BatchRunPivotReports setAlt(java.lang.String alt) {
        return (BatchRunPivotReports) super.setAlt(alt);
      }

      @Override
      public BatchRunPivotReports setCallback(java.lang.String callback) {
        return (BatchRunPivotReports) super.setCallback(callback);
      }

      @Override
      public BatchRunPivotReports setFields(java.lang.String fields) {
        return (BatchRunPivotReports) super.setFields(fields);
      }

      @Override
      public BatchRunPivotReports setKey(java.lang.String key) {
        return (BatchRunPivotReports) super.setKey(key);
      }

      @Override
      public BatchRunPivotReports setOauthToken(java.lang.String oauthToken) {
        return (BatchRunPivotReports) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchRunPivotReports setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchRunPivotReports) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchRunPivotReports setQuotaUser(java.lang.String quotaUser) {
        return (BatchRunPivotReports) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchRunPivotReports setUploadType(java.lang.String uploadType) {
        return (BatchRunPivotReports) super.setUploadType(uploadType);
      }

      @Override
      public BatchRunPivotReports setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchRunPivotReports) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL
       * path and not the body. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). This
       * property must be specified for the batch. The property within RunPivotReportRequest may
       * either be unspecified or consistent with this property. Example: properties/1234
       */
      @com.google.api.client.util.Key
      private java.lang.String property;

      /** A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     not the body. To learn more, see [where to find your Property
     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). This property
     must be specified for the batch. The property within RunPivotReportRequest may either be
     unspecified or consistent with this property. Example: properties/1234
       */
      public java.lang.String getProperty() {
        return property;
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL
       * path and not the body. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). This
       * property must be specified for the batch. The property within RunPivotReportRequest may
       * either be unspecified or consistent with this property. Example: properties/1234
       */
      public BatchRunPivotReports setProperty(java.lang.String property) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
        this.property = property;
        return this;
      }

      @Override
      public BatchRunPivotReports set(String parameterName, Object value) {
        return (BatchRunPivotReports) super.set(parameterName, value);
      }
    }
    /**
     * Returns multiple reports in a batch. All reports must be for the same GA4 Property.
     *
     * Create a request for the method "properties.batchRunReports".
     *
     * This request holds the parameters needed by the analyticsdata server.  After setting any optional
     * parameters, call the {@link BatchRunReports#execute()} method to invoke the remote operation.
     *
     * @param property A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     *        not the body. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). This
     *        property must be specified for the batch. The property within RunReportRequest may either
     *        be unspecified or consistent with this property. Example: properties/1234
     * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.BatchRunReportsRequest}
     * @return the request
     */
    public BatchRunReports batchRunReports(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.BatchRunReportsRequest content) throws java.io.IOException {
      BatchRunReports result = new BatchRunReports(property, content);
      initialize(result);
      return result;
    }

    public class BatchRunReports extends AnalyticsDataRequest<com.google.api.services.analyticsdata.v1beta.model.BatchRunReportsResponse> {

      private static final String REST_PATH = "v1beta/{+property}:batchRunReports";

      private final java.util.regex.Pattern PROPERTY_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+$");

      /**
       * Returns multiple reports in a batch. All reports must be for the same GA4 Property.
       *
       * Create a request for the method "properties.batchRunReports".
       *
       * This request holds the parameters needed by the the analyticsdata server.  After setting any
       * optional parameters, call the {@link BatchRunReports#execute()} method to invoke the remote
       * operation. <p> {@link BatchRunReports#initialize(com.google.api.client.googleapis.services.Abst
       * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param property A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     *        not the body. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). This
     *        property must be specified for the batch. The property within RunReportRequest may either
     *        be unspecified or consistent with this property. Example: properties/1234
       * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.BatchRunReportsRequest}
       * @since 1.13
       */
      protected BatchRunReports(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.BatchRunReportsRequest content) {
        super(AnalyticsData.this, "POST", REST_PATH, content, com.google.api.services.analyticsdata.v1beta.model.BatchRunReportsResponse.class);
        this.property = com.google.api.client.util.Preconditions.checkNotNull(property, "Required parameter property must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
      }

      @Override
      public BatchRunReports set$Xgafv(java.lang.String $Xgafv) {
        return (BatchRunReports) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchRunReports setAccessToken(java.lang.String accessToken) {
        return (BatchRunReports) super.setAccessToken(accessToken);
      }

      @Override
      public BatchRunReports setAlt(java.lang.String alt) {
        return (BatchRunReports) super.setAlt(alt);
      }

      @Override
      public BatchRunReports setCallback(java.lang.String callback) {
        return (BatchRunReports) super.setCallback(callback);
      }

      @Override
      public BatchRunReports setFields(java.lang.String fields) {
        return (BatchRunReports) super.setFields(fields);
      }

      @Override
      public BatchRunReports setKey(java.lang.String key) {
        return (BatchRunReports) super.setKey(key);
      }

      @Override
      public BatchRunReports setOauthToken(java.lang.String oauthToken) {
        return (BatchRunReports) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchRunReports setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchRunReports) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchRunReports setQuotaUser(java.lang.String quotaUser) {
        return (BatchRunReports) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchRunReports setUploadType(java.lang.String uploadType) {
        return (BatchRunReports) super.setUploadType(uploadType);
      }

      @Override
      public BatchRunReports setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchRunReports) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL
       * path and not the body. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). This
       * property must be specified for the batch. The property within RunReportRequest may either
       * be unspecified or consistent with this property. Example: properties/1234
       */
      @com.google.api.client.util.Key
      private java.lang.String property;

      /** A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     not the body. To learn more, see [where to find your Property
     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). This property
     must be specified for the batch. The property within RunReportRequest may either be unspecified or
     consistent with this property. Example: properties/1234
       */
      public java.lang.String getProperty() {
        return property;
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL
       * path and not the body. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). This
       * property must be specified for the batch. The property within RunReportRequest may either
       * be unspecified or consistent with this property. Example: properties/1234
       */
      public BatchRunReports setProperty(java.lang.String property) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
        this.property = property;
        return this;
      }

      @Override
      public BatchRunReports set(String parameterName, Object value) {
        return (BatchRunReports) super.set(parameterName, value);
      }
    }
    /**
     * This compatibility method lists dimensions and metrics that can be added to a report request and
     * maintain compatibility. This method fails if the request's dimensions and metrics are
     * incompatible. In Google Analytics, reports fail if they request incompatible dimensions and/or
     * metrics; in that case, you will need to remove dimensions and/or metrics from the incompatible
     * report until the report is compatible. The Realtime and Core reports have different compatibility
     * rules. This method checks compatibility for Core reports.
     *
     * Create a request for the method "properties.checkCompatibility".
     *
     * This request holds the parameters needed by the analyticsdata server.  After setting any optional
     * parameters, call the {@link CheckCompatibility#execute()} method to invoke the remote operation.
     *
     * @param property A Google Analytics GA4 property identifier whose events are tracked. To learn more, see [where to
     *        find your Property ID](https://developers.google.com/analytics/devguides/reporting/data/v1
     *        /property-id). `property` should be the same value as in your `runReport` request.
     *        Example: properties/1234
     * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.CheckCompatibilityRequest}
     * @return the request
     */
    public CheckCompatibility checkCompatibility(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.CheckCompatibilityRequest content) throws java.io.IOException {
      CheckCompatibility result = new CheckCompatibility(property, content);
      initialize(result);
      return result;
    }

    public class CheckCompatibility extends AnalyticsDataRequest<com.google.api.services.analyticsdata.v1beta.model.CheckCompatibilityResponse> {

      private static final String REST_PATH = "v1beta/{+property}:checkCompatibility";

      private final java.util.regex.Pattern PROPERTY_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+$");

      /**
       * This compatibility method lists dimensions and metrics that can be added to a report request
       * and maintain compatibility. This method fails if the request's dimensions and metrics are
       * incompatible. In Google Analytics, reports fail if they request incompatible dimensions and/or
       * metrics; in that case, you will need to remove dimensions and/or metrics from the incompatible
       * report until the report is compatible. The Realtime and Core reports have different
       * compatibility rules. This method checks compatibility for Core reports.
       *
       * Create a request for the method "properties.checkCompatibility".
       *
       * This request holds the parameters needed by the the analyticsdata server.  After setting any
       * optional parameters, call the {@link CheckCompatibility#execute()} method to invoke the remote
       * operation. <p> {@link CheckCompatibility#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param property A Google Analytics GA4 property identifier whose events are tracked. To learn more, see [where to
     *        find your Property ID](https://developers.google.com/analytics/devguides/reporting/data/v1
     *        /property-id). `property` should be the same value as in your `runReport` request.
     *        Example: properties/1234
       * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.CheckCompatibilityRequest}
       * @since 1.13
       */
      protected CheckCompatibility(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.CheckCompatibilityRequest content) {
        super(AnalyticsData.this, "POST", REST_PATH, content, com.google.api.services.analyticsdata.v1beta.model.CheckCompatibilityResponse.class);
        this.property = com.google.api.client.util.Preconditions.checkNotNull(property, "Required parameter property must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
      }

      @Override
      public CheckCompatibility set$Xgafv(java.lang.String $Xgafv) {
        return (CheckCompatibility) super.set$Xgafv($Xgafv);
      }

      @Override
      public CheckCompatibility setAccessToken(java.lang.String accessToken) {
        return (CheckCompatibility) super.setAccessToken(accessToken);
      }

      @Override
      public CheckCompatibility setAlt(java.lang.String alt) {
        return (CheckCompatibility) super.setAlt(alt);
      }

      @Override
      public CheckCompatibility setCallback(java.lang.String callback) {
        return (CheckCompatibility) super.setCallback(callback);
      }

      @Override
      public CheckCompatibility setFields(java.lang.String fields) {
        return (CheckCompatibility) super.setFields(fields);
      }

      @Override
      public CheckCompatibility setKey(java.lang.String key) {
        return (CheckCompatibility) super.setKey(key);
      }

      @Override
      public CheckCompatibility setOauthToken(java.lang.String oauthToken) {
        return (CheckCompatibility) super.setOauthToken(oauthToken);
      }

      @Override
      public CheckCompatibility setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CheckCompatibility) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CheckCompatibility setQuotaUser(java.lang.String quotaUser) {
        return (CheckCompatibility) super.setQuotaUser(quotaUser);
      }

      @Override
      public CheckCompatibility setUploadType(java.lang.String uploadType) {
        return (CheckCompatibility) super.setUploadType(uploadType);
      }

      @Override
      public CheckCompatibility setUploadProtocol(java.lang.String uploadProtocol) {
        return (CheckCompatibility) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. To learn more, see
       * [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
       * `property` should be the same value as in your `runReport` request. Example:
       * properties/1234
       */
      @com.google.api.client.util.Key
      private java.lang.String property;

      /** A Google Analytics GA4 property identifier whose events are tracked. To learn more, see [where to
     find your Property ID](https://developers.google.com/analytics/devguides/reporting/data/v1
     /property-id). `property` should be the same value as in your `runReport` request. Example:
     properties/1234
       */
      public java.lang.String getProperty() {
        return property;
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. To learn more, see
       * [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
       * `property` should be the same value as in your `runReport` request. Example:
       * properties/1234
       */
      public CheckCompatibility setProperty(java.lang.String property) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
        this.property = property;
        return this;
      }

      @Override
      public CheckCompatibility set(String parameterName, Object value) {
        return (CheckCompatibility) super.set(parameterName, value);
      }
    }
    /**
     * Returns metadata for dimensions and metrics available in reporting methods. Used to explore the
     * dimensions and metrics. In this method, a Google Analytics GA4 Property Identifier is specified
     * in the request, and the metadata response includes Custom dimensions and metrics as well as
     * Universal metadata. For example if a custom metric with parameter name `levels_unlocked` is
     * registered to a property, the Metadata response will contain `customEvent:levels_unlocked`.
     * Universal metadata are dimensions and metrics applicable to any property such as `country` and
     * `totalUsers`.
     *
     * Create a request for the method "properties.getMetadata".
     *
     * This request holds the parameters needed by the analyticsdata server.  After setting any optional
     * parameters, call the {@link GetMetadata#execute()} method to invoke the remote operation.
     *
     * @param name Required. The resource name of the metadata to retrieve. This name field is specified in the URL
     *        path and not URL parameters. Property is a numeric Google Analytics GA4 Property
     *        identifier. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *        Example: properties/1234/metadata Set the Property ID to 0 for dimensions and metrics
     *        common to all properties. In this special mode, this method will not return custom
     *        dimensions and metrics.
     * @return the request
     */
    public GetMetadata getMetadata(java.lang.String name) throws java.io.IOException {
      GetMetadata result = new GetMetadata(name);
      initialize(result);
      return result;
    }

    public class GetMetadata extends AnalyticsDataRequest<com.google.api.services.analyticsdata.v1beta.model.Metadata> {

      private static final String REST_PATH = "v1beta/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+/metadata$");

      /**
       * Returns metadata for dimensions and metrics available in reporting methods. Used to explore the
       * dimensions and metrics. In this method, a Google Analytics GA4 Property Identifier is specified
       * in the request, and the metadata response includes Custom dimensions and metrics as well as
       * Universal metadata. For example if a custom metric with parameter name `levels_unlocked` is
       * registered to a property, the Metadata response will contain `customEvent:levels_unlocked`.
       * Universal metadata are dimensions and metrics applicable to any property such as `country` and
       * `totalUsers`.
       *
       * Create a request for the method "properties.getMetadata".
       *
       * This request holds the parameters needed by the the analyticsdata server.  After setting any
       * optional parameters, call the {@link GetMetadata#execute()} method to invoke the remote
       * operation. <p> {@link
       * GetMetadata#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. The resource name of the metadata to retrieve. This name field is specified in the URL
     *        path and not URL parameters. Property is a numeric Google Analytics GA4 Property
     *        identifier. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *        Example: properties/1234/metadata Set the Property ID to 0 for dimensions and metrics
     *        common to all properties. In this special mode, this method will not return custom
     *        dimensions and metrics.
       * @since 1.13
       */
      protected GetMetadata(java.lang.String name) {
        super(AnalyticsData.this, "GET", REST_PATH, null, com.google.api.services.analyticsdata.v1beta.model.Metadata.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+/metadata$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetMetadata set$Xgafv(java.lang.String $Xgafv) {
        return (GetMetadata) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetMetadata setAccessToken(java.lang.String accessToken) {
        return (GetMetadata) super.setAccessToken(accessToken);
      }

      @Override
      public GetMetadata setAlt(java.lang.String alt) {
        return (GetMetadata) super.setAlt(alt);
      }

      @Override
      public GetMetadata setCallback(java.lang.String callback) {
        return (GetMetadata) super.setCallback(callback);
      }

      @Override
      public GetMetadata setFields(java.lang.String fields) {
        return (GetMetadata) super.setFields(fields);
      }

      @Override
      public GetMetadata setKey(java.lang.String key) {
        return (GetMetadata) super.setKey(key);
      }

      @Override
      public GetMetadata setOauthToken(java.lang.String oauthToken) {
        return (GetMetadata) super.setOauthToken(oauthToken);
      }

      @Override
      public GetMetadata setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetMetadata) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetMetadata setQuotaUser(java.lang.String quotaUser) {
        return (GetMetadata) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetMetadata setUploadType(java.lang.String uploadType) {
        return (GetMetadata) super.setUploadType(uploadType);
      }

      @Override
      public GetMetadata setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetMetadata) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. The resource name of the metadata to retrieve. This name field is specified in
       * the URL path and not URL parameters. Property is a numeric Google Analytics GA4 Property
       * identifier. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
       * Example: properties/1234/metadata Set the Property ID to 0 for dimensions and metrics
       * common to all properties. In this special mode, this method will not return custom
       * dimensions and metrics.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The resource name of the metadata to retrieve. This name field is specified in the URL
     path and not URL parameters. Property is a numeric Google Analytics GA4 Property identifier. To
     learn more, see [where to find your Property
     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). Example:
     properties/1234/metadata Set the Property ID to 0 for dimensions and metrics common to all
     properties. In this special mode, this method will not return custom dimensions and metrics.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Required. The resource name of the metadata to retrieve. This name field is specified in
       * the URL path and not URL parameters. Property is a numeric Google Analytics GA4 Property
       * identifier. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
       * Example: properties/1234/metadata Set the Property ID to 0 for dimensions and metrics
       * common to all properties. In this special mode, this method will not return custom
       * dimensions and metrics.
       */
      public GetMetadata setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+/metadata$");
        }
        this.name = name;
        return this;
      }

      @Override
      public GetMetadata set(String parameterName, Object value) {
        return (GetMetadata) super.set(parameterName, value);
      }
    }
    /**
     * Returns a customized pivot report of your Google Analytics event data. Pivot reports are more
     * advanced and expressive formats than regular reports. In a pivot report, dimensions are only
     * visible if they are included in a pivot. Multiple pivots can be specified to further dissect your
     * data.
     *
     * Create a request for the method "properties.runPivotReport".
     *
     * This request holds the parameters needed by the analyticsdata server.  After setting any optional
     * parameters, call the {@link RunPivotReport#execute()} method to invoke the remote operation.
     *
     * @param property A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     *        not the body. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *        Within a batch request, this property should either be unspecified or consistent with the
     *        batch-level property. Example: properties/1234
     * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.RunPivotReportRequest}
     * @return the request
     */
    public RunPivotReport runPivotReport(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.RunPivotReportRequest content) throws java.io.IOException {
      RunPivotReport result = new RunPivotReport(property, content);
      initialize(result);
      return result;
    }

    public class RunPivotReport extends AnalyticsDataRequest<com.google.api.services.analyticsdata.v1beta.model.RunPivotReportResponse> {

      private static final String REST_PATH = "v1beta/{+property}:runPivotReport";

      private final java.util.regex.Pattern PROPERTY_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+$");

      /**
       * Returns a customized pivot report of your Google Analytics event data. Pivot reports are more
       * advanced and expressive formats than regular reports. In a pivot report, dimensions are only
       * visible if they are included in a pivot. Multiple pivots can be specified to further dissect
       * your data.
       *
       * Create a request for the method "properties.runPivotReport".
       *
       * This request holds the parameters needed by the the analyticsdata server.  After setting any
       * optional parameters, call the {@link RunPivotReport#execute()} method to invoke the remote
       * operation. <p> {@link RunPivotReport#initialize(com.google.api.client.googleapis.services.Abstr
       * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param property A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     *        not the body. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *        Within a batch request, this property should either be unspecified or consistent with the
     *        batch-level property. Example: properties/1234
       * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.RunPivotReportRequest}
       * @since 1.13
       */
      protected RunPivotReport(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.RunPivotReportRequest content) {
        super(AnalyticsData.this, "POST", REST_PATH, content, com.google.api.services.analyticsdata.v1beta.model.RunPivotReportResponse.class);
        this.property = com.google.api.client.util.Preconditions.checkNotNull(property, "Required parameter property must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
      }

      @Override
      public RunPivotReport set$Xgafv(java.lang.String $Xgafv) {
        return (RunPivotReport) super.set$Xgafv($Xgafv);
      }

      @Override
      public RunPivotReport setAccessToken(java.lang.String accessToken) {
        return (RunPivotReport) super.setAccessToken(accessToken);
      }

      @Override
      public RunPivotReport setAlt(java.lang.String alt) {
        return (RunPivotReport) super.setAlt(alt);
      }

      @Override
      public RunPivotReport setCallback(java.lang.String callback) {
        return (RunPivotReport) super.setCallback(callback);
      }

      @Override
      public RunPivotReport setFields(java.lang.String fields) {
        return (RunPivotReport) super.setFields(fields);
      }

      @Override
      public RunPivotReport setKey(java.lang.String key) {
        return (RunPivotReport) super.setKey(key);
      }

      @Override
      public RunPivotReport setOauthToken(java.lang.String oauthToken) {
        return (RunPivotReport) super.setOauthToken(oauthToken);
      }

      @Override
      public RunPivotReport setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RunPivotReport) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RunPivotReport setQuotaUser(java.lang.String quotaUser) {
        return (RunPivotReport) super.setQuotaUser(quotaUser);
      }

      @Override
      public RunPivotReport setUploadType(java.lang.String uploadType) {
        return (RunPivotReport) super.setUploadType(uploadType);
      }

      @Override
      public RunPivotReport setUploadProtocol(java.lang.String uploadProtocol) {
        return (RunPivotReport) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL
       * path and not the body. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
       * Within a batch request, this property should either be unspecified or consistent with the
       * batch-level property. Example: properties/1234
       */
      @com.google.api.client.util.Key
      private java.lang.String property;

      /** A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     not the body. To learn more, see [where to find your Property
     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). Within a
     batch request, this property should either be unspecified or consistent with the batch-level
     property. Example: properties/1234
       */
      public java.lang.String getProperty() {
        return property;
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL
       * path and not the body. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
       * Within a batch request, this property should either be unspecified or consistent with the
       * batch-level property. Example: properties/1234
       */
      public RunPivotReport setProperty(java.lang.String property) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
        this.property = property;
        return this;
      }

      @Override
      public RunPivotReport set(String parameterName, Object value) {
        return (RunPivotReport) super.set(parameterName, value);
      }
    }
    /**
     * Returns a customized report of realtime event data for your property. Events appear in realtime
     * reports seconds after they have been sent to the Google Analytics. Realtime reports show events
     * and usage data for the periods of time ranging from the present moment to 30 minutes ago (up to
     * 60 minutes for Google Analytics 360 properties). For a guide to constructing realtime requests &
     * understanding responses, see [Creating a Realtime
     * Report](https://developers.google.com/analytics/devguides/reporting/data/v1/realtime-basics).
     *
     * Create a request for the method "properties.runRealtimeReport".
     *
     * This request holds the parameters needed by the analyticsdata server.  After setting any optional
     * parameters, call the {@link RunRealtimeReport#execute()} method to invoke the remote operation.
     *
     * @param property A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     *        not the body. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *        Example: properties/1234
     * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.RunRealtimeReportRequest}
     * @return the request
     */
    public RunRealtimeReport runRealtimeReport(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.RunRealtimeReportRequest content) throws java.io.IOException {
      RunRealtimeReport result = new RunRealtimeReport(property, content);
      initialize(result);
      return result;
    }

    public class RunRealtimeReport extends AnalyticsDataRequest<com.google.api.services.analyticsdata.v1beta.model.RunRealtimeReportResponse> {

      private static final String REST_PATH = "v1beta/{+property}:runRealtimeReport";

      private final java.util.regex.Pattern PROPERTY_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+$");

      /**
       * Returns a customized report of realtime event data for your property. Events appear in realtime
       * reports seconds after they have been sent to the Google Analytics. Realtime reports show events
       * and usage data for the periods of time ranging from the present moment to 30 minutes ago (up to
       * 60 minutes for Google Analytics 360 properties). For a guide to constructing realtime requests
       * & understanding responses, see [Creating a Realtime
       * Report](https://developers.google.com/analytics/devguides/reporting/data/v1/realtime-basics).
       *
       * Create a request for the method "properties.runRealtimeReport".
       *
       * This request holds the parameters needed by the the analyticsdata server.  After setting any
       * optional parameters, call the {@link RunRealtimeReport#execute()} method to invoke the remote
       * operation. <p> {@link RunRealtimeReport#initialize(com.google.api.client.googleapis.services.Ab
       * stractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param property A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     *        not the body. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *        Example: properties/1234
       * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.RunRealtimeReportRequest}
       * @since 1.13
       */
      protected RunRealtimeReport(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.RunRealtimeReportRequest content) {
        super(AnalyticsData.this, "POST", REST_PATH, content, com.google.api.services.analyticsdata.v1beta.model.RunRealtimeReportResponse.class);
        this.property = com.google.api.client.util.Preconditions.checkNotNull(property, "Required parameter property must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
      }

      @Override
      public RunRealtimeReport set$Xgafv(java.lang.String $Xgafv) {
        return (RunRealtimeReport) super.set$Xgafv($Xgafv);
      }

      @Override
      public RunRealtimeReport setAccessToken(java.lang.String accessToken) {
        return (RunRealtimeReport) super.setAccessToken(accessToken);
      }

      @Override
      public RunRealtimeReport setAlt(java.lang.String alt) {
        return (RunRealtimeReport) super.setAlt(alt);
      }

      @Override
      public RunRealtimeReport setCallback(java.lang.String callback) {
        return (RunRealtimeReport) super.setCallback(callback);
      }

      @Override
      public RunRealtimeReport setFields(java.lang.String fields) {
        return (RunRealtimeReport) super.setFields(fields);
      }

      @Override
      public RunRealtimeReport setKey(java.lang.String key) {
        return (RunRealtimeReport) super.setKey(key);
      }

      @Override
      public RunRealtimeReport setOauthToken(java.lang.String oauthToken) {
        return (RunRealtimeReport) super.setOauthToken(oauthToken);
      }

      @Override
      public RunRealtimeReport setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RunRealtimeReport) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RunRealtimeReport setQuotaUser(java.lang.String quotaUser) {
        return (RunRealtimeReport) super.setQuotaUser(quotaUser);
      }

      @Override
      public RunRealtimeReport setUploadType(java.lang.String uploadType) {
        return (RunRealtimeReport) super.setUploadType(uploadType);
      }

      @Override
      public RunRealtimeReport setUploadProtocol(java.lang.String uploadProtocol) {
        return (RunRealtimeReport) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL
       * path and not the body. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
       * Example: properties/1234
       */
      @com.google.api.client.util.Key
      private java.lang.String property;

      /** A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     not the body. To learn more, see [where to find your Property
     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). Example:
     properties/1234
       */
      public java.lang.String getProperty() {
        return property;
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL
       * path and not the body. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
       * Example: properties/1234
       */
      public RunRealtimeReport setProperty(java.lang.String property) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
        this.property = property;
        return this;
      }

      @Override
      public RunRealtimeReport set(String parameterName, Object value) {
        return (RunRealtimeReport) super.set(parameterName, value);
      }
    }
    /**
     * Returns a customized report of your Google Analytics event data. Reports contain statistics
     * derived from data collected by the Google Analytics tracking code. The data returned from the API
     * is as a table with columns for the requested dimensions and metrics. Metrics are individual
     * measurements of user activity on your property, such as active users or event count. Dimensions
     * break down metrics across some common criteria, such as country or event name. For a guide to
     * constructing requests & understanding responses, see [Creating a
     * Report](https://developers.google.com/analytics/devguides/reporting/data/v1/basics).
     *
     * Create a request for the method "properties.runReport".
     *
     * This request holds the parameters needed by the analyticsdata server.  After setting any optional
     * parameters, call the {@link RunReport#execute()} method to invoke the remote operation.
     *
     * @param property A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     *        not the body. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *        Within a batch request, this property should either be unspecified or consistent with the
     *        batch-level property. Example: properties/1234
     * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.RunReportRequest}
     * @return the request
     */
    public RunReport runReport(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.RunReportRequest content) throws java.io.IOException {
      RunReport result = new RunReport(property, content);
      initialize(result);
      return result;
    }

    public class RunReport extends AnalyticsDataRequest<com.google.api.services.analyticsdata.v1beta.model.RunReportResponse> {

      private static final String REST_PATH = "v1beta/{+property}:runReport";

      private final java.util.regex.Pattern PROPERTY_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+$");

      /**
       * Returns a customized report of your Google Analytics event data. Reports contain statistics
       * derived from data collected by the Google Analytics tracking code. The data returned from the
       * API is as a table with columns for the requested dimensions and metrics. Metrics are individual
       * measurements of user activity on your property, such as active users or event count. Dimensions
       * break down metrics across some common criteria, such as country or event name. For a guide to
       * constructing requests & understanding responses, see [Creating a
       * Report](https://developers.google.com/analytics/devguides/reporting/data/v1/basics).
       *
       * Create a request for the method "properties.runReport".
       *
       * This request holds the parameters needed by the the analyticsdata server.  After setting any
       * optional parameters, call the {@link RunReport#execute()} method to invoke the remote
       * operation. <p> {@link
       * RunReport#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param property A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     *        not the body. To learn more, see [where to find your Property
     *        ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *        Within a batch request, this property should either be unspecified or consistent with the
     *        batch-level property. Example: properties/1234
       * @param content the {@link com.google.api.services.analyticsdata.v1beta.model.RunReportRequest}
       * @since 1.13
       */
      protected RunReport(java.lang.String property, com.google.api.services.analyticsdata.v1beta.model.RunReportRequest content) {
        super(AnalyticsData.this, "POST", REST_PATH, content, com.google.api.services.analyticsdata.v1beta.model.RunReportResponse.class);
        this.property = com.google.api.client.util.Preconditions.checkNotNull(property, "Required parameter property must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
      }

      @Override
      public RunReport set$Xgafv(java.lang.String $Xgafv) {
        return (RunReport) super.set$Xgafv($Xgafv);
      }

      @Override
      public RunReport setAccessToken(java.lang.String accessToken) {
        return (RunReport) super.setAccessToken(accessToken);
      }

      @Override
      public RunReport setAlt(java.lang.String alt) {
        return (RunReport) super.setAlt(alt);
      }

      @Override
      public RunReport setCallback(java.lang.String callback) {
        return (RunReport) super.setCallback(callback);
      }

      @Override
      public RunReport setFields(java.lang.String fields) {
        return (RunReport) super.setFields(fields);
      }

      @Override
      public RunReport setKey(java.lang.String key) {
        return (RunReport) super.setKey(key);
      }

      @Override
      public RunReport setOauthToken(java.lang.String oauthToken) {
        return (RunReport) super.setOauthToken(oauthToken);
      }

      @Override
      public RunReport setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RunReport) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RunReport setQuotaUser(java.lang.String quotaUser) {
        return (RunReport) super.setQuotaUser(quotaUser);
      }

      @Override
      public RunReport setUploadType(java.lang.String uploadType) {
        return (RunReport) super.setUploadType(uploadType);
      }

      @Override
      public RunReport setUploadProtocol(java.lang.String uploadProtocol) {
        return (RunReport) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL
       * path and not the body. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
       * Within a batch request, this property should either be unspecified or consistent with the
       * batch-level property. Example: properties/1234
       */
      @com.google.api.client.util.Key
      private java.lang.String property;

      /** A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL path and
     not the body. To learn more, see [where to find your Property
     ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id). Within a
     batch request, this property should either be unspecified or consistent with the batch-level
     property. Example: properties/1234
       */
      public java.lang.String getProperty() {
        return property;
      }

      /**
       * A Google Analytics GA4 property identifier whose events are tracked. Specified in the URL
       * path and not the body. To learn more, see [where to find your Property
       * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
       * Within a batch request, this property should either be unspecified or consistent with the
       * batch-level property. Example: properties/1234
       */
      public RunReport setProperty(java.lang.String property) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
        this.property = property;
        return this;
      }

      @Override
      public RunReport set(String parameterName, Object value) {
        return (RunReport) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link AnalyticsData}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link AnalyticsData}. */
    @Override
    public AnalyticsData build() {
      return new AnalyticsData(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link AnalyticsDataRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setAnalyticsDataRequestInitializer(
        AnalyticsDataRequestInitializer analyticsdataRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(analyticsdataRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
