/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * The request for compatibility information for a report's dimensions and metrics. Check
 * compatibility provides a preview of the compatibility of a report; fields shared with the
 * `runReport` request should be the same values as in your `runReport` request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CheckCompatibilityRequest extends com.google.api.client.json.GenericJson {

  /**
   * Filters the dimensions and metrics in the response to just this compatibility. Commonly used as
   * `”compatibilityFilter”: “COMPATIBLE”` to only return compatible dimensions & metrics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String compatibilityFilter;

  /**
   * The filter clause of dimensions. `dimensionFilter` should be the same value as in your
   * `runReport` request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FilterExpression dimensionFilter;

  /**
   * The dimensions in this report. `dimensions` should be the same value as in your `runReport`
   * request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Dimension> dimensions;

  /**
   * The filter clause of metrics. `metricFilter` should be the same value as in your `runReport`
   * request
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FilterExpression metricFilter;

  /**
   * The metrics in this report. `metrics` should be the same value as in your `runReport` request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Metric> metrics;

  /**
   * Filters the dimensions and metrics in the response to just this compatibility. Commonly used as
   * `”compatibilityFilter”: “COMPATIBLE”` to only return compatible dimensions & metrics.
   * @return value or {@code null} for none
   */
  public java.lang.String getCompatibilityFilter() {
    return compatibilityFilter;
  }

  /**
   * Filters the dimensions and metrics in the response to just this compatibility. Commonly used as
   * `”compatibilityFilter”: “COMPATIBLE”` to only return compatible dimensions & metrics.
   * @param compatibilityFilter compatibilityFilter or {@code null} for none
   */
  public CheckCompatibilityRequest setCompatibilityFilter(java.lang.String compatibilityFilter) {
    this.compatibilityFilter = compatibilityFilter;
    return this;
  }

  /**
   * The filter clause of dimensions. `dimensionFilter` should be the same value as in your
   * `runReport` request.
   * @return value or {@code null} for none
   */
  public FilterExpression getDimensionFilter() {
    return dimensionFilter;
  }

  /**
   * The filter clause of dimensions. `dimensionFilter` should be the same value as in your
   * `runReport` request.
   * @param dimensionFilter dimensionFilter or {@code null} for none
   */
  public CheckCompatibilityRequest setDimensionFilter(FilterExpression dimensionFilter) {
    this.dimensionFilter = dimensionFilter;
    return this;
  }

  /**
   * The dimensions in this report. `dimensions` should be the same value as in your `runReport`
   * request.
   * @return value or {@code null} for none
   */
  public java.util.List<Dimension> getDimensions() {
    return dimensions;
  }

  /**
   * The dimensions in this report. `dimensions` should be the same value as in your `runReport`
   * request.
   * @param dimensions dimensions or {@code null} for none
   */
  public CheckCompatibilityRequest setDimensions(java.util.List<Dimension> dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * The filter clause of metrics. `metricFilter` should be the same value as in your `runReport`
   * request
   * @return value or {@code null} for none
   */
  public FilterExpression getMetricFilter() {
    return metricFilter;
  }

  /**
   * The filter clause of metrics. `metricFilter` should be the same value as in your `runReport`
   * request
   * @param metricFilter metricFilter or {@code null} for none
   */
  public CheckCompatibilityRequest setMetricFilter(FilterExpression metricFilter) {
    this.metricFilter = metricFilter;
    return this;
  }

  /**
   * The metrics in this report. `metrics` should be the same value as in your `runReport` request.
   * @return value or {@code null} for none
   */
  public java.util.List<Metric> getMetrics() {
    return metrics;
  }

  /**
   * The metrics in this report. `metrics` should be the same value as in your `runReport` request.
   * @param metrics metrics or {@code null} for none
   */
  public CheckCompatibilityRequest setMetrics(java.util.List<Metric> metrics) {
    this.metrics = metrics;
    return this;
  }

  @Override
  public CheckCompatibilityRequest set(String fieldName, Object value) {
    return (CheckCompatibilityRequest) super.set(fieldName, value);
  }

  @Override
  public CheckCompatibilityRequest clone() {
    return (CheckCompatibilityRequest) super.clone();
  }

}
