/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * The compatibility response with the compatibility of each dimension & metric.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CheckCompatibilityResponse extends com.google.api.client.json.GenericJson {

  /**
   * The compatibility of each dimension.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DimensionCompatibility> dimensionCompatibilities;

  /**
   * The compatibility of each metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MetricCompatibility> metricCompatibilities;

  /**
   * The compatibility of each dimension.
   * @return value or {@code null} for none
   */
  public java.util.List<DimensionCompatibility> getDimensionCompatibilities() {
    return dimensionCompatibilities;
  }

  /**
   * The compatibility of each dimension.
   * @param dimensionCompatibilities dimensionCompatibilities or {@code null} for none
   */
  public CheckCompatibilityResponse setDimensionCompatibilities(java.util.List<DimensionCompatibility> dimensionCompatibilities) {
    this.dimensionCompatibilities = dimensionCompatibilities;
    return this;
  }

  /**
   * The compatibility of each metric.
   * @return value or {@code null} for none
   */
  public java.util.List<MetricCompatibility> getMetricCompatibilities() {
    return metricCompatibilities;
  }

  /**
   * The compatibility of each metric.
   * @param metricCompatibilities metricCompatibilities or {@code null} for none
   */
  public CheckCompatibilityResponse setMetricCompatibilities(java.util.List<MetricCompatibility> metricCompatibilities) {
    this.metricCompatibilities = metricCompatibilities;
    return this;
  }

  @Override
  public CheckCompatibilityResponse set(String fieldName, Object value) {
    return (CheckCompatibilityResponse) super.set(fieldName, value);
  }

  @Override
  public CheckCompatibilityResponse clone() {
    return (CheckCompatibilityResponse) super.clone();
  }

}
