/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * Configures the extended reporting date range for a cohort report. Specifies an offset duration to
 * follow the cohorts over.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CohortsRange extends com.google.api.client.json.GenericJson {

  /**
   * Required. `endOffset` specifies the end date of the extended reporting date range for a cohort
   * report. `endOffset` can be any positive integer but is commonly set to 5 to 10 so that reports
   * contain data on the cohort for the next several granularity time periods. If `granularity` is
   * `DAILY`, the `endDate` of the extended reporting date range is `endDate` of the cohort plus
   * `endOffset` days. If `granularity` is `WEEKLY`, the `endDate` of the extended reporting date
   * range is `endDate` of the cohort plus `endOffset * 7` days. If `granularity` is `MONTHLY`, the
   * `endDate` of the extended reporting date range is `endDate` of the cohort plus `endOffset * 30`
   * days.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer endOffset;

  /**
   * Required. The granularity used to interpret the `startOffset` and `endOffset` for the extended
   * reporting date range for a cohort report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String granularity;

  /**
   * `startOffset` specifies the start date of the extended reporting date range for a cohort
   * report. `startOffset` is commonly set to 0 so that reports contain data from the acquisition of
   * the cohort forward. If `granularity` is `DAILY`, the `startDate` of the extended reporting date
   * range is `startDate` of the cohort plus `startOffset` days. If `granularity` is `WEEKLY`, the
   * `startDate` of the extended reporting date range is `startDate` of the cohort plus `startOffset
   * * 7` days. If `granularity` is `MONTHLY`, the `startDate` of the extended reporting date range
   * is `startDate` of the cohort plus `startOffset * 30` days.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startOffset;

  /**
   * Required. `endOffset` specifies the end date of the extended reporting date range for a cohort
   * report. `endOffset` can be any positive integer but is commonly set to 5 to 10 so that reports
   * contain data on the cohort for the next several granularity time periods. If `granularity` is
   * `DAILY`, the `endDate` of the extended reporting date range is `endDate` of the cohort plus
   * `endOffset` days. If `granularity` is `WEEKLY`, the `endDate` of the extended reporting date
   * range is `endDate` of the cohort plus `endOffset * 7` days. If `granularity` is `MONTHLY`, the
   * `endDate` of the extended reporting date range is `endDate` of the cohort plus `endOffset * 30`
   * days.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getEndOffset() {
    return endOffset;
  }

  /**
   * Required. `endOffset` specifies the end date of the extended reporting date range for a cohort
   * report. `endOffset` can be any positive integer but is commonly set to 5 to 10 so that reports
   * contain data on the cohort for the next several granularity time periods. If `granularity` is
   * `DAILY`, the `endDate` of the extended reporting date range is `endDate` of the cohort plus
   * `endOffset` days. If `granularity` is `WEEKLY`, the `endDate` of the extended reporting date
   * range is `endDate` of the cohort plus `endOffset * 7` days. If `granularity` is `MONTHLY`, the
   * `endDate` of the extended reporting date range is `endDate` of the cohort plus `endOffset * 30`
   * days.
   * @param endOffset endOffset or {@code null} for none
   */
  public CohortsRange setEndOffset(java.lang.Integer endOffset) {
    this.endOffset = endOffset;
    return this;
  }

  /**
   * Required. The granularity used to interpret the `startOffset` and `endOffset` for the extended
   * reporting date range for a cohort report.
   * @return value or {@code null} for none
   */
  public java.lang.String getGranularity() {
    return granularity;
  }

  /**
   * Required. The granularity used to interpret the `startOffset` and `endOffset` for the extended
   * reporting date range for a cohort report.
   * @param granularity granularity or {@code null} for none
   */
  public CohortsRange setGranularity(java.lang.String granularity) {
    this.granularity = granularity;
    return this;
  }

  /**
   * `startOffset` specifies the start date of the extended reporting date range for a cohort
   * report. `startOffset` is commonly set to 0 so that reports contain data from the acquisition of
   * the cohort forward. If `granularity` is `DAILY`, the `startDate` of the extended reporting date
   * range is `startDate` of the cohort plus `startOffset` days. If `granularity` is `WEEKLY`, the
   * `startDate` of the extended reporting date range is `startDate` of the cohort plus `startOffset
   * * 7` days. If `granularity` is `MONTHLY`, the `startDate` of the extended reporting date range
   * is `startDate` of the cohort plus `startOffset * 30` days.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartOffset() {
    return startOffset;
  }

  /**
   * `startOffset` specifies the start date of the extended reporting date range for a cohort
   * report. `startOffset` is commonly set to 0 so that reports contain data from the acquisition of
   * the cohort forward. If `granularity` is `DAILY`, the `startDate` of the extended reporting date
   * range is `startDate` of the cohort plus `startOffset` days. If `granularity` is `WEEKLY`, the
   * `startDate` of the extended reporting date range is `startDate` of the cohort plus `startOffset
   * * 7` days. If `granularity` is `MONTHLY`, the `startDate` of the extended reporting date range
   * is `startDate` of the cohort plus `startOffset * 30` days.
   * @param startOffset startOffset or {@code null} for none
   */
  public CohortsRange setStartOffset(java.lang.Integer startOffset) {
    this.startOffset = startOffset;
    return this;
  }

  @Override
  public CohortsRange set(String fieldName, Object value) {
    return (CohortsRange) super.set(fieldName, value);
  }

  @Override
  public CohortsRange clone() {
    return (CohortsRange) super.clone();
  }

}
