/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * Used to combine dimension values to a single dimension.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConcatenateExpression extends com.google.api.client.json.GenericJson {

  /**
   * The delimiter placed between dimension names. Delimiters are often single characters such as
   * "|" or "," but can be longer strings. If a dimension value contains the delimiter, both will be
   * present in response with no distinction. For example if dimension 1 value = "US,FR", dimension
   * 2 value = "JP", and delimiter = ",", then the response will contain "US,FR,JP".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String delimiter;

  /**
   * Names of dimensions. The names must refer back to names in the dimensions field of the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> dimensionNames;

  /**
   * The delimiter placed between dimension names. Delimiters are often single characters such as
   * "|" or "," but can be longer strings. If a dimension value contains the delimiter, both will be
   * present in response with no distinction. For example if dimension 1 value = "US,FR", dimension
   * 2 value = "JP", and delimiter = ",", then the response will contain "US,FR,JP".
   * @return value or {@code null} for none
   */
  public java.lang.String getDelimiter() {
    return delimiter;
  }

  /**
   * The delimiter placed between dimension names. Delimiters are often single characters such as
   * "|" or "," but can be longer strings. If a dimension value contains the delimiter, both will be
   * present in response with no distinction. For example if dimension 1 value = "US,FR", dimension
   * 2 value = "JP", and delimiter = ",", then the response will contain "US,FR,JP".
   * @param delimiter delimiter or {@code null} for none
   */
  public ConcatenateExpression setDelimiter(java.lang.String delimiter) {
    this.delimiter = delimiter;
    return this;
  }

  /**
   * Names of dimensions. The names must refer back to names in the dimensions field of the request.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDimensionNames() {
    return dimensionNames;
  }

  /**
   * Names of dimensions. The names must refer back to names in the dimensions field of the request.
   * @param dimensionNames dimensionNames or {@code null} for none
   */
  public ConcatenateExpression setDimensionNames(java.util.List<java.lang.String> dimensionNames) {
    this.dimensionNames = dimensionNames;
    return this;
  }

  @Override
  public ConcatenateExpression set(String fieldName, Object value) {
    return (ConcatenateExpression) super.set(fieldName, value);
  }

  @Override
  public ConcatenateExpression clone() {
    return (ConcatenateExpression) super.clone();
  }

}
