/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * A contiguous set of days: startDate, startDate + 1, ..., endDate. Requests are allowed up to 4
 * date ranges.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DateRange extends com.google.api.client.json.GenericJson {

  /**
   * The inclusive end date for the query in the format `YYYY-MM-DD`. Cannot be before `start_date`.
   * The format `NdaysAgo`, `yesterday`, or `today` is also accepted, and in that case, the date is
   * inferred based on the property's reporting time zone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endDate;

  /**
   * Assigns a name to this date range. The dimension `dateRange` is valued to this name in a report
   * response. If set, cannot begin with `date_range_` or `RESERVED_`. If not set, date ranges are
   * named by their zero based index in the request: `date_range_0`, `date_range_1`, etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The inclusive start date for the query in the format `YYYY-MM-DD`. Cannot be after `end_date`.
   * The format `NdaysAgo`, `yesterday`, or `today` is also accepted, and in that case, the date is
   * inferred based on the property's reporting time zone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startDate;

  /**
   * The inclusive end date for the query in the format `YYYY-MM-DD`. Cannot be before `start_date`.
   * The format `NdaysAgo`, `yesterday`, or `today` is also accepted, and in that case, the date is
   * inferred based on the property's reporting time zone.
   * @return value or {@code null} for none
   */
  public java.lang.String getEndDate() {
    return endDate;
  }

  /**
   * The inclusive end date for the query in the format `YYYY-MM-DD`. Cannot be before `start_date`.
   * The format `NdaysAgo`, `yesterday`, or `today` is also accepted, and in that case, the date is
   * inferred based on the property's reporting time zone.
   * @param endDate endDate or {@code null} for none
   */
  public DateRange setEndDate(java.lang.String endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * Assigns a name to this date range. The dimension `dateRange` is valued to this name in a report
   * response. If set, cannot begin with `date_range_` or `RESERVED_`. If not set, date ranges are
   * named by their zero based index in the request: `date_range_0`, `date_range_1`, etc.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Assigns a name to this date range. The dimension `dateRange` is valued to this name in a report
   * response. If set, cannot begin with `date_range_` or `RESERVED_`. If not set, date ranges are
   * named by their zero based index in the request: `date_range_0`, `date_range_1`, etc.
   * @param name name or {@code null} for none
   */
  public DateRange setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The inclusive start date for the query in the format `YYYY-MM-DD`. Cannot be after `end_date`.
   * The format `NdaysAgo`, `yesterday`, or `today` is also accepted, and in that case, the date is
   * inferred based on the property's reporting time zone.
   * @return value or {@code null} for none
   */
  public java.lang.String getStartDate() {
    return startDate;
  }

  /**
   * The inclusive start date for the query in the format `YYYY-MM-DD`. Cannot be after `end_date`.
   * The format `NdaysAgo`, `yesterday`, or `today` is also accepted, and in that case, the date is
   * inferred based on the property's reporting time zone.
   * @param startDate startDate or {@code null} for none
   */
  public DateRange setStartDate(java.lang.String startDate) {
    this.startDate = startDate;
    return this;
  }

  @Override
  public DateRange set(String fieldName, Object value) {
    return (DateRange) super.set(fieldName, value);
  }

  @Override
  public DateRange clone() {
    return (DateRange) super.clone();
  }

}
