/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * The compatibility for a single dimension.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DimensionCompatibility extends com.google.api.client.json.GenericJson {

  /**
   * The compatibility of this dimension. If the compatibility is COMPATIBLE, this dimension can be
   * successfully added to the report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String compatibility;

  /**
   * The dimension metadata contains the API name for this compatibility information. The dimension
   * metadata also contains other helpful information like the UI name and description.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionMetadata dimensionMetadata;

  /**
   * The compatibility of this dimension. If the compatibility is COMPATIBLE, this dimension can be
   * successfully added to the report.
   * @return value or {@code null} for none
   */
  public java.lang.String getCompatibility() {
    return compatibility;
  }

  /**
   * The compatibility of this dimension. If the compatibility is COMPATIBLE, this dimension can be
   * successfully added to the report.
   * @param compatibility compatibility or {@code null} for none
   */
  public DimensionCompatibility setCompatibility(java.lang.String compatibility) {
    this.compatibility = compatibility;
    return this;
  }

  /**
   * The dimension metadata contains the API name for this compatibility information. The dimension
   * metadata also contains other helpful information like the UI name and description.
   * @return value or {@code null} for none
   */
  public DimensionMetadata getDimensionMetadata() {
    return dimensionMetadata;
  }

  /**
   * The dimension metadata contains the API name for this compatibility information. The dimension
   * metadata also contains other helpful information like the UI name and description.
   * @param dimensionMetadata dimensionMetadata or {@code null} for none
   */
  public DimensionCompatibility setDimensionMetadata(DimensionMetadata dimensionMetadata) {
    this.dimensionMetadata = dimensionMetadata;
    return this;
  }

  @Override
  public DimensionCompatibility set(String fieldName, Object value) {
    return (DimensionCompatibility) super.set(fieldName, value);
  }

  @Override
  public DimensionCompatibility clone() {
    return (DimensionCompatibility) super.clone();
  }

}
