/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * Used to express a dimension which is the result of a formula of multiple dimensions. Example
 * usages: 1) lower_case(dimension) 2) concatenate(dimension1, symbol, dimension2).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DimensionExpression extends com.google.api.client.json.GenericJson {

  /**
   * Used to combine dimension values to a single dimension. For example, dimension "country, city":
   * concatenate(country, ", ", city).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConcatenateExpression concatenate;

  /**
   * Used to convert a dimension value to lower case.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CaseExpression lowerCase;

  /**
   * Used to convert a dimension value to upper case.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CaseExpression upperCase;

  /**
   * Used to combine dimension values to a single dimension. For example, dimension "country, city":
   * concatenate(country, ", ", city).
   * @return value or {@code null} for none
   */
  public ConcatenateExpression getConcatenate() {
    return concatenate;
  }

  /**
   * Used to combine dimension values to a single dimension. For example, dimension "country, city":
   * concatenate(country, ", ", city).
   * @param concatenate concatenate or {@code null} for none
   */
  public DimensionExpression setConcatenate(ConcatenateExpression concatenate) {
    this.concatenate = concatenate;
    return this;
  }

  /**
   * Used to convert a dimension value to lower case.
   * @return value or {@code null} for none
   */
  public CaseExpression getLowerCase() {
    return lowerCase;
  }

  /**
   * Used to convert a dimension value to lower case.
   * @param lowerCase lowerCase or {@code null} for none
   */
  public DimensionExpression setLowerCase(CaseExpression lowerCase) {
    this.lowerCase = lowerCase;
    return this;
  }

  /**
   * Used to convert a dimension value to upper case.
   * @return value or {@code null} for none
   */
  public CaseExpression getUpperCase() {
    return upperCase;
  }

  /**
   * Used to convert a dimension value to upper case.
   * @param upperCase upperCase or {@code null} for none
   */
  public DimensionExpression setUpperCase(CaseExpression upperCase) {
    this.upperCase = upperCase;
    return this;
  }

  @Override
  public DimensionExpression set(String fieldName, Object value) {
    return (DimensionExpression) super.set(fieldName, value);
  }

  @Override
  public DimensionExpression clone() {
    return (DimensionExpression) super.clone();
  }

}
