/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * Sorts by dimension values.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DimensionOrderBy extends com.google.api.client.json.GenericJson {

  /**
   * A dimension name in the request to order by.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dimensionName;

  /**
   * Controls the rule for dimension value ordering.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String orderType;

  /**
   * A dimension name in the request to order by.
   * @return value or {@code null} for none
   */
  public java.lang.String getDimensionName() {
    return dimensionName;
  }

  /**
   * A dimension name in the request to order by.
   * @param dimensionName dimensionName or {@code null} for none
   */
  public DimensionOrderBy setDimensionName(java.lang.String dimensionName) {
    this.dimensionName = dimensionName;
    return this;
  }

  /**
   * Controls the rule for dimension value ordering.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrderType() {
    return orderType;
  }

  /**
   * Controls the rule for dimension value ordering.
   * @param orderType orderType or {@code null} for none
   */
  public DimensionOrderBy setOrderType(java.lang.String orderType) {
    this.orderType = orderType;
    return this;
  }

  @Override
  public DimensionOrderBy set(String fieldName, Object value) {
    return (DimensionOrderBy) super.set(fieldName, value);
  }

  @Override
  public DimensionOrderBy clone() {
    return (DimensionOrderBy) super.clone();
  }

}
