/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * An expression to filter dimension or metric values.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Filter extends com.google.api.client.json.GenericJson {

  /**
   * A filter for two values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BetweenFilter betweenFilter;

  /**
   * The dimension name or metric name. In most methods, dimensions & metrics can be used for the
   * first time in this field. However in a RunPivotReportRequest, this field must be additionally
   * specified by name in the RunPivotReportRequest's dimensions or metrics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fieldName;

  /**
   * A filter for in list values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InListFilter inListFilter;

  /**
   * A filter for numeric or date values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NumericFilter numericFilter;

  /**
   * Strings related filter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StringFilter stringFilter;

  /**
   * A filter for two values.
   * @return value or {@code null} for none
   */
  public BetweenFilter getBetweenFilter() {
    return betweenFilter;
  }

  /**
   * A filter for two values.
   * @param betweenFilter betweenFilter or {@code null} for none
   */
  public Filter setBetweenFilter(BetweenFilter betweenFilter) {
    this.betweenFilter = betweenFilter;
    return this;
  }

  /**
   * The dimension name or metric name. In most methods, dimensions & metrics can be used for the
   * first time in this field. However in a RunPivotReportRequest, this field must be additionally
   * specified by name in the RunPivotReportRequest's dimensions or metrics.
   * @return value or {@code null} for none
   */
  public java.lang.String getFieldName() {
    return fieldName;
  }

  /**
   * The dimension name or metric name. In most methods, dimensions & metrics can be used for the
   * first time in this field. However in a RunPivotReportRequest, this field must be additionally
   * specified by name in the RunPivotReportRequest's dimensions or metrics.
   * @param fieldName fieldName or {@code null} for none
   */
  public Filter setFieldName(java.lang.String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

  /**
   * A filter for in list values.
   * @return value or {@code null} for none
   */
  public InListFilter getInListFilter() {
    return inListFilter;
  }

  /**
   * A filter for in list values.
   * @param inListFilter inListFilter or {@code null} for none
   */
  public Filter setInListFilter(InListFilter inListFilter) {
    this.inListFilter = inListFilter;
    return this;
  }

  /**
   * A filter for numeric or date values.
   * @return value or {@code null} for none
   */
  public NumericFilter getNumericFilter() {
    return numericFilter;
  }

  /**
   * A filter for numeric or date values.
   * @param numericFilter numericFilter or {@code null} for none
   */
  public Filter setNumericFilter(NumericFilter numericFilter) {
    this.numericFilter = numericFilter;
    return this;
  }

  /**
   * Strings related filter.
   * @return value or {@code null} for none
   */
  public StringFilter getStringFilter() {
    return stringFilter;
  }

  /**
   * Strings related filter.
   * @param stringFilter stringFilter or {@code null} for none
   */
  public Filter setStringFilter(StringFilter stringFilter) {
    this.stringFilter = stringFilter;
    return this;
  }

  @Override
  public Filter set(String fieldName, Object value) {
    return (Filter) super.set(fieldName, value);
  }

  @Override
  public Filter clone() {
    return (Filter) super.clone();
  }

}
