/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * To express dimension or metric filters. The fields in the same FilterExpression need to be either
 * all dimensions or all metrics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FilterExpression extends com.google.api.client.json.GenericJson {

  /**
   * The FilterExpressions in and_group have an AND relationship.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FilterExpressionList andGroup;

  /**
   * A primitive filter. In the same FilterExpression, all of the filter's field names need to be
   * either all dimensions or all metrics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Filter filter;

  /**
   * The FilterExpression is NOT of not_expression.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FilterExpression notExpression;

  /**
   * The FilterExpressions in or_group have an OR relationship.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FilterExpressionList orGroup;

  /**
   * The FilterExpressions in and_group have an AND relationship.
   * @return value or {@code null} for none
   */
  public FilterExpressionList getAndGroup() {
    return andGroup;
  }

  /**
   * The FilterExpressions in and_group have an AND relationship.
   * @param andGroup andGroup or {@code null} for none
   */
  public FilterExpression setAndGroup(FilterExpressionList andGroup) {
    this.andGroup = andGroup;
    return this;
  }

  /**
   * A primitive filter. In the same FilterExpression, all of the filter's field names need to be
   * either all dimensions or all metrics.
   * @return value or {@code null} for none
   */
  public Filter getFilter() {
    return filter;
  }

  /**
   * A primitive filter. In the same FilterExpression, all of the filter's field names need to be
   * either all dimensions or all metrics.
   * @param filter filter or {@code null} for none
   */
  public FilterExpression setFilter(Filter filter) {
    this.filter = filter;
    return this;
  }

  /**
   * The FilterExpression is NOT of not_expression.
   * @return value or {@code null} for none
   */
  public FilterExpression getNotExpression() {
    return notExpression;
  }

  /**
   * The FilterExpression is NOT of not_expression.
   * @param notExpression notExpression or {@code null} for none
   */
  public FilterExpression setNotExpression(FilterExpression notExpression) {
    this.notExpression = notExpression;
    return this;
  }

  /**
   * The FilterExpressions in or_group have an OR relationship.
   * @return value or {@code null} for none
   */
  public FilterExpressionList getOrGroup() {
    return orGroup;
  }

  /**
   * The FilterExpressions in or_group have an OR relationship.
   * @param orGroup orGroup or {@code null} for none
   */
  public FilterExpression setOrGroup(FilterExpressionList orGroup) {
    this.orGroup = orGroup;
    return this;
  }

  @Override
  public FilterExpression set(String fieldName, Object value) {
    return (FilterExpression) super.set(fieldName, value);
  }

  @Override
  public FilterExpression clone() {
    return (FilterExpression) super.clone();
  }

}
