/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * The dimensions and metrics currently accepted in reporting methods.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Metadata extends com.google.api.client.json.GenericJson {

  /**
   * The dimension descriptions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DimensionMetadata> dimensions;

  static {
    // hack to force ProGuard to consider DimensionMetadata used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DimensionMetadata.class);
  }

  /**
   * The metric descriptions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MetricMetadata> metrics;

  /**
   * Resource name of this metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The dimension descriptions.
   * @return value or {@code null} for none
   */
  public java.util.List<DimensionMetadata> getDimensions() {
    return dimensions;
  }

  /**
   * The dimension descriptions.
   * @param dimensions dimensions or {@code null} for none
   */
  public Metadata setDimensions(java.util.List<DimensionMetadata> dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * The metric descriptions.
   * @return value or {@code null} for none
   */
  public java.util.List<MetricMetadata> getMetrics() {
    return metrics;
  }

  /**
   * The metric descriptions.
   * @param metrics metrics or {@code null} for none
   */
  public Metadata setMetrics(java.util.List<MetricMetadata> metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * Resource name of this metadata.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name of this metadata.
   * @param name name or {@code null} for none
   */
  public Metadata setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public Metadata set(String fieldName, Object value) {
    return (Metadata) super.set(fieldName, value);
  }

  @Override
  public Metadata clone() {
    return (Metadata) super.clone();
  }

}
