/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * The quantitative measurements of a report. For example, the metric `eventCount` is the total
 * number of events. Requests are allowed up to 10 metrics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Metric extends com.google.api.client.json.GenericJson {

  /**
   * A mathematical expression for derived metrics. For example, the metric Event count per user is
   * `eventCount/totalUsers`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expression;

  /**
   * Indicates if a metric is invisible in the report response. If a metric is invisible, the metric
   * will not produce a column in the response, but can be used in `metricFilter`, `orderBys`, or a
   * metric `expression`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean invisible;

  /**
   * The name of the metric. See the [API
   * Metrics](https://developers.google.com/analytics/devguides/reporting/data/v1/api-
   * schema#metrics) for the list of metric names. If `expression` is specified, `name` can be any
   * string that you would like within the allowed character set. For example if `expression` is
   * `screenPageViews/sessions`, you could call that metric's name = `viewsPerSession`. Metric names
   * that you choose must match the regular expression `^[a-zA-Z0-9_]$`. Metrics are referenced by
   * `name` in `metricFilter`, `orderBys`, and metric `expression`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A mathematical expression for derived metrics. For example, the metric Event count per user is
   * `eventCount/totalUsers`.
   * @return value or {@code null} for none
   */
  public java.lang.String getExpression() {
    return expression;
  }

  /**
   * A mathematical expression for derived metrics. For example, the metric Event count per user is
   * `eventCount/totalUsers`.
   * @param expression expression or {@code null} for none
   */
  public Metric setExpression(java.lang.String expression) {
    this.expression = expression;
    return this;
  }

  /**
   * Indicates if a metric is invisible in the report response. If a metric is invisible, the metric
   * will not produce a column in the response, but can be used in `metricFilter`, `orderBys`, or a
   * metric `expression`.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getInvisible() {
    return invisible;
  }

  /**
   * Indicates if a metric is invisible in the report response. If a metric is invisible, the metric
   * will not produce a column in the response, but can be used in `metricFilter`, `orderBys`, or a
   * metric `expression`.
   * @param invisible invisible or {@code null} for none
   */
  public Metric setInvisible(java.lang.Boolean invisible) {
    this.invisible = invisible;
    return this;
  }

  /**
   * The name of the metric. See the [API
   * Metrics](https://developers.google.com/analytics/devguides/reporting/data/v1/api-
   * schema#metrics) for the list of metric names. If `expression` is specified, `name` can be any
   * string that you would like within the allowed character set. For example if `expression` is
   * `screenPageViews/sessions`, you could call that metric's name = `viewsPerSession`. Metric names
   * that you choose must match the regular expression `^[a-zA-Z0-9_]$`. Metrics are referenced by
   * `name` in `metricFilter`, `orderBys`, and metric `expression`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the metric. See the [API
   * Metrics](https://developers.google.com/analytics/devguides/reporting/data/v1/api-
   * schema#metrics) for the list of metric names. If `expression` is specified, `name` can be any
   * string that you would like within the allowed character set. For example if `expression` is
   * `screenPageViews/sessions`, you could call that metric's name = `viewsPerSession`. Metric names
   * that you choose must match the regular expression `^[a-zA-Z0-9_]$`. Metrics are referenced by
   * `name` in `metricFilter`, `orderBys`, and metric `expression`.
   * @param name name or {@code null} for none
   */
  public Metric setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public Metric set(String fieldName, Object value) {
    return (Metric) super.set(fieldName, value);
  }

  @Override
  public Metric clone() {
    return (Metric) super.clone();
  }

}
