/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * Describes a metric column in the report. Visible metrics requested in a report produce column
 * entries within rows and MetricHeaders. However, metrics used exclusively within filters or
 * expressions do not produce columns in a report; correspondingly, those metrics do not produce
 * headers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MetricHeader extends com.google.api.client.json.GenericJson {

  /**
   * The metric's name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The metric's data type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The metric's name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The metric's name.
   * @param name name or {@code null} for none
   */
  public MetricHeader setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The metric's data type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The metric's data type.
   * @param type type or {@code null} for none
   */
  public MetricHeader setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public MetricHeader set(String fieldName, Object value) {
    return (MetricHeader) super.set(fieldName, value);
  }

  @Override
  public MetricHeader clone() {
    return (MetricHeader) super.clone();
  }

}
