/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * A contiguous set of minutes: startMinutesAgo, startMinutesAgo + 1, ..., endMinutesAgo. Requests
 * are allowed up to 2 minute ranges.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MinuteRange extends com.google.api.client.json.GenericJson {

  /**
   * The inclusive end minute for the query as a number of minutes before now. Cannot be before
   * `startMinutesAgo`. For example, `"endMinutesAgo": 15` specifies the report should include event
   * data from prior to 15 minutes ago. If unspecified, `endMinutesAgo` is defaulted to 0. Standard
   * Analytics properties can request any minute in the last 30 minutes of event data
   * (`endMinutesAgo <= 29`), and 360 Analytics properties can request any minute in the last 60
   * minutes of event data (`endMinutesAgo <= 59`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer endMinutesAgo;

  /**
   * Assigns a name to this minute range. The dimension `dateRange` is valued to this name in a
   * report response. If set, cannot begin with `date_range_` or `RESERVED_`. If not set, minute
   * ranges are named by their zero based index in the request: `date_range_0`, `date_range_1`, etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The inclusive start minute for the query as a number of minutes before now. For example,
   * `"startMinutesAgo": 29` specifies the report should include event data from 29 minutes ago and
   * after. Cannot be after `endMinutesAgo`. If unspecified, `startMinutesAgo` is defaulted to 29.
   * Standard Analytics properties can request up to the last 30 minutes of event data
   * (`startMinutesAgo <= 29`), and 360 Analytics properties can request up to the last 60 minutes
   * of event data (`startMinutesAgo <= 59`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startMinutesAgo;

  /**
   * The inclusive end minute for the query as a number of minutes before now. Cannot be before
   * `startMinutesAgo`. For example, `"endMinutesAgo": 15` specifies the report should include event
   * data from prior to 15 minutes ago. If unspecified, `endMinutesAgo` is defaulted to 0. Standard
   * Analytics properties can request any minute in the last 30 minutes of event data
   * (`endMinutesAgo <= 29`), and 360 Analytics properties can request any minute in the last 60
   * minutes of event data (`endMinutesAgo <= 59`).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getEndMinutesAgo() {
    return endMinutesAgo;
  }

  /**
   * The inclusive end minute for the query as a number of minutes before now. Cannot be before
   * `startMinutesAgo`. For example, `"endMinutesAgo": 15` specifies the report should include event
   * data from prior to 15 minutes ago. If unspecified, `endMinutesAgo` is defaulted to 0. Standard
   * Analytics properties can request any minute in the last 30 minutes of event data
   * (`endMinutesAgo <= 29`), and 360 Analytics properties can request any minute in the last 60
   * minutes of event data (`endMinutesAgo <= 59`).
   * @param endMinutesAgo endMinutesAgo or {@code null} for none
   */
  public MinuteRange setEndMinutesAgo(java.lang.Integer endMinutesAgo) {
    this.endMinutesAgo = endMinutesAgo;
    return this;
  }

  /**
   * Assigns a name to this minute range. The dimension `dateRange` is valued to this name in a
   * report response. If set, cannot begin with `date_range_` or `RESERVED_`. If not set, minute
   * ranges are named by their zero based index in the request: `date_range_0`, `date_range_1`, etc.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Assigns a name to this minute range. The dimension `dateRange` is valued to this name in a
   * report response. If set, cannot begin with `date_range_` or `RESERVED_`. If not set, minute
   * ranges are named by their zero based index in the request: `date_range_0`, `date_range_1`, etc.
   * @param name name or {@code null} for none
   */
  public MinuteRange setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The inclusive start minute for the query as a number of minutes before now. For example,
   * `"startMinutesAgo": 29` specifies the report should include event data from 29 minutes ago and
   * after. Cannot be after `endMinutesAgo`. If unspecified, `startMinutesAgo` is defaulted to 29.
   * Standard Analytics properties can request up to the last 30 minutes of event data
   * (`startMinutesAgo <= 29`), and 360 Analytics properties can request up to the last 60 minutes
   * of event data (`startMinutesAgo <= 59`).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartMinutesAgo() {
    return startMinutesAgo;
  }

  /**
   * The inclusive start minute for the query as a number of minutes before now. For example,
   * `"startMinutesAgo": 29` specifies the report should include event data from 29 minutes ago and
   * after. Cannot be after `endMinutesAgo`. If unspecified, `startMinutesAgo` is defaulted to 29.
   * Standard Analytics properties can request up to the last 30 minutes of event data
   * (`startMinutesAgo <= 29`), and 360 Analytics properties can request up to the last 60 minutes
   * of event data (`startMinutesAgo <= 59`).
   * @param startMinutesAgo startMinutesAgo or {@code null} for none
   */
  public MinuteRange setStartMinutesAgo(java.lang.Integer startMinutesAgo) {
    this.startMinutesAgo = startMinutesAgo;
    return this;
  }

  @Override
  public MinuteRange set(String fieldName, Object value) {
    return (MinuteRange) super.set(fieldName, value);
  }

  @Override
  public MinuteRange clone() {
    return (MinuteRange) super.clone();
  }

}
