/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * Filters for numeric or date values.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NumericFilter extends com.google.api.client.json.GenericJson {

  /**
   * The operation type for this filter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operation;

  /**
   * A numeric value or a date value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NumericValue value;

  /**
   * The operation type for this filter.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperation() {
    return operation;
  }

  /**
   * The operation type for this filter.
   * @param operation operation or {@code null} for none
   */
  public NumericFilter setOperation(java.lang.String operation) {
    this.operation = operation;
    return this;
  }

  /**
   * A numeric value or a date value.
   * @return value or {@code null} for none
   */
  public NumericValue getValue() {
    return value;
  }

  /**
   * A numeric value or a date value.
   * @param value value or {@code null} for none
   */
  public NumericFilter setValue(NumericValue value) {
    this.value = value;
    return this;
  }

  @Override
  public NumericFilter set(String fieldName, Object value) {
    return (NumericFilter) super.set(fieldName, value);
  }

  @Override
  public NumericFilter clone() {
    return (NumericFilter) super.clone();
  }

}
