/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * Sorts by a pivot column group.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PivotOrderBy extends com.google.api.client.json.GenericJson {

  /**
   * In the response to order by, order rows by this column. Must be a metric name from the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metricName;

  /**
   * Used to select a dimension name and value pivot. If multiple pivot selections are given, the
   * sort occurs on rows where all pivot selection dimension name and value pairs match the row's
   * dimension name and value pair.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PivotSelection> pivotSelections;

  /**
   * In the response to order by, order rows by this column. Must be a metric name from the request.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetricName() {
    return metricName;
  }

  /**
   * In the response to order by, order rows by this column. Must be a metric name from the request.
   * @param metricName metricName or {@code null} for none
   */
  public PivotOrderBy setMetricName(java.lang.String metricName) {
    this.metricName = metricName;
    return this;
  }

  /**
   * Used to select a dimension name and value pivot. If multiple pivot selections are given, the
   * sort occurs on rows where all pivot selection dimension name and value pairs match the row's
   * dimension name and value pair.
   * @return value or {@code null} for none
   */
  public java.util.List<PivotSelection> getPivotSelections() {
    return pivotSelections;
  }

  /**
   * Used to select a dimension name and value pivot. If multiple pivot selections are given, the
   * sort occurs on rows where all pivot selection dimension name and value pairs match the row's
   * dimension name and value pair.
   * @param pivotSelections pivotSelections or {@code null} for none
   */
  public PivotOrderBy setPivotSelections(java.util.List<PivotSelection> pivotSelections) {
    this.pivotSelections = pivotSelections;
    return this;
  }

  @Override
  public PivotOrderBy set(String fieldName, Object value) {
    return (PivotOrderBy) super.set(fieldName, value);
  }

  @Override
  public PivotOrderBy clone() {
    return (PivotOrderBy) super.clone();
  }

}
