/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * A pair of dimension names and values. Rows with this dimension pivot pair are ordered by the
 * metric's value. For example if pivots = {{"browser", "Chrome"}} and metric_name = "Sessions",
 * then the rows will be sorted based on Sessions in Chrome.
 * ---------|----------|----------------|----------|---------------- | Chrome | Chrome | Safari |
 * Safari ---------|----------|----------------|----------|---------------- Country | Sessions |
 * Pages/Sessions | Sessions | Pages/Sessions
 * ---------|----------|----------------|----------|---------------- US | 2 | 2 | 3 | 1
 * ---------|----------|----------------|----------|---------------- Canada | 3 | 1 | 4 | 1
 * ---------|----------|----------------|----------|----------------
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PivotSelection extends com.google.api.client.json.GenericJson {

  /**
   * Must be a dimension name from the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dimensionName;

  /**
   * Order by only when the named dimension is this value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dimensionValue;

  /**
   * Must be a dimension name from the request.
   * @return value or {@code null} for none
   */
  public java.lang.String getDimensionName() {
    return dimensionName;
  }

  /**
   * Must be a dimension name from the request.
   * @param dimensionName dimensionName or {@code null} for none
   */
  public PivotSelection setDimensionName(java.lang.String dimensionName) {
    this.dimensionName = dimensionName;
    return this;
  }

  /**
   * Order by only when the named dimension is this value.
   * @return value or {@code null} for none
   */
  public java.lang.String getDimensionValue() {
    return dimensionValue;
  }

  /**
   * Order by only when the named dimension is this value.
   * @param dimensionValue dimensionValue or {@code null} for none
   */
  public PivotSelection setDimensionValue(java.lang.String dimensionValue) {
    this.dimensionValue = dimensionValue;
    return this;
  }

  @Override
  public PivotSelection set(String fieldName, Object value) {
    return (PivotSelection) super.set(fieldName, value);
  }

  @Override
  public PivotSelection clone() {
    return (PivotSelection) super.clone();
  }

}
