/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * Response's metadata carrying additional information about the report content.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResponseMetaData extends com.google.api.client.json.GenericJson {

  /**
   * The currency code used in this report. Intended to be used in formatting currency metrics like
   * `purchaseRevenue` for visualization. If currency_code was specified in the request, this
   * response parameter will echo the request parameter; otherwise, this response parameter is the
   * property's current currency_code. Currency codes are string encodings of currency types from
   * the ISO 4217 standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD", "EUR",
   * "JPY". To learn more, see https://support.google.com/analytics/answer/9796179.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currencyCode;

  /**
   * If true, indicates some buckets of dimension combinations are rolled into "(other)" row. This
   * can happen for high cardinality reports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dataLossFromOtherRow;

  /**
   * If empty reason is specified, the report is empty for this reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String emptyReason;

  /**
   * Describes the schema restrictions actively enforced in creating this report. To learn more, see
   * [Access and data-restriction management](https://support.google.com/analytics/answer/10851388).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SchemaRestrictionResponse schemaRestrictionResponse;

  /**
   * If `subjectToThresholding` is true, this report is subject to thresholding and only returns
   * data that meets the minimum aggregation thresholds. It is possible for a request to be subject
   * to thresholding thresholding and no data is absent from the report, and this happens when all
   * data is above the thresholds. To learn more, see [Data
   * thresholds](https://support.google.com/analytics/answer/9383630) and [About Demographics and
   * Interests](https://support.google.com/analytics/answer/2799357).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean subjectToThresholding;

  /**
   * The property's current timezone. Intended to be used to interpret time-based dimensions like
   * `hour` and `minute`. Formatted as strings from the IANA Time Zone database
   * (https://www.iana.org/time-zones); for example "America/New_York" or "Asia/Tokyo".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * The currency code used in this report. Intended to be used in formatting currency metrics like
   * `purchaseRevenue` for visualization. If currency_code was specified in the request, this
   * response parameter will echo the request parameter; otherwise, this response parameter is the
   * property's current currency_code. Currency codes are string encodings of currency types from
   * the ISO 4217 standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD", "EUR",
   * "JPY". To learn more, see https://support.google.com/analytics/answer/9796179.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrencyCode() {
    return currencyCode;
  }

  /**
   * The currency code used in this report. Intended to be used in formatting currency metrics like
   * `purchaseRevenue` for visualization. If currency_code was specified in the request, this
   * response parameter will echo the request parameter; otherwise, this response parameter is the
   * property's current currency_code. Currency codes are string encodings of currency types from
   * the ISO 4217 standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD", "EUR",
   * "JPY". To learn more, see https://support.google.com/analytics/answer/9796179.
   * @param currencyCode currencyCode or {@code null} for none
   */
  public ResponseMetaData setCurrencyCode(java.lang.String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * If true, indicates some buckets of dimension combinations are rolled into "(other)" row. This
   * can happen for high cardinality reports.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDataLossFromOtherRow() {
    return dataLossFromOtherRow;
  }

  /**
   * If true, indicates some buckets of dimension combinations are rolled into "(other)" row. This
   * can happen for high cardinality reports.
   * @param dataLossFromOtherRow dataLossFromOtherRow or {@code null} for none
   */
  public ResponseMetaData setDataLossFromOtherRow(java.lang.Boolean dataLossFromOtherRow) {
    this.dataLossFromOtherRow = dataLossFromOtherRow;
    return this;
  }

  /**
   * If empty reason is specified, the report is empty for this reason.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmptyReason() {
    return emptyReason;
  }

  /**
   * If empty reason is specified, the report is empty for this reason.
   * @param emptyReason emptyReason or {@code null} for none
   */
  public ResponseMetaData setEmptyReason(java.lang.String emptyReason) {
    this.emptyReason = emptyReason;
    return this;
  }

  /**
   * Describes the schema restrictions actively enforced in creating this report. To learn more, see
   * [Access and data-restriction management](https://support.google.com/analytics/answer/10851388).
   * @return value or {@code null} for none
   */
  public SchemaRestrictionResponse getSchemaRestrictionResponse() {
    return schemaRestrictionResponse;
  }

  /**
   * Describes the schema restrictions actively enforced in creating this report. To learn more, see
   * [Access and data-restriction management](https://support.google.com/analytics/answer/10851388).
   * @param schemaRestrictionResponse schemaRestrictionResponse or {@code null} for none
   */
  public ResponseMetaData setSchemaRestrictionResponse(SchemaRestrictionResponse schemaRestrictionResponse) {
    this.schemaRestrictionResponse = schemaRestrictionResponse;
    return this;
  }

  /**
   * If `subjectToThresholding` is true, this report is subject to thresholding and only returns
   * data that meets the minimum aggregation thresholds. It is possible for a request to be subject
   * to thresholding thresholding and no data is absent from the report, and this happens when all
   * data is above the thresholds. To learn more, see [Data
   * thresholds](https://support.google.com/analytics/answer/9383630) and [About Demographics and
   * Interests](https://support.google.com/analytics/answer/2799357).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSubjectToThresholding() {
    return subjectToThresholding;
  }

  /**
   * If `subjectToThresholding` is true, this report is subject to thresholding and only returns
   * data that meets the minimum aggregation thresholds. It is possible for a request to be subject
   * to thresholding thresholding and no data is absent from the report, and this happens when all
   * data is above the thresholds. To learn more, see [Data
   * thresholds](https://support.google.com/analytics/answer/9383630) and [About Demographics and
   * Interests](https://support.google.com/analytics/answer/2799357).
   * @param subjectToThresholding subjectToThresholding or {@code null} for none
   */
  public ResponseMetaData setSubjectToThresholding(java.lang.Boolean subjectToThresholding) {
    this.subjectToThresholding = subjectToThresholding;
    return this;
  }

  /**
   * The property's current timezone. Intended to be used to interpret time-based dimensions like
   * `hour` and `minute`. Formatted as strings from the IANA Time Zone database
   * (https://www.iana.org/time-zones); for example "America/New_York" or "Asia/Tokyo".
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * The property's current timezone. Intended to be used to interpret time-based dimensions like
   * `hour` and `minute`. Formatted as strings from the IANA Time Zone database
   * (https://www.iana.org/time-zones); for example "America/New_York" or "Asia/Tokyo".
   * @param timeZone timeZone or {@code null} for none
   */
  public ResponseMetaData setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  @Override
  public ResponseMetaData set(String fieldName, Object value) {
    return (ResponseMetaData) super.set(fieldName, value);
  }

  @Override
  public ResponseMetaData clone() {
    return (ResponseMetaData) super.clone();
  }

}
