/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsdata.v1beta.model;

/**
 * The response pivot report table corresponding to a pivot request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Data API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RunPivotReportResponse extends com.google.api.client.json.GenericJson {

  /**
   * Aggregation of metric values. Can be totals, minimums, or maximums. The returned aggregations
   * are controlled by the metric_aggregations in the pivot. The type of aggregation returned in
   * each row is shown by the dimension_values which are set to "RESERVED_".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Row> aggregates;

  static {
    // hack to force ProGuard to consider Row used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Row.class);
  }

  /**
   * Describes dimension columns. The number of DimensionHeaders and ordering of DimensionHeaders
   * matches the dimensions present in rows.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DimensionHeader> dimensionHeaders;

  static {
    // hack to force ProGuard to consider DimensionHeader used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DimensionHeader.class);
  }

  /**
   * Identifies what kind of resource this message is. This `kind` is always the fixed string
   * "analyticsData#runPivotReport". Useful to distinguish between response types in JSON.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Metadata for the report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResponseMetaData metadata;

  /**
   * Describes metric columns. The number of MetricHeaders and ordering of MetricHeaders matches the
   * metrics present in rows.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MetricHeader> metricHeaders;

  static {
    // hack to force ProGuard to consider MetricHeader used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MetricHeader.class);
  }

  /**
   * Summarizes the columns and rows created by a pivot. Each pivot in the request produces one
   * header in the response. If we have a request like this: "pivots": [{ "fieldNames": ["country",
   * "city"] }, { "fieldNames": "eventName" }] We will have the following `pivotHeaders` in the
   * response: "pivotHeaders" : [{ "dimensionHeaders": [{ "dimensionValues": [ { "value": "United
   * Kingdom" }, { "value": "London" } ] }, { "dimensionValues": [ { "value": "Japan" }, { "value":
   * "Osaka" } ] }] }, { "dimensionHeaders": [{ "dimensionValues": [{ "value": "session_start" }] },
   * { "dimensionValues": [{ "value": "scroll" }] }] }]
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PivotHeader> pivotHeaders;

  static {
    // hack to force ProGuard to consider PivotHeader used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PivotHeader.class);
  }

  /**
   * This Analytics Property's quota state including this request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PropertyQuota propertyQuota;

  /**
   * Rows of dimension value combinations and metric values in the report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Row> rows;

  static {
    // hack to force ProGuard to consider Row used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Row.class);
  }

  /**
   * Aggregation of metric values. Can be totals, minimums, or maximums. The returned aggregations
   * are controlled by the metric_aggregations in the pivot. The type of aggregation returned in
   * each row is shown by the dimension_values which are set to "RESERVED_".
   * @return value or {@code null} for none
   */
  public java.util.List<Row> getAggregates() {
    return aggregates;
  }

  /**
   * Aggregation of metric values. Can be totals, minimums, or maximums. The returned aggregations
   * are controlled by the metric_aggregations in the pivot. The type of aggregation returned in
   * each row is shown by the dimension_values which are set to "RESERVED_".
   * @param aggregates aggregates or {@code null} for none
   */
  public RunPivotReportResponse setAggregates(java.util.List<Row> aggregates) {
    this.aggregates = aggregates;
    return this;
  }

  /**
   * Describes dimension columns. The number of DimensionHeaders and ordering of DimensionHeaders
   * matches the dimensions present in rows.
   * @return value or {@code null} for none
   */
  public java.util.List<DimensionHeader> getDimensionHeaders() {
    return dimensionHeaders;
  }

  /**
   * Describes dimension columns. The number of DimensionHeaders and ordering of DimensionHeaders
   * matches the dimensions present in rows.
   * @param dimensionHeaders dimensionHeaders or {@code null} for none
   */
  public RunPivotReportResponse setDimensionHeaders(java.util.List<DimensionHeader> dimensionHeaders) {
    this.dimensionHeaders = dimensionHeaders;
    return this;
  }

  /**
   * Identifies what kind of resource this message is. This `kind` is always the fixed string
   * "analyticsData#runPivotReport". Useful to distinguish between response types in JSON.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this message is. This `kind` is always the fixed string
   * "analyticsData#runPivotReport". Useful to distinguish between response types in JSON.
   * @param kind kind or {@code null} for none
   */
  public RunPivotReportResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Metadata for the report.
   * @return value or {@code null} for none
   */
  public ResponseMetaData getMetadata() {
    return metadata;
  }

  /**
   * Metadata for the report.
   * @param metadata metadata or {@code null} for none
   */
  public RunPivotReportResponse setMetadata(ResponseMetaData metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Describes metric columns. The number of MetricHeaders and ordering of MetricHeaders matches the
   * metrics present in rows.
   * @return value or {@code null} for none
   */
  public java.util.List<MetricHeader> getMetricHeaders() {
    return metricHeaders;
  }

  /**
   * Describes metric columns. The number of MetricHeaders and ordering of MetricHeaders matches the
   * metrics present in rows.
   * @param metricHeaders metricHeaders or {@code null} for none
   */
  public RunPivotReportResponse setMetricHeaders(java.util.List<MetricHeader> metricHeaders) {
    this.metricHeaders = metricHeaders;
    return this;
  }

  /**
   * Summarizes the columns and rows created by a pivot. Each pivot in the request produces one
   * header in the response. If we have a request like this: "pivots": [{ "fieldNames": ["country",
   * "city"] }, { "fieldNames": "eventName" }] We will have the following `pivotHeaders` in the
   * response: "pivotHeaders" : [{ "dimensionHeaders": [{ "dimensionValues": [ { "value": "United
   * Kingdom" }, { "value": "London" } ] }, { "dimensionValues": [ { "value": "Japan" }, { "value":
   * "Osaka" } ] }] }, { "dimensionHeaders": [{ "dimensionValues": [{ "value": "session_start" }] },
   * { "dimensionValues": [{ "value": "scroll" }] }] }]
   * @return value or {@code null} for none
   */
  public java.util.List<PivotHeader> getPivotHeaders() {
    return pivotHeaders;
  }

  /**
   * Summarizes the columns and rows created by a pivot. Each pivot in the request produces one
   * header in the response. If we have a request like this: "pivots": [{ "fieldNames": ["country",
   * "city"] }, { "fieldNames": "eventName" }] We will have the following `pivotHeaders` in the
   * response: "pivotHeaders" : [{ "dimensionHeaders": [{ "dimensionValues": [ { "value": "United
   * Kingdom" }, { "value": "London" } ] }, { "dimensionValues": [ { "value": "Japan" }, { "value":
   * "Osaka" } ] }] }, { "dimensionHeaders": [{ "dimensionValues": [{ "value": "session_start" }] },
   * { "dimensionValues": [{ "value": "scroll" }] }] }]
   * @param pivotHeaders pivotHeaders or {@code null} for none
   */
  public RunPivotReportResponse setPivotHeaders(java.util.List<PivotHeader> pivotHeaders) {
    this.pivotHeaders = pivotHeaders;
    return this;
  }

  /**
   * This Analytics Property's quota state including this request.
   * @return value or {@code null} for none
   */
  public PropertyQuota getPropertyQuota() {
    return propertyQuota;
  }

  /**
   * This Analytics Property's quota state including this request.
   * @param propertyQuota propertyQuota or {@code null} for none
   */
  public RunPivotReportResponse setPropertyQuota(PropertyQuota propertyQuota) {
    this.propertyQuota = propertyQuota;
    return this;
  }

  /**
   * Rows of dimension value combinations and metric values in the report.
   * @return value or {@code null} for none
   */
  public java.util.List<Row> getRows() {
    return rows;
  }

  /**
   * Rows of dimension value combinations and metric values in the report.
   * @param rows rows or {@code null} for none
   */
  public RunPivotReportResponse setRows(java.util.List<Row> rows) {
    this.rows = rows;
    return this;
  }

  @Override
  public RunPivotReportResponse set(String fieldName, Object value) {
    return (RunPivotReportResponse) super.set(fieldName, value);
  }

  @Override
  public RunPivotReportResponse clone() {
    return (RunPivotReportResponse) super.clone();
  }

}
