/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.analyticsdata.v1beta;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.analyticsdata.v1beta.AnalyticsDataRequest;
import com.google.api.services.analyticsdata.v1beta.AnalyticsDataRequestInitializer;
import com.google.api.services.analyticsdata.v1beta.model.AudienceExport;
import com.google.api.services.analyticsdata.v1beta.model.BatchRunPivotReportsRequest;
import com.google.api.services.analyticsdata.v1beta.model.BatchRunPivotReportsResponse;
import com.google.api.services.analyticsdata.v1beta.model.BatchRunReportsRequest;
import com.google.api.services.analyticsdata.v1beta.model.BatchRunReportsResponse;
import com.google.api.services.analyticsdata.v1beta.model.CheckCompatibilityRequest;
import com.google.api.services.analyticsdata.v1beta.model.CheckCompatibilityResponse;
import com.google.api.services.analyticsdata.v1beta.model.ListAudienceExportsResponse;
import com.google.api.services.analyticsdata.v1beta.model.Metadata;
import com.google.api.services.analyticsdata.v1beta.model.Operation;
import com.google.api.services.analyticsdata.v1beta.model.QueryAudienceExportRequest;
import com.google.api.services.analyticsdata.v1beta.model.QueryAudienceExportResponse;
import com.google.api.services.analyticsdata.v1beta.model.RunPivotReportRequest;
import com.google.api.services.analyticsdata.v1beta.model.RunPivotReportResponse;
import com.google.api.services.analyticsdata.v1beta.model.RunRealtimeReportRequest;
import com.google.api.services.analyticsdata.v1beta.model.RunRealtimeReportResponse;
import com.google.api.services.analyticsdata.v1beta.model.RunReportRequest;
import com.google.api.services.analyticsdata.v1beta.model.RunReportResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class AnalyticsData
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://analyticsdata.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://analyticsdata.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://analyticsdata.googleapis.com/";

    public AnalyticsData(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    AnalyticsData(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Properties properties() {
        return new Properties();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Google Analytics Data API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return AnalyticsData.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://analyticsdata.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), AnalyticsData.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(AnalyticsData.DEFAULT_BATCH_PATH);
        }

        public AnalyticsData build() {
            return new AnalyticsData(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setAnalyticsDataRequestInitializer(AnalyticsDataRequestInitializer analyticsdataRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)analyticsdataRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Properties {
        public BatchRunPivotReports batchRunPivotReports(String property, BatchRunPivotReportsRequest content) throws IOException {
            BatchRunPivotReports result = new BatchRunPivotReports(property, content);
            AnalyticsData.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public BatchRunReports batchRunReports(String property, BatchRunReportsRequest content) throws IOException {
            BatchRunReports result = new BatchRunReports(property, content);
            AnalyticsData.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public CheckCompatibility checkCompatibility(String property, CheckCompatibilityRequest content) throws IOException {
            CheckCompatibility result = new CheckCompatibility(property, content);
            AnalyticsData.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetMetadata getMetadata(String name) throws IOException {
            GetMetadata result = new GetMetadata(name);
            AnalyticsData.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RunPivotReport runPivotReport(String property, RunPivotReportRequest content) throws IOException {
            RunPivotReport result = new RunPivotReport(property, content);
            AnalyticsData.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RunRealtimeReport runRealtimeReport(String property, RunRealtimeReportRequest content) throws IOException {
            RunRealtimeReport result = new RunRealtimeReport(property, content);
            AnalyticsData.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RunReport runReport(String property, RunReportRequest content) throws IOException {
            RunReport result = new RunReport(property, content);
            AnalyticsData.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AudienceExports audienceExports() {
            return new AudienceExports();
        }

        public class AudienceExports {
            public Create create(String parent, AudienceExport content) throws IOException {
                Create result = new Create(parent, content);
                AnalyticsData.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                AnalyticsData.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                AnalyticsData.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Query query(String name, QueryAudienceExportRequest content) throws IOException {
                Query result = new Query(name, content);
                AnalyticsData.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Query
            extends AnalyticsDataRequest<QueryAudienceExportResponse> {
                private static final String REST_PATH = "v1beta/{+name}:query";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Query(String name, QueryAudienceExportRequest content) {
                    super(AnalyticsData.this, "POST", REST_PATH, (Object)content, QueryAudienceExportResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^properties/[^/]+/audienceExports/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!AnalyticsData.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^properties/[^/]+/audienceExports/[^/]+$");
                    }
                }

                public Query set$Xgafv(String $Xgafv) {
                    return (Query)super.set$Xgafv($Xgafv);
                }

                public Query setAccessToken(String accessToken) {
                    return (Query)super.setAccessToken(accessToken);
                }

                public Query setAlt(String alt) {
                    return (Query)super.setAlt(alt);
                }

                public Query setCallback(String callback) {
                    return (Query)super.setCallback(callback);
                }

                public Query setFields(String fields) {
                    return (Query)super.setFields(fields);
                }

                public Query setKey(String key) {
                    return (Query)super.setKey(key);
                }

                public Query setOauthToken(String oauthToken) {
                    return (Query)super.setOauthToken(oauthToken);
                }

                public Query setPrettyPrint(Boolean prettyPrint) {
                    return (Query)super.setPrettyPrint(prettyPrint);
                }

                public Query setQuotaUser(String quotaUser) {
                    return (Query)super.setQuotaUser(quotaUser);
                }

                public Query setUploadType(String uploadType) {
                    return (Query)super.setUploadType(uploadType);
                }

                public Query setUploadProtocol(String uploadProtocol) {
                    return (Query)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Query setName(String name) {
                    if (!AnalyticsData.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^properties/[^/]+/audienceExports/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Query set(String parameterName, Object value) {
                    return (Query)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsDataRequest<ListAudienceExportsResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/audienceExports";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(AnalyticsData.this, "GET", REST_PATH, null, ListAudienceExportsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^properties/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AnalyticsData.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^properties/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!AnalyticsData.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^properties/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsDataRequest<AudienceExport> {
                private static final String REST_PATH = "v1beta/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(AnalyticsData.this, "GET", REST_PATH, null, AudienceExport.class);
                    this.NAME_PATTERN = Pattern.compile("^properties/[^/]+/audienceExports/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!AnalyticsData.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^properties/[^/]+/audienceExports/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!AnalyticsData.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^properties/[^/]+/audienceExports/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends AnalyticsDataRequest<Operation> {
                private static final String REST_PATH = "v1beta/{+parent}/audienceExports";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, AudienceExport content) {
                    super(AnalyticsData.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^properties/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AnalyticsData.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^properties/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!AnalyticsData.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^properties/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class RunReport
        extends AnalyticsDataRequest<RunReportResponse> {
            private static final String REST_PATH = "v1beta/{+property}:runReport";
            private final Pattern PROPERTY_PATTERN;
            @Key
            private String property;

            protected RunReport(String property, RunReportRequest content) {
                super(AnalyticsData.this, "POST", REST_PATH, (Object)content, RunReportResponse.class);
                this.PROPERTY_PATTERN = Pattern.compile("^properties/[^/]+$");
                this.property = (String)Preconditions.checkNotNull((Object)property, (Object)"Required parameter property must be specified.");
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
            }

            public RunReport set$Xgafv(String $Xgafv) {
                return (RunReport)super.set$Xgafv($Xgafv);
            }

            public RunReport setAccessToken(String accessToken) {
                return (RunReport)super.setAccessToken(accessToken);
            }

            public RunReport setAlt(String alt) {
                return (RunReport)super.setAlt(alt);
            }

            public RunReport setCallback(String callback) {
                return (RunReport)super.setCallback(callback);
            }

            public RunReport setFields(String fields) {
                return (RunReport)super.setFields(fields);
            }

            public RunReport setKey(String key) {
                return (RunReport)super.setKey(key);
            }

            public RunReport setOauthToken(String oauthToken) {
                return (RunReport)super.setOauthToken(oauthToken);
            }

            public RunReport setPrettyPrint(Boolean prettyPrint) {
                return (RunReport)super.setPrettyPrint(prettyPrint);
            }

            public RunReport setQuotaUser(String quotaUser) {
                return (RunReport)super.setQuotaUser(quotaUser);
            }

            public RunReport setUploadType(String uploadType) {
                return (RunReport)super.setUploadType(uploadType);
            }

            public RunReport setUploadProtocol(String uploadProtocol) {
                return (RunReport)super.setUploadProtocol(uploadProtocol);
            }

            public String getProperty() {
                return this.property;
            }

            public RunReport setProperty(String property) {
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
                this.property = property;
                return this;
            }

            @Override
            public RunReport set(String parameterName, Object value) {
                return (RunReport)super.set(parameterName, value);
            }
        }

        public class RunRealtimeReport
        extends AnalyticsDataRequest<RunRealtimeReportResponse> {
            private static final String REST_PATH = "v1beta/{+property}:runRealtimeReport";
            private final Pattern PROPERTY_PATTERN;
            @Key
            private String property;

            protected RunRealtimeReport(String property, RunRealtimeReportRequest content) {
                super(AnalyticsData.this, "POST", REST_PATH, (Object)content, RunRealtimeReportResponse.class);
                this.PROPERTY_PATTERN = Pattern.compile("^properties/[^/]+$");
                this.property = (String)Preconditions.checkNotNull((Object)property, (Object)"Required parameter property must be specified.");
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
            }

            public RunRealtimeReport set$Xgafv(String $Xgafv) {
                return (RunRealtimeReport)super.set$Xgafv($Xgafv);
            }

            public RunRealtimeReport setAccessToken(String accessToken) {
                return (RunRealtimeReport)super.setAccessToken(accessToken);
            }

            public RunRealtimeReport setAlt(String alt) {
                return (RunRealtimeReport)super.setAlt(alt);
            }

            public RunRealtimeReport setCallback(String callback) {
                return (RunRealtimeReport)super.setCallback(callback);
            }

            public RunRealtimeReport setFields(String fields) {
                return (RunRealtimeReport)super.setFields(fields);
            }

            public RunRealtimeReport setKey(String key) {
                return (RunRealtimeReport)super.setKey(key);
            }

            public RunRealtimeReport setOauthToken(String oauthToken) {
                return (RunRealtimeReport)super.setOauthToken(oauthToken);
            }

            public RunRealtimeReport setPrettyPrint(Boolean prettyPrint) {
                return (RunRealtimeReport)super.setPrettyPrint(prettyPrint);
            }

            public RunRealtimeReport setQuotaUser(String quotaUser) {
                return (RunRealtimeReport)super.setQuotaUser(quotaUser);
            }

            public RunRealtimeReport setUploadType(String uploadType) {
                return (RunRealtimeReport)super.setUploadType(uploadType);
            }

            public RunRealtimeReport setUploadProtocol(String uploadProtocol) {
                return (RunRealtimeReport)super.setUploadProtocol(uploadProtocol);
            }

            public String getProperty() {
                return this.property;
            }

            public RunRealtimeReport setProperty(String property) {
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
                this.property = property;
                return this;
            }

            @Override
            public RunRealtimeReport set(String parameterName, Object value) {
                return (RunRealtimeReport)super.set(parameterName, value);
            }
        }

        public class RunPivotReport
        extends AnalyticsDataRequest<RunPivotReportResponse> {
            private static final String REST_PATH = "v1beta/{+property}:runPivotReport";
            private final Pattern PROPERTY_PATTERN;
            @Key
            private String property;

            protected RunPivotReport(String property, RunPivotReportRequest content) {
                super(AnalyticsData.this, "POST", REST_PATH, (Object)content, RunPivotReportResponse.class);
                this.PROPERTY_PATTERN = Pattern.compile("^properties/[^/]+$");
                this.property = (String)Preconditions.checkNotNull((Object)property, (Object)"Required parameter property must be specified.");
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
            }

            public RunPivotReport set$Xgafv(String $Xgafv) {
                return (RunPivotReport)super.set$Xgafv($Xgafv);
            }

            public RunPivotReport setAccessToken(String accessToken) {
                return (RunPivotReport)super.setAccessToken(accessToken);
            }

            public RunPivotReport setAlt(String alt) {
                return (RunPivotReport)super.setAlt(alt);
            }

            public RunPivotReport setCallback(String callback) {
                return (RunPivotReport)super.setCallback(callback);
            }

            public RunPivotReport setFields(String fields) {
                return (RunPivotReport)super.setFields(fields);
            }

            public RunPivotReport setKey(String key) {
                return (RunPivotReport)super.setKey(key);
            }

            public RunPivotReport setOauthToken(String oauthToken) {
                return (RunPivotReport)super.setOauthToken(oauthToken);
            }

            public RunPivotReport setPrettyPrint(Boolean prettyPrint) {
                return (RunPivotReport)super.setPrettyPrint(prettyPrint);
            }

            public RunPivotReport setQuotaUser(String quotaUser) {
                return (RunPivotReport)super.setQuotaUser(quotaUser);
            }

            public RunPivotReport setUploadType(String uploadType) {
                return (RunPivotReport)super.setUploadType(uploadType);
            }

            public RunPivotReport setUploadProtocol(String uploadProtocol) {
                return (RunPivotReport)super.setUploadProtocol(uploadProtocol);
            }

            public String getProperty() {
                return this.property;
            }

            public RunPivotReport setProperty(String property) {
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
                this.property = property;
                return this;
            }

            @Override
            public RunPivotReport set(String parameterName, Object value) {
                return (RunPivotReport)super.set(parameterName, value);
            }
        }

        public class GetMetadata
        extends AnalyticsDataRequest<Metadata> {
            private static final String REST_PATH = "v1beta/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetMetadata(String name) {
                super(AnalyticsData.this, "GET", REST_PATH, null, Metadata.class);
                this.NAME_PATTERN = Pattern.compile("^properties/[^/]+/metadata$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^properties/[^/]+/metadata$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetMetadata set$Xgafv(String $Xgafv) {
                return (GetMetadata)super.set$Xgafv($Xgafv);
            }

            public GetMetadata setAccessToken(String accessToken) {
                return (GetMetadata)super.setAccessToken(accessToken);
            }

            public GetMetadata setAlt(String alt) {
                return (GetMetadata)super.setAlt(alt);
            }

            public GetMetadata setCallback(String callback) {
                return (GetMetadata)super.setCallback(callback);
            }

            public GetMetadata setFields(String fields) {
                return (GetMetadata)super.setFields(fields);
            }

            public GetMetadata setKey(String key) {
                return (GetMetadata)super.setKey(key);
            }

            public GetMetadata setOauthToken(String oauthToken) {
                return (GetMetadata)super.setOauthToken(oauthToken);
            }

            public GetMetadata setPrettyPrint(Boolean prettyPrint) {
                return (GetMetadata)super.setPrettyPrint(prettyPrint);
            }

            public GetMetadata setQuotaUser(String quotaUser) {
                return (GetMetadata)super.setQuotaUser(quotaUser);
            }

            public GetMetadata setUploadType(String uploadType) {
                return (GetMetadata)super.setUploadType(uploadType);
            }

            public GetMetadata setUploadProtocol(String uploadProtocol) {
                return (GetMetadata)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetMetadata setName(String name) {
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^properties/[^/]+/metadata$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetMetadata set(String parameterName, Object value) {
                return (GetMetadata)super.set(parameterName, value);
            }
        }

        public class CheckCompatibility
        extends AnalyticsDataRequest<CheckCompatibilityResponse> {
            private static final String REST_PATH = "v1beta/{+property}:checkCompatibility";
            private final Pattern PROPERTY_PATTERN;
            @Key
            private String property;

            protected CheckCompatibility(String property, CheckCompatibilityRequest content) {
                super(AnalyticsData.this, "POST", REST_PATH, (Object)content, CheckCompatibilityResponse.class);
                this.PROPERTY_PATTERN = Pattern.compile("^properties/[^/]+$");
                this.property = (String)Preconditions.checkNotNull((Object)property, (Object)"Required parameter property must be specified.");
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
            }

            public CheckCompatibility set$Xgafv(String $Xgafv) {
                return (CheckCompatibility)super.set$Xgafv($Xgafv);
            }

            public CheckCompatibility setAccessToken(String accessToken) {
                return (CheckCompatibility)super.setAccessToken(accessToken);
            }

            public CheckCompatibility setAlt(String alt) {
                return (CheckCompatibility)super.setAlt(alt);
            }

            public CheckCompatibility setCallback(String callback) {
                return (CheckCompatibility)super.setCallback(callback);
            }

            public CheckCompatibility setFields(String fields) {
                return (CheckCompatibility)super.setFields(fields);
            }

            public CheckCompatibility setKey(String key) {
                return (CheckCompatibility)super.setKey(key);
            }

            public CheckCompatibility setOauthToken(String oauthToken) {
                return (CheckCompatibility)super.setOauthToken(oauthToken);
            }

            public CheckCompatibility setPrettyPrint(Boolean prettyPrint) {
                return (CheckCompatibility)super.setPrettyPrint(prettyPrint);
            }

            public CheckCompatibility setQuotaUser(String quotaUser) {
                return (CheckCompatibility)super.setQuotaUser(quotaUser);
            }

            public CheckCompatibility setUploadType(String uploadType) {
                return (CheckCompatibility)super.setUploadType(uploadType);
            }

            public CheckCompatibility setUploadProtocol(String uploadProtocol) {
                return (CheckCompatibility)super.setUploadProtocol(uploadProtocol);
            }

            public String getProperty() {
                return this.property;
            }

            public CheckCompatibility setProperty(String property) {
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
                this.property = property;
                return this;
            }

            @Override
            public CheckCompatibility set(String parameterName, Object value) {
                return (CheckCompatibility)super.set(parameterName, value);
            }
        }

        public class BatchRunReports
        extends AnalyticsDataRequest<BatchRunReportsResponse> {
            private static final String REST_PATH = "v1beta/{+property}:batchRunReports";
            private final Pattern PROPERTY_PATTERN;
            @Key
            private String property;

            protected BatchRunReports(String property, BatchRunReportsRequest content) {
                super(AnalyticsData.this, "POST", REST_PATH, (Object)content, BatchRunReportsResponse.class);
                this.PROPERTY_PATTERN = Pattern.compile("^properties/[^/]+$");
                this.property = (String)Preconditions.checkNotNull((Object)property, (Object)"Required parameter property must be specified.");
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
            }

            public BatchRunReports set$Xgafv(String $Xgafv) {
                return (BatchRunReports)super.set$Xgafv($Xgafv);
            }

            public BatchRunReports setAccessToken(String accessToken) {
                return (BatchRunReports)super.setAccessToken(accessToken);
            }

            public BatchRunReports setAlt(String alt) {
                return (BatchRunReports)super.setAlt(alt);
            }

            public BatchRunReports setCallback(String callback) {
                return (BatchRunReports)super.setCallback(callback);
            }

            public BatchRunReports setFields(String fields) {
                return (BatchRunReports)super.setFields(fields);
            }

            public BatchRunReports setKey(String key) {
                return (BatchRunReports)super.setKey(key);
            }

            public BatchRunReports setOauthToken(String oauthToken) {
                return (BatchRunReports)super.setOauthToken(oauthToken);
            }

            public BatchRunReports setPrettyPrint(Boolean prettyPrint) {
                return (BatchRunReports)super.setPrettyPrint(prettyPrint);
            }

            public BatchRunReports setQuotaUser(String quotaUser) {
                return (BatchRunReports)super.setQuotaUser(quotaUser);
            }

            public BatchRunReports setUploadType(String uploadType) {
                return (BatchRunReports)super.setUploadType(uploadType);
            }

            public BatchRunReports setUploadProtocol(String uploadProtocol) {
                return (BatchRunReports)super.setUploadProtocol(uploadProtocol);
            }

            public String getProperty() {
                return this.property;
            }

            public BatchRunReports setProperty(String property) {
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
                this.property = property;
                return this;
            }

            @Override
            public BatchRunReports set(String parameterName, Object value) {
                return (BatchRunReports)super.set(parameterName, value);
            }
        }

        public class BatchRunPivotReports
        extends AnalyticsDataRequest<BatchRunPivotReportsResponse> {
            private static final String REST_PATH = "v1beta/{+property}:batchRunPivotReports";
            private final Pattern PROPERTY_PATTERN;
            @Key
            private String property;

            protected BatchRunPivotReports(String property, BatchRunPivotReportsRequest content) {
                super(AnalyticsData.this, "POST", REST_PATH, (Object)content, BatchRunPivotReportsResponse.class);
                this.PROPERTY_PATTERN = Pattern.compile("^properties/[^/]+$");
                this.property = (String)Preconditions.checkNotNull((Object)property, (Object)"Required parameter property must be specified.");
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
            }

            public BatchRunPivotReports set$Xgafv(String $Xgafv) {
                return (BatchRunPivotReports)super.set$Xgafv($Xgafv);
            }

            public BatchRunPivotReports setAccessToken(String accessToken) {
                return (BatchRunPivotReports)super.setAccessToken(accessToken);
            }

            public BatchRunPivotReports setAlt(String alt) {
                return (BatchRunPivotReports)super.setAlt(alt);
            }

            public BatchRunPivotReports setCallback(String callback) {
                return (BatchRunPivotReports)super.setCallback(callback);
            }

            public BatchRunPivotReports setFields(String fields) {
                return (BatchRunPivotReports)super.setFields(fields);
            }

            public BatchRunPivotReports setKey(String key) {
                return (BatchRunPivotReports)super.setKey(key);
            }

            public BatchRunPivotReports setOauthToken(String oauthToken) {
                return (BatchRunPivotReports)super.setOauthToken(oauthToken);
            }

            public BatchRunPivotReports setPrettyPrint(Boolean prettyPrint) {
                return (BatchRunPivotReports)super.setPrettyPrint(prettyPrint);
            }

            public BatchRunPivotReports setQuotaUser(String quotaUser) {
                return (BatchRunPivotReports)super.setQuotaUser(quotaUser);
            }

            public BatchRunPivotReports setUploadType(String uploadType) {
                return (BatchRunPivotReports)super.setUploadType(uploadType);
            }

            public BatchRunPivotReports setUploadProtocol(String uploadProtocol) {
                return (BatchRunPivotReports)super.setUploadProtocol(uploadProtocol);
            }

            public String getProperty() {
                return this.property;
            }

            public BatchRunPivotReports setProperty(String property) {
                if (!AnalyticsData.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROPERTY_PATTERN.matcher(property).matches(), (Object)"Parameter property must conform to the pattern ^properties/[^/]+$");
                }
                this.property = property;
                return this;
            }

            @Override
            public BatchRunPivotReports set(String parameterName, Object value) {
                return (BatchRunPivotReports)super.set(parameterName, value);
            }
        }
    }
}

