/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This file was generated.
 *  with google-apis-code-generator 1.3.0 (build: 2013-06-05 16:09:48 UTC)
 *  on 2013-06-11 at 20:17:07 UTC 
 */

package com.google.api.services.androidpublisher;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.common.base.Preconditions;

/**
 * Service definition for Androidpublisher (v1).
 *
 * <p>
 * Lets Android application developers access their Google Play accounts.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/android-publisher" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link AndroidpublisherRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * <p>
 * Upgrade warning: this class now extends {@link AbstractGoogleJsonClient}, whereas in prior
 * version 1.8 it extended {@link com.google.api.client.googleapis.services.GoogleClient}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Androidpublisher extends AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    Preconditions.checkState(GoogleUtils.VERSION.equals("1.13.2-beta"),
        "You are currently running with version %s of google-api-client. " +
        "You need version 1.13.2-beta of google-api-client to run version " +
        "1.13.2-beta of the Google Play Android Developer API library.", GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "androidpublisher/v1/applications/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   * @deprecated (scheduled to be removed in 1.13)
   */
  @Deprecated
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport
   * @param jsonFactory JSON factory
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Androidpublisher(HttpTransport transport, JsonFactory jsonFactory,
      HttpRequestInitializer httpRequestInitializer) {
    super(transport,
        jsonFactory,
        DEFAULT_ROOT_URL,
        DEFAULT_SERVICE_PATH,
        httpRequestInitializer,
        false);
  }

  /**
   * @param transport HTTP transport
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @param rootUrl root URL of the service
   * @param servicePath service path
   * @param jsonObjectParser JSON object parser
   * @param googleClientRequestInitializer Google request initializer or {@code null} for none
   * @param applicationName application name to be sent in the User-Agent header of requests or
   *        {@code null} for none
   * @param suppressPatternChecks whether discovery pattern checks should be suppressed on required
   *        parameters
   */
  Androidpublisher(HttpTransport transport,
      HttpRequestInitializer httpRequestInitializer,
      String rootUrl,
      String servicePath,
      JsonObjectParser jsonObjectParser,
      GoogleClientRequestInitializer googleClientRequestInitializer,
      String applicationName,
      boolean suppressPatternChecks) {
    super(transport,
        httpRequestInitializer,
        rootUrl,
        servicePath,
        jsonObjectParser,
        googleClientRequestInitializer,
        applicationName,
        suppressPatternChecks);
  }

  @Override
  protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Purchases collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Androidpublisher androidpublisher = new Androidpublisher(...);}
   *   {@code Androidpublisher.Purchases.List request = androidpublisher.purchases().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Purchases purchases() {
    return new Purchases();
  }

  /**
   * The "purchases" collection of methods.
   */
  public class Purchases {

    /**
     * Cancels a user's subscription purchase. The subscription remains valid until its expiration time.
     *
     * Create a request for the method "purchases.cancel".
     *
     * This request holds the parameters needed by the the androidpublisher server.  After setting any
     * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
     *
     * @param packageName The package name of the application for which this subscription was purchased (for example,
     *        'com.some.thing').
     * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
     * @param token The token provided to the user's device when the subscription was purchased.
     * @return the request
     */
    public Cancel cancel(String packageName, String subscriptionId, String token) throws java.io.IOException {
      Cancel result = new Cancel(packageName, subscriptionId, token);
      initialize(result);
      return result;
    }

    public class Cancel extends AndroidpublisherRequest<Void> {

      private static final String REST_PATH = "{packageName}/subscriptions/{subscriptionId}/purchases/{token}/cancel";

      /**
       * Cancels a user's subscription purchase. The subscription remains valid until its expiration
       * time.
       *
       * Create a request for the method "purchases.cancel".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
       * <p> {@link Cancel#initialize(AbstractGoogleClientRequest)} must be called to initialize this
       * instance immediately after invoking the constructor. </p>
       *
       * @param packageName The package name of the application for which this subscription was purchased (for example,
     *        'com.some.thing').
       * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
       * @param token The token provided to the user's device when the subscription was purchased.
       * @since 1.13
       */
      protected Cancel(String packageName, String subscriptionId, String token) {
        super(Androidpublisher.this, "POST", REST_PATH, null, Void.class);
        this.packageName = Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.subscriptionId = Preconditions.checkNotNull(subscriptionId, "Required parameter subscriptionId must be specified.");
        this.token = Preconditions.checkNotNull(token, "Required parameter token must be specified.");
      }

      @Override
      public Cancel setAlt(String alt) {
        return (Cancel) super.setAlt(alt);
      }

      @Override
      public Cancel setFields(String fields) {
        return (Cancel) super.setFields(fields);
      }

      @Override
      public Cancel setKey(String key) {
        return (Cancel) super.setKey(key);
      }

      @Override
      public Cancel setOauthToken(String oauthToken) {
        return (Cancel) super.setOauthToken(oauthToken);
      }

      @Override
      public Cancel setPrettyPrint(Boolean prettyPrint) {
        return (Cancel) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Cancel setQuotaUser(String quotaUser) {
        return (Cancel) super.setQuotaUser(quotaUser);
      }

      @Override
      public Cancel setUserIp(String userIp) {
        return (Cancel) super.setUserIp(userIp);
      }

      /**
     * The package name of the application for which this subscription was purchased (for example,
     * 'com.some.thing').
     */
      @com.google.api.client.util.Key
      private String packageName;

      /** The package name of the application for which this subscription was purchased (for example,
     'com.some.thing').
       */
      public String getPackageName() {
        return packageName;
      }

      /**
     * The package name of the application for which this subscription was purchased (for example,
     * 'com.some.thing').
     */
      public Cancel setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** The purchased subscription ID (for example, 'monthly001'). */
      @com.google.api.client.util.Key
      private String subscriptionId;

      /** The purchased subscription ID (for example, 'monthly001').
       */
      public String getSubscriptionId() {
        return subscriptionId;
      }

      /** The purchased subscription ID (for example, 'monthly001'). */
      public Cancel setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
      }

      /** The token provided to the user's device when the subscription was purchased. */
      @com.google.api.client.util.Key
      private String token;

      /** The token provided to the user's device when the subscription was purchased.
       */
      public String getToken() {
        return token;
      }

      /** The token provided to the user's device when the subscription was purchased. */
      public Cancel setToken(String token) {
        this.token = token;
        return this;
      }

    }
    /**
     * Checks whether a user's subscription purchase is valid and returns its expiry time.
     *
     * Create a request for the method "purchases.get".
     *
     * This request holds the parameters needed by the the androidpublisher server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param packageName The package name of the application for which this subscription was purchased (for example,
     *        'com.some.thing').
     * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
     * @param token The token provided to the user's device when the subscription was purchased.
     * @return the request
     */
    public Get get(String packageName, String subscriptionId, String token) throws java.io.IOException {
      Get result = new Get(packageName, subscriptionId, token);
      initialize(result);
      return result;
    }

    public class Get extends AndroidpublisherRequest<com.google.api.services.androidpublisher.model.SubscriptionPurchase> {

      private static final String REST_PATH = "{packageName}/subscriptions/{subscriptionId}/purchases/{token}";

      /**
       * Checks whether a user's subscription purchase is valid and returns its expiry time.
       *
       * Create a request for the method "purchases.get".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param packageName The package name of the application for which this subscription was purchased (for example,
     *        'com.some.thing').
       * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
       * @param token The token provided to the user's device when the subscription was purchased.
       * @since 1.13
       */
      protected Get(String packageName, String subscriptionId, String token) {
        super(Androidpublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.SubscriptionPurchase.class);
        this.packageName = Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.subscriptionId = Preconditions.checkNotNull(subscriptionId, "Required parameter subscriptionId must be specified.");
        this.token = Preconditions.checkNotNull(token, "Required parameter token must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /**
     * The package name of the application for which this subscription was purchased (for example,
     * 'com.some.thing').
     */
      @com.google.api.client.util.Key
      private String packageName;

      /** The package name of the application for which this subscription was purchased (for example,
     'com.some.thing').
       */
      public String getPackageName() {
        return packageName;
      }

      /**
     * The package name of the application for which this subscription was purchased (for example,
     * 'com.some.thing').
     */
      public Get setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** The purchased subscription ID (for example, 'monthly001'). */
      @com.google.api.client.util.Key
      private String subscriptionId;

      /** The purchased subscription ID (for example, 'monthly001').
       */
      public String getSubscriptionId() {
        return subscriptionId;
      }

      /** The purchased subscription ID (for example, 'monthly001'). */
      public Get setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
      }

      /** The token provided to the user's device when the subscription was purchased. */
      @com.google.api.client.util.Key
      private String token;

      /** The token provided to the user's device when the subscription was purchased.
       */
      public String getToken() {
        return token;
      }

      /** The token provided to the user's device when the subscription was purchased. */
      public Get setToken(String token) {
        this.token = token;
        return this;
      }

    }

  }

  /**
   * Builder for {@link Androidpublisher}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport
     * @param jsonFactory JSON factory
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(HttpTransport transport, JsonFactory jsonFactory,
        HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Androidpublisher}. */
    @Override
    public Androidpublisher build() {
      return new Androidpublisher(getTransport(),
          getHttpRequestInitializer(),
          getRootUrl(),
          getServicePath(),
          getObjectParser(),
          getGoogleClientRequestInitializer(),
          getApplicationName(),
          getSuppressPatternChecks());
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    /**
     * Set the {@link AndroidpublisherRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setAndroidpublisherRequestInitializer(
        AndroidpublisherRequestInitializer androidpublisherRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(androidpublisherRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
