/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;

/**
 * A Purchase resource indicates the status of a user's subscription purchase.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionPurchase extends GenericJson {

  /**
   * Whether the subscription will automatically be renewed when it reaches its current expiry time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean autoRenewing;

  /**
   * Time at which the subscription was granted, in milliseconds since Epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private Long initiationTimestampMsec;

  /**
   * This kind represents a subscriptionPurchase object in the androidpublisher service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Time at which the subscription will expire, in milliseconds since Epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private Long validUntilTimestampMsec;

  /**
   * Whether the subscription will automatically be renewed when it reaches its current expiry time.
   * The value returned may be {@code null}.
   */
  public Boolean getAutoRenewing() {
    return autoRenewing;
  }

  /**
   * Whether the subscription will automatically be renewed when it reaches its current expiry time.
   * The value set may be {@code null}.
   */
  public SubscriptionPurchase setAutoRenewing(Boolean autoRenewing) {
    this.autoRenewing = autoRenewing;
    return this;
  }

  /**
   * Time at which the subscription was granted, in milliseconds since Epoch.
   * The value returned may be {@code null}.
   */
  public Long getInitiationTimestampMsec() {
    return initiationTimestampMsec;
  }

  /**
   * Time at which the subscription was granted, in milliseconds since Epoch.
   * The value set may be {@code null}.
   */
  public SubscriptionPurchase setInitiationTimestampMsec(Long initiationTimestampMsec) {
    this.initiationTimestampMsec = initiationTimestampMsec;
    return this;
  }

  /**
   * This kind represents a subscriptionPurchase object in the androidpublisher service.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * This kind represents a subscriptionPurchase object in the androidpublisher service.
   * The value set may be {@code null}.
   */
  public SubscriptionPurchase setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Time at which the subscription will expire, in milliseconds since Epoch.
   * The value returned may be {@code null}.
   */
  public Long getValidUntilTimestampMsec() {
    return validUntilTimestampMsec;
  }

  /**
   * Time at which the subscription will expire, in milliseconds since Epoch.
   * The value set may be {@code null}.
   */
  public SubscriptionPurchase setValidUntilTimestampMsec(Long validUntilTimestampMsec) {
    this.validUntilTimestampMsec = validUntilTimestampMsec;
    return this;
  }

}
