/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.androidpublisher;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.androidpublisher.AndroidPublisherRequest;
import com.google.api.services.androidpublisher.AndroidPublisherRequestInitializer;
import com.google.api.services.androidpublisher.model.SubscriptionPurchase;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidPublisher
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "androidpublisher/v1/applications/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/androidpublisher/v1/applications/";

    public AndroidPublisher(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    AndroidPublisher(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Purchases purchases() {
        return new Purchases();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.18.0-rc of the Google Play Android Developer API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, AndroidPublisher.DEFAULT_ROOT_URL, AndroidPublisher.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public AndroidPublisher build() {
            return new AndroidPublisher(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setAndroidPublisherRequestInitializer(AndroidPublisherRequestInitializer androidPublisherRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)androidPublisherRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Purchases {
        public Cancel cancel(String string, String string2, String string3) throws IOException {
            Cancel cancel = new Cancel(string, string2, string3);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)cancel);
            return cancel;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends AndroidPublisherRequest<SubscriptionPurchase> {
            private static final String REST_PATH = "{packageName}/subscriptions/{subscriptionId}/purchases/{token}";
            @Key
            private String packageName;
            @Key
            private String subscriptionId;
            @Key
            private String token;

            protected Get(String string, String string2, String string3) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, SubscriptionPurchase.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.subscriptionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter subscriptionId must be specified.");
                this.token = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter token must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getSubscriptionId() {
                return this.subscriptionId;
            }

            public Get setSubscriptionId(String string) {
                this.subscriptionId = string;
                return this;
            }

            public String getToken() {
                return this.token;
            }

            public Get setToken(String string) {
                this.token = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Cancel
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "{packageName}/subscriptions/{subscriptionId}/purchases/{token}/cancel";
            @Key
            private String packageName;
            @Key
            private String subscriptionId;
            @Key
            private String token;

            protected Cancel(String string, String string2, String string3) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.subscriptionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter subscriptionId must be specified.");
                this.token = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter token must be specified.");
            }

            public Cancel setAlt(String string) {
                return (Cancel)super.setAlt(string);
            }

            public Cancel setFields(String string) {
                return (Cancel)super.setFields(string);
            }

            public Cancel setKey(String string) {
                return (Cancel)super.setKey(string);
            }

            public Cancel setOauthToken(String string) {
                return (Cancel)super.setOauthToken(string);
            }

            public Cancel setPrettyPrint(Boolean bl) {
                return (Cancel)super.setPrettyPrint(bl);
            }

            public Cancel setQuotaUser(String string) {
                return (Cancel)super.setQuotaUser(string);
            }

            public Cancel setUserIp(String string) {
                return (Cancel)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Cancel setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getSubscriptionId() {
                return this.subscriptionId;
            }

            public Cancel setSubscriptionId(String string) {
                this.subscriptionId = string;
                return this;
            }

            public String getToken() {
                return this.token;
            }

            public Cancel setToken(String string) {
                this.token = string;
                return this;
            }

            @Override
            public Cancel set(String string, Object object) {
                return (Cancel)super.set(string, object);
            }
        }
    }
}

