/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-02-14 18:40:25 UTC)
 * on 2014-03-26 at 04:27:27 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A Purchase resource indicates the status of a user's subscription purchase.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionPurchase extends com.google.api.client.json.GenericJson {

  /**
   * Whether the subscription will automatically be renewed when it reaches its current expiry time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoRenewing;

  /**
   * Time at which the subscription was granted, in milliseconds since Epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long initiationTimestampMsec;

  /**
   * This kind represents a subscriptionPurchase object in the androidpublisher service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Time at which the subscription will expire, in milliseconds since Epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long validUntilTimestampMsec;

  /**
   * Whether the subscription will automatically be renewed when it reaches its current expiry time.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoRenewing() {
    return autoRenewing;
  }

  /**
   * Whether the subscription will automatically be renewed when it reaches its current expiry time.
   * @param autoRenewing autoRenewing or {@code null} for none
   */
  public SubscriptionPurchase setAutoRenewing(java.lang.Boolean autoRenewing) {
    this.autoRenewing = autoRenewing;
    return this;
  }

  /**
   * Time at which the subscription was granted, in milliseconds since Epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getInitiationTimestampMsec() {
    return initiationTimestampMsec;
  }

  /**
   * Time at which the subscription was granted, in milliseconds since Epoch.
   * @param initiationTimestampMsec initiationTimestampMsec or {@code null} for none
   */
  public SubscriptionPurchase setInitiationTimestampMsec(java.lang.Long initiationTimestampMsec) {
    this.initiationTimestampMsec = initiationTimestampMsec;
    return this;
  }

  /**
   * This kind represents a subscriptionPurchase object in the androidpublisher service.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This kind represents a subscriptionPurchase object in the androidpublisher service.
   * @param kind kind or {@code null} for none
   */
  public SubscriptionPurchase setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Time at which the subscription will expire, in milliseconds since Epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getValidUntilTimestampMsec() {
    return validUntilTimestampMsec;
  }

  /**
   * Time at which the subscription will expire, in milliseconds since Epoch.
   * @param validUntilTimestampMsec validUntilTimestampMsec or {@code null} for none
   */
  public SubscriptionPurchase setValidUntilTimestampMsec(java.lang.Long validUntilTimestampMsec) {
    this.validUntilTimestampMsec = validUntilTimestampMsec;
    return this;
  }

  @Override
  public SubscriptionPurchase set(String fieldName, Object value) {
    return (SubscriptionPurchase) super.set(fieldName, value);
  }

  @Override
  public SubscriptionPurchase clone() {
    return (SubscriptionPurchase) super.clone();
  }

}
