/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.androidpublisher;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.androidpublisher.AndroidPublisherRequest;
import com.google.api.services.androidpublisher.AndroidPublisherRequestInitializer;
import com.google.api.services.androidpublisher.model.InappPurchase;
import com.google.api.services.androidpublisher.model.SubscriptionPurchase;
import java.io.IOException;

public class AndroidPublisher
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "androidpublisher/v1.1/applications/";
    public static final String DEFAULT_BATCH_PATH = "batch/androidpublisher/v1.1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/androidpublisher/v1.1/applications/";

    public AndroidPublisher(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    AndroidPublisher(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Inapppurchases inapppurchases() {
        return new Inapppurchases();
    }

    public Purchases purchases() {
        return new Purchases();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.3 of the Google Play Developer API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, AndroidPublisher.DEFAULT_ROOT_URL, AndroidPublisher.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(AndroidPublisher.DEFAULT_BATCH_PATH);
        }

        public AndroidPublisher build() {
            return new AndroidPublisher(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setAndroidPublisherRequestInitializer(AndroidPublisherRequestInitializer androidpublisherRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)androidpublisherRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Purchases {
        public Cancel cancel(String packageName, String subscriptionId, String token) throws IOException {
            Cancel result = new Cancel(packageName, subscriptionId, token);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String packageName, String subscriptionId, String token) throws IOException {
            Get result = new Get(packageName, subscriptionId, token);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends AndroidPublisherRequest<SubscriptionPurchase> {
            private static final String REST_PATH = "{packageName}/subscriptions/{subscriptionId}/purchases/{token}";
            @Key
            private String packageName;
            @Key
            private String subscriptionId;
            @Key
            private String token;

            protected Get(String packageName, String subscriptionId, String token) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, SubscriptionPurchase.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getSubscriptionId() {
                return this.subscriptionId;
            }

            public Get setSubscriptionId(String subscriptionId) {
                this.subscriptionId = subscriptionId;
                return this;
            }

            public String getToken() {
                return this.token;
            }

            public Get setToken(String token) {
                this.token = token;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Cancel
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "{packageName}/subscriptions/{subscriptionId}/purchases/{token}/cancel";
            @Key
            private String packageName;
            @Key
            private String subscriptionId;
            @Key
            private String token;

            protected Cancel(String packageName, String subscriptionId, String token) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
            }

            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            public Cancel setUserIp(String userIp) {
                return (Cancel)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Cancel setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getSubscriptionId() {
                return this.subscriptionId;
            }

            public Cancel setSubscriptionId(String subscriptionId) {
                this.subscriptionId = subscriptionId;
                return this;
            }

            public String getToken() {
                return this.token;
            }

            public Cancel setToken(String token) {
                this.token = token;
                return this;
            }

            @Override
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }
    }

    public class Inapppurchases {
        public Get get(String packageName, String productId, String token) throws IOException {
            Get result = new Get(packageName, productId, token);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends AndroidPublisherRequest<InappPurchase> {
            private static final String REST_PATH = "{packageName}/inapp/{productId}/purchases/{token}";
            @Key
            private String packageName;
            @Key
            private String productId;
            @Key
            private String token;

            protected Get(String packageName, String productId, String token) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, InappPurchase.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Get setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            public String getToken() {
                return this.token;
            }

            public Get setToken(String token) {
                this.token = token;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

