/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;

/**
 * A Purchase resource indicates the status of a user's subscription purchase.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InappPurchase extends GenericJson {

  /**
   * The consumption state of the inapp product. Possible values are: - - Consumed  - - Yet to be
   * consumed
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer consumptionState;

  /**
   * A developer-specified string that contains supplemental information about an order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String developerPayload;

  /**
   * This kind represents a inappPurchase object in the androidpublisher service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The purchase state of the order. Possible values are: - - Purchased  - - Cancelled
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer purchaseState;

  /**
   * The time the product was purchased, in milliseconds since the epoch (Jan 1, 1970).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private Long purchaseTime;

  /**
   * The consumption state of the inapp product. Possible values are: - - Consumed  - - Yet to be
   * consumed
   * The value returned may be {@code null}.
   */
  public Integer getConsumptionState() {
    return consumptionState;
  }

  /**
   * The consumption state of the inapp product. Possible values are: - - Consumed  - - Yet to be
   * consumed
   * The value set may be {@code null}.
   */
  public InappPurchase setConsumptionState(Integer consumptionState) {
    this.consumptionState = consumptionState;
    return this;
  }

  /**
   * A developer-specified string that contains supplemental information about an order.
   * The value returned may be {@code null}.
   */
  public String getDeveloperPayload() {
    return developerPayload;
  }

  /**
   * A developer-specified string that contains supplemental information about an order.
   * The value set may be {@code null}.
   */
  public InappPurchase setDeveloperPayload(String developerPayload) {
    this.developerPayload = developerPayload;
    return this;
  }

  /**
   * This kind represents a inappPurchase object in the androidpublisher service.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * This kind represents a inappPurchase object in the androidpublisher service.
   * The value set may be {@code null}.
   */
  public InappPurchase setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The purchase state of the order. Possible values are: - - Purchased  - - Cancelled
   * The value returned may be {@code null}.
   */
  public Integer getPurchaseState() {
    return purchaseState;
  }

  /**
   * The purchase state of the order. Possible values are: - - Purchased  - - Cancelled
   * The value set may be {@code null}.
   */
  public InappPurchase setPurchaseState(Integer purchaseState) {
    this.purchaseState = purchaseState;
    return this;
  }

  /**
   * The time the product was purchased, in milliseconds since the epoch (Jan 1, 1970).
   * The value returned may be {@code null}.
   */
  public Long getPurchaseTime() {
    return purchaseTime;
  }

  /**
   * The time the product was purchased, in milliseconds since the epoch (Jan 1, 1970).
   * The value set may be {@code null}.
   */
  public InappPurchase setPurchaseTime(Long purchaseTime) {
    this.purchaseTime = purchaseTime;
    return this;
  }

}
