/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2018-11-19 at 15:51:23 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Information provided by the user when they complete the subscription cancellation flow
 * (cancellation reason survey).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionCancelSurveyResult extends com.google.api.client.json.GenericJson {

  /**
   * The cancellation reason the user chose in the survey. Possible values are: - Other  - I don't
   * use this service enough  - Technical issues  - Cost-related reasons  - I found a better app
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer cancelSurveyReason;

  /**
   * The customized input cancel reason from the user. Only present when cancelReason is 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userInputCancelReason;

  /**
   * The cancellation reason the user chose in the survey. Possible values are: - Other  - I don't
   * use this service enough  - Technical issues  - Cost-related reasons  - I found a better app
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCancelSurveyReason() {
    return cancelSurveyReason;
  }

  /**
   * The cancellation reason the user chose in the survey. Possible values are: - Other  - I don't
   * use this service enough  - Technical issues  - Cost-related reasons  - I found a better app
   * @param cancelSurveyReason cancelSurveyReason or {@code null} for none
   */
  public SubscriptionCancelSurveyResult setCancelSurveyReason(java.lang.Integer cancelSurveyReason) {
    this.cancelSurveyReason = cancelSurveyReason;
    return this;
  }

  /**
   * The customized input cancel reason from the user. Only present when cancelReason is 0.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserInputCancelReason() {
    return userInputCancelReason;
  }

  /**
   * The customized input cancel reason from the user. Only present when cancelReason is 0.
   * @param userInputCancelReason userInputCancelReason or {@code null} for none
   */
  public SubscriptionCancelSurveyResult setUserInputCancelReason(java.lang.String userInputCancelReason) {
    this.userInputCancelReason = userInputCancelReason;
    return this;
  }

  @Override
  public SubscriptionCancelSurveyResult set(String fieldName, Object value) {
    return (SubscriptionCancelSurveyResult) super.set(fieldName, value);
  }

  @Override
  public SubscriptionCancelSurveyResult clone() {
    return (SubscriptionCancelSurveyResult) super.clone();
  }

}
