/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-02-18 at 17:31:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A ProductPurchase resource indicates the status of a user's inapp product purchase.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductPurchase extends com.google.api.client.json.GenericJson {

  /**
   * The consumption state of the inapp product. Possible values are: - Yet to be consumed  -
   * Consumed
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer consumptionState;

  /**
   * A developer-specified string that contains supplemental information about an order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String developerPayload;

  /**
   * This kind represents an inappPurchase object in the androidpublisher service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The order id associated with the purchase of the inapp product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String orderId;

  /**
   * The purchase state of the order. Possible values are: - Purchased  - Canceled
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer purchaseState;

  /**
   * The time the product was purchased, in milliseconds since the epoch (Jan 1, 1970).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long purchaseTimeMillis;

  /**
   * The type of purchase of the inapp product. This field is only set if this purchase was not made
   * using the standard in-app billing flow. Possible values are: - Test (i.e. purchased from a
   * license testing account)  - Promo (i.e. purchased using a promo code)  - Rewarded (i.e. from
   * watching a video ad instead of paying)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer purchaseType;

  /**
   * The consumption state of the inapp product. Possible values are: - Yet to be consumed  -
   * Consumed
   * @return value or {@code null} for none
   */
  public java.lang.Integer getConsumptionState() {
    return consumptionState;
  }

  /**
   * The consumption state of the inapp product. Possible values are: - Yet to be consumed  -
   * Consumed
   * @param consumptionState consumptionState or {@code null} for none
   */
  public ProductPurchase setConsumptionState(java.lang.Integer consumptionState) {
    this.consumptionState = consumptionState;
    return this;
  }

  /**
   * A developer-specified string that contains supplemental information about an order.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeveloperPayload() {
    return developerPayload;
  }

  /**
   * A developer-specified string that contains supplemental information about an order.
   * @param developerPayload developerPayload or {@code null} for none
   */
  public ProductPurchase setDeveloperPayload(java.lang.String developerPayload) {
    this.developerPayload = developerPayload;
    return this;
  }

  /**
   * This kind represents an inappPurchase object in the androidpublisher service.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This kind represents an inappPurchase object in the androidpublisher service.
   * @param kind kind or {@code null} for none
   */
  public ProductPurchase setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The order id associated with the purchase of the inapp product.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrderId() {
    return orderId;
  }

  /**
   * The order id associated with the purchase of the inapp product.
   * @param orderId orderId or {@code null} for none
   */
  public ProductPurchase setOrderId(java.lang.String orderId) {
    this.orderId = orderId;
    return this;
  }

  /**
   * The purchase state of the order. Possible values are: - Purchased  - Canceled
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPurchaseState() {
    return purchaseState;
  }

  /**
   * The purchase state of the order. Possible values are: - Purchased  - Canceled
   * @param purchaseState purchaseState or {@code null} for none
   */
  public ProductPurchase setPurchaseState(java.lang.Integer purchaseState) {
    this.purchaseState = purchaseState;
    return this;
  }

  /**
   * The time the product was purchased, in milliseconds since the epoch (Jan 1, 1970).
   * @return value or {@code null} for none
   */
  public java.lang.Long getPurchaseTimeMillis() {
    return purchaseTimeMillis;
  }

  /**
   * The time the product was purchased, in milliseconds since the epoch (Jan 1, 1970).
   * @param purchaseTimeMillis purchaseTimeMillis or {@code null} for none
   */
  public ProductPurchase setPurchaseTimeMillis(java.lang.Long purchaseTimeMillis) {
    this.purchaseTimeMillis = purchaseTimeMillis;
    return this;
  }

  /**
   * The type of purchase of the inapp product. This field is only set if this purchase was not made
   * using the standard in-app billing flow. Possible values are: - Test (i.e. purchased from a
   * license testing account)  - Promo (i.e. purchased using a promo code)  - Rewarded (i.e. from
   * watching a video ad instead of paying)
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPurchaseType() {
    return purchaseType;
  }

  /**
   * The type of purchase of the inapp product. This field is only set if this purchase was not made
   * using the standard in-app billing flow. Possible values are: - Test (i.e. purchased from a
   * license testing account)  - Promo (i.e. purchased using a promo code)  - Rewarded (i.e. from
   * watching a video ad instead of paying)
   * @param purchaseType purchaseType or {@code null} for none
   */
  public ProductPurchase setPurchaseType(java.lang.Integer purchaseType) {
    this.purchaseType = purchaseType;
    return this;
  }

  @Override
  public ProductPurchase set(String fieldName, Object value) {
    return (ProductPurchase) super.set(fieldName, value);
  }

  @Override
  public ProductPurchase clone() {
    return (ProductPurchase) super.clone();
  }

}
