/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-18 at 17:10:38 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Represents the binary payload of an APK.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ApkBinary extends com.google.api.client.json.GenericJson {

  /**
   * A sha1 hash of the APK payload, encoded as a hex string and matching the output of the sha1sum
   * command.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha1;

  /**
   * A sha1 hash of the APK payload, encoded as a hex string and matching the output of the sha1sum
   * command.
   * @return value or {@code null} for none
   */
  public java.lang.String getSha1() {
    return sha1;
  }

  /**
   * A sha1 hash of the APK payload, encoded as a hex string and matching the output of the sha1sum
   * command.
   * @param sha1 sha1 or {@code null} for none
   */
  public ApkBinary setSha1(java.lang.String sha1) {
    this.sha1 = sha1;
    return this;
  }

  @Override
  public ApkBinary set(String fieldName, Object value) {
    return (ApkBinary) super.set(fieldName, value);
  }

  @Override
  public ApkBinary clone() {
    return (ApkBinary) super.clone();
  }

}
