/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-10-05 at 15:58:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A SubscriptionPurchase resource indicates the status of a user's subscription purchase.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionPurchase extends com.google.api.client.json.GenericJson {

  /**
   * Whether the subscription will automatically be renewed when it reaches its current expiry time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoRenewing;

  /**
   * The reason why a subscription was cancelled or is not auto-renewing. Possible values are: -
   * User cancelled the subscription  - Subscription was cancelled by the system, for example
   * because of a billing problem
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer cancelReason;

  /**
   * ISO 3166-1 alpha-2 billing country/region code of the user at the time the subscription was
   * granted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * A developer-specified string that contains supplemental information about an order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String developerPayload;

  /**
   * Time at which the subscription will expire, in milliseconds since the Epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expiryTimeMillis;

  /**
   * This kind represents a subscriptionPurchase object in the androidpublisher service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The payment state of the subscription. Possible values are: - Payment pending  - Payment
   * received
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer paymentState;

  /**
   * Price of the subscription, not including tax. Price is expressed in micro-units, where
   * 1,000,000 micro-units represents one unit of the currency. For example, if the subscription
   * price is €1.99, price_amount_micros is 1990000.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long priceAmountMicros;

  /**
   * ISO 4217 currency code for the subscription price. For example, if the price is specified in
   * British pounds sterling, price_currency_code is "GBP".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String priceCurrencyCode;

  /**
   * Time at which the subscription was granted, in milliseconds since the Epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long startTimeMillis;

  /**
   * Whether the subscription will automatically be renewed when it reaches its current expiry time.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoRenewing() {
    return autoRenewing;
  }

  /**
   * Whether the subscription will automatically be renewed when it reaches its current expiry time.
   * @param autoRenewing autoRenewing or {@code null} for none
   */
  public SubscriptionPurchase setAutoRenewing(java.lang.Boolean autoRenewing) {
    this.autoRenewing = autoRenewing;
    return this;
  }

  /**
   * The reason why a subscription was cancelled or is not auto-renewing. Possible values are: -
   * User cancelled the subscription  - Subscription was cancelled by the system, for example
   * because of a billing problem
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCancelReason() {
    return cancelReason;
  }

  /**
   * The reason why a subscription was cancelled or is not auto-renewing. Possible values are: -
   * User cancelled the subscription  - Subscription was cancelled by the system, for example
   * because of a billing problem
   * @param cancelReason cancelReason or {@code null} for none
   */
  public SubscriptionPurchase setCancelReason(java.lang.Integer cancelReason) {
    this.cancelReason = cancelReason;
    return this;
  }

  /**
   * ISO 3166-1 alpha-2 billing country/region code of the user at the time the subscription was
   * granted.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * ISO 3166-1 alpha-2 billing country/region code of the user at the time the subscription was
   * granted.
   * @param countryCode countryCode or {@code null} for none
   */
  public SubscriptionPurchase setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * A developer-specified string that contains supplemental information about an order.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeveloperPayload() {
    return developerPayload;
  }

  /**
   * A developer-specified string that contains supplemental information about an order.
   * @param developerPayload developerPayload or {@code null} for none
   */
  public SubscriptionPurchase setDeveloperPayload(java.lang.String developerPayload) {
    this.developerPayload = developerPayload;
    return this;
  }

  /**
   * Time at which the subscription will expire, in milliseconds since the Epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpiryTimeMillis() {
    return expiryTimeMillis;
  }

  /**
   * Time at which the subscription will expire, in milliseconds since the Epoch.
   * @param expiryTimeMillis expiryTimeMillis or {@code null} for none
   */
  public SubscriptionPurchase setExpiryTimeMillis(java.lang.Long expiryTimeMillis) {
    this.expiryTimeMillis = expiryTimeMillis;
    return this;
  }

  /**
   * This kind represents a subscriptionPurchase object in the androidpublisher service.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This kind represents a subscriptionPurchase object in the androidpublisher service.
   * @param kind kind or {@code null} for none
   */
  public SubscriptionPurchase setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The payment state of the subscription. Possible values are: - Payment pending  - Payment
   * received
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPaymentState() {
    return paymentState;
  }

  /**
   * The payment state of the subscription. Possible values are: - Payment pending  - Payment
   * received
   * @param paymentState paymentState or {@code null} for none
   */
  public SubscriptionPurchase setPaymentState(java.lang.Integer paymentState) {
    this.paymentState = paymentState;
    return this;
  }

  /**
   * Price of the subscription, not including tax. Price is expressed in micro-units, where
   * 1,000,000 micro-units represents one unit of the currency. For example, if the subscription
   * price is €1.99, price_amount_micros is 1990000.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPriceAmountMicros() {
    return priceAmountMicros;
  }

  /**
   * Price of the subscription, not including tax. Price is expressed in micro-units, where
   * 1,000,000 micro-units represents one unit of the currency. For example, if the subscription
   * price is €1.99, price_amount_micros is 1990000.
   * @param priceAmountMicros priceAmountMicros or {@code null} for none
   */
  public SubscriptionPurchase setPriceAmountMicros(java.lang.Long priceAmountMicros) {
    this.priceAmountMicros = priceAmountMicros;
    return this;
  }

  /**
   * ISO 4217 currency code for the subscription price. For example, if the price is specified in
   * British pounds sterling, price_currency_code is "GBP".
   * @return value or {@code null} for none
   */
  public java.lang.String getPriceCurrencyCode() {
    return priceCurrencyCode;
  }

  /**
   * ISO 4217 currency code for the subscription price. For example, if the price is specified in
   * British pounds sterling, price_currency_code is "GBP".
   * @param priceCurrencyCode priceCurrencyCode or {@code null} for none
   */
  public SubscriptionPurchase setPriceCurrencyCode(java.lang.String priceCurrencyCode) {
    this.priceCurrencyCode = priceCurrencyCode;
    return this;
  }

  /**
   * Time at which the subscription was granted, in milliseconds since the Epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStartTimeMillis() {
    return startTimeMillis;
  }

  /**
   * Time at which the subscription was granted, in milliseconds since the Epoch.
   * @param startTimeMillis startTimeMillis or {@code null} for none
   */
  public SubscriptionPurchase setStartTimeMillis(java.lang.Long startTimeMillis) {
    this.startTimeMillis = startTimeMillis;
    return this;
  }

  @Override
  public SubscriptionPurchase set(String fieldName, Object value) {
    return (SubscriptionPurchase) super.set(fieldName, value);
  }

  @Override
  public SubscriptionPurchase clone() {
    return (SubscriptionPurchase) super.clone();
  }

}
