/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-04-27 at 13:54:39 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * An Entitlement resource indicates a user's current entitlement to an inapp item or subscription.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Entitlement extends com.google.api.client.json.GenericJson {

  /**
   * This kind represents an entitlement object in the androidpublisher service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The SKU of the product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productId;

  /**
   * The type of the inapp product. Possible values are: - In-app item: "inapp"  - Subscription:
   * "subs"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productType;

  /**
   * The token which can be verified using the subscriptions or products API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String token;

  /**
   * This kind represents an entitlement object in the androidpublisher service.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This kind represents an entitlement object in the androidpublisher service.
   * @param kind kind or {@code null} for none
   */
  public Entitlement setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The SKU of the product.
   * @return value or {@code null} for none
   */
  public java.lang.String getProductId() {
    return productId;
  }

  /**
   * The SKU of the product.
   * @param productId productId or {@code null} for none
   */
  public Entitlement setProductId(java.lang.String productId) {
    this.productId = productId;
    return this;
  }

  /**
   * The type of the inapp product. Possible values are: - In-app item: "inapp"  - Subscription:
   * "subs"
   * @return value or {@code null} for none
   */
  public java.lang.String getProductType() {
    return productType;
  }

  /**
   * The type of the inapp product. Possible values are: - In-app item: "inapp"  - Subscription:
   * "subs"
   * @param productType productType or {@code null} for none
   */
  public Entitlement setProductType(java.lang.String productType) {
    this.productType = productType;
    return this;
  }

  /**
   * The token which can be verified using the subscriptions or products API.
   * @return value or {@code null} for none
   */
  public java.lang.String getToken() {
    return token;
  }

  /**
   * The token which can be verified using the subscriptions or products API.
   * @param token token or {@code null} for none
   */
  public Entitlement setToken(java.lang.String token) {
    this.token = token;
    return this;
  }

  @Override
  public Entitlement set(String fieldName, Object value) {
    return (Entitlement) super.set(fieldName, value);
  }

  @Override
  public Entitlement clone() {
    return (Entitlement) super.clone();
  }

}
