/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-09-05 21:06:36 UTC)
 * on 2017-09-20 at 19:57:05 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Model definition for ExpansionFile.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExpansionFile extends com.google.api.client.json.GenericJson {

  /**
   * If set this field indicates that this APK has an Expansion File uploaded to it: this APK does
   * not reference another APK's Expansion File. The field's value is the size of the uploaded
   * Expansion File in bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long fileSize;

  /**
   * If set this APK's Expansion File references another APK's Expansion File. The file_size field
   * will not be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer referencesVersion;

  /**
   * If set this field indicates that this APK has an Expansion File uploaded to it: this APK does
   * not reference another APK's Expansion File. The field's value is the size of the uploaded
   * Expansion File in bytes.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFileSize() {
    return fileSize;
  }

  /**
   * If set this field indicates that this APK has an Expansion File uploaded to it: this APK does
   * not reference another APK's Expansion File. The field's value is the size of the uploaded
   * Expansion File in bytes.
   * @param fileSize fileSize or {@code null} for none
   */
  public ExpansionFile setFileSize(java.lang.Long fileSize) {
    this.fileSize = fileSize;
    return this;
  }

  /**
   * If set this APK's Expansion File references another APK's Expansion File. The file_size field
   * will not be set.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getReferencesVersion() {
    return referencesVersion;
  }

  /**
   * If set this APK's Expansion File references another APK's Expansion File. The file_size field
   * will not be set.
   * @param referencesVersion referencesVersion or {@code null} for none
   */
  public ExpansionFile setReferencesVersion(java.lang.Integer referencesVersion) {
    this.referencesVersion = referencesVersion;
    return this;
  }

  @Override
  public ExpansionFile set(String fieldName, Object value) {
    return (ExpansionFile) super.set(fieldName, value);
  }

  @Override
  public ExpansionFile clone() {
    return (ExpansionFile) super.clone();
  }

}
