/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-07 at 01:11:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Model definition for Apk.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Apk extends com.google.api.client.json.GenericJson {

  /**
   * Information about the binary payload of this APK.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ApkBinary binary;

  /**
   * The version code of the APK, as specified in the APK's manifest file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer versionCode;

  /**
   * Information about the binary payload of this APK.
   * @return value or {@code null} for none
   */
  public ApkBinary getBinary() {
    return binary;
  }

  /**
   * Information about the binary payload of this APK.
   * @param binary binary or {@code null} for none
   */
  public Apk setBinary(ApkBinary binary) {
    this.binary = binary;
    return this;
  }

  /**
   * The version code of the APK, as specified in the APK's manifest file.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVersionCode() {
    return versionCode;
  }

  /**
   * The version code of the APK, as specified in the APK's manifest file.
   * @param versionCode versionCode or {@code null} for none
   */
  public Apk setVersionCode(java.lang.Integer versionCode) {
    this.versionCode = versionCode;
    return this;
  }

  @Override
  public Apk set(String fieldName, Object value) {
    return (Apk) super.set(fieldName, value);
  }

  @Override
  public Apk clone() {
    return (Apk) super.clone();
  }

}
