/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.androidpublisher;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.androidpublisher.AndroidPublisherRequest;
import com.google.api.services.androidpublisher.AndroidPublisherRequestInitializer;
import com.google.api.services.androidpublisher.model.Apk;
import com.google.api.services.androidpublisher.model.ApkListing;
import com.google.api.services.androidpublisher.model.ApkListingsListResponse;
import com.google.api.services.androidpublisher.model.ApksAddExternallyHostedRequest;
import com.google.api.services.androidpublisher.model.ApksAddExternallyHostedResponse;
import com.google.api.services.androidpublisher.model.ApksListResponse;
import com.google.api.services.androidpublisher.model.AppDetails;
import com.google.api.services.androidpublisher.model.AppEdit;
import com.google.api.services.androidpublisher.model.Bundle;
import com.google.api.services.androidpublisher.model.BundlesListResponse;
import com.google.api.services.androidpublisher.model.DeobfuscationFilesUploadResponse;
import com.google.api.services.androidpublisher.model.ExpansionFile;
import com.google.api.services.androidpublisher.model.ExpansionFilesUploadResponse;
import com.google.api.services.androidpublisher.model.ImagesDeleteAllResponse;
import com.google.api.services.androidpublisher.model.ImagesListResponse;
import com.google.api.services.androidpublisher.model.ImagesUploadResponse;
import com.google.api.services.androidpublisher.model.InAppProduct;
import com.google.api.services.androidpublisher.model.InappproductsListResponse;
import com.google.api.services.androidpublisher.model.Listing;
import com.google.api.services.androidpublisher.model.ListingsListResponse;
import com.google.api.services.androidpublisher.model.ProductPurchase;
import com.google.api.services.androidpublisher.model.Review;
import com.google.api.services.androidpublisher.model.ReviewsListResponse;
import com.google.api.services.androidpublisher.model.ReviewsReplyRequest;
import com.google.api.services.androidpublisher.model.ReviewsReplyResponse;
import com.google.api.services.androidpublisher.model.SubscriptionPurchase;
import com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferRequest;
import com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferResponse;
import com.google.api.services.androidpublisher.model.Testers;
import com.google.api.services.androidpublisher.model.Track;
import com.google.api.services.androidpublisher.model.TracksListResponse;
import com.google.api.services.androidpublisher.model.VoidedPurchasesListResponse;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidPublisher
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "androidpublisher/v2/applications/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/androidpublisher/v2/applications/";

    public AndroidPublisher(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    AndroidPublisher(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Edits edits() {
        return new Edits();
    }

    public Inappproducts inappproducts() {
        return new Inappproducts();
    }

    public Orders orders() {
        return new Orders();
    }

    public Purchases purchases() {
        return new Purchases();
    }

    public Reviews reviews() {
        return new Reviews();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.18.0-rc of the Google Play Developer API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, AndroidPublisher.DEFAULT_ROOT_URL, AndroidPublisher.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public AndroidPublisher build() {
            return new AndroidPublisher(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setAndroidPublisherRequestInitializer(AndroidPublisherRequestInitializer androidPublisherRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)androidPublisherRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Reviews {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Reply reply(String string, String string2, ReviewsReplyRequest reviewsReplyRequest) throws IOException {
            Reply reply = new Reply(string, string2, reviewsReplyRequest);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)reply);
            return reply;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Reply
        extends AndroidPublisherRequest<ReviewsReplyResponse> {
            private static final String REST_PATH = "{packageName}/reviews/{reviewId}:reply";
            @Key
            private String packageName;
            @Key
            private String reviewId;

            protected Reply(String string, String string2, ReviewsReplyRequest reviewsReplyRequest) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)reviewsReplyRequest, ReviewsReplyResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.reviewId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter reviewId must be specified.");
            }

            public Reply setAlt(String string) {
                return (Reply)super.setAlt(string);
            }

            public Reply setFields(String string) {
                return (Reply)super.setFields(string);
            }

            public Reply setKey(String string) {
                return (Reply)super.setKey(string);
            }

            public Reply setOauthToken(String string) {
                return (Reply)super.setOauthToken(string);
            }

            public Reply setPrettyPrint(Boolean bl) {
                return (Reply)super.setPrettyPrint(bl);
            }

            public Reply setQuotaUser(String string) {
                return (Reply)super.setQuotaUser(string);
            }

            public Reply setUserIp(String string) {
                return (Reply)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Reply setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getReviewId() {
                return this.reviewId;
            }

            public Reply setReviewId(String string) {
                this.reviewId = string;
                return this;
            }

            @Override
            public Reply set(String string, Object object) {
                return (Reply)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends AndroidPublisherRequest<ReviewsListResponse> {
            private static final String REST_PATH = "{packageName}/reviews";
            @Key
            private String packageName;
            @Key
            private Long maxResults;
            @Key
            private Long startIndex;
            @Key
            private String token;
            @Key
            private String translationLanguage;

            protected List(String string) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, ReviewsListResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public List setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public Long getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(Long l) {
                this.startIndex = l;
                return this;
            }

            public String getToken() {
                return this.token;
            }

            public List setToken(String string) {
                this.token = string;
                return this;
            }

            public String getTranslationLanguage() {
                return this.translationLanguage;
            }

            public List setTranslationLanguage(String string) {
                this.translationLanguage = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends AndroidPublisherRequest<Review> {
            private static final String REST_PATH = "{packageName}/reviews/{reviewId}";
            @Key
            private String packageName;
            @Key
            private String reviewId;
            @Key
            private String translationLanguage;

            protected Get(String string, String string2) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, Review.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.reviewId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter reviewId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getReviewId() {
                return this.reviewId;
            }

            public Get setReviewId(String string) {
                this.reviewId = string;
                return this;
            }

            public String getTranslationLanguage() {
                return this.translationLanguage;
            }

            public Get setTranslationLanguage(String string) {
                this.translationLanguage = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Purchases {
        public Products products() {
            return new Products();
        }

        public Subscriptions subscriptions() {
            return new Subscriptions();
        }

        public Voidedpurchases voidedpurchases() {
            return new Voidedpurchases();
        }

        public class Voidedpurchases {
            public List list(String string) throws IOException {
                List list = new List(string);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AndroidPublisherRequest<VoidedPurchasesListResponse> {
                private static final String REST_PATH = "{packageName}/purchases/voidedpurchases";
                @Key
                private String packageName;
                @Key
                private Long endTime;
                @Key
                private Long maxResults;
                @Key
                private Long startIndex;
                @Key
                private Long startTime;
                @Key
                private String token;

                protected List(String string) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, VoidedPurchasesListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public Long getEndTime() {
                    return this.endTime;
                }

                public List setEndTime(Long l) {
                    this.endTime = l;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                public Long getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Long l) {
                    this.startIndex = l;
                    return this;
                }

                public Long getStartTime() {
                    return this.startTime;
                }

                public List setStartTime(Long l) {
                    this.startTime = l;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public List setToken(String string) {
                    this.token = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Subscriptions {
            public Cancel cancel(String string, String string2, String string3) throws IOException {
                Cancel cancel = new Cancel(string, string2, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)cancel);
                return cancel;
            }

            public Defer defer(String string, String string2, String string3, SubscriptionPurchasesDeferRequest subscriptionPurchasesDeferRequest) throws IOException {
                Defer defer = new Defer(string, string2, string3, subscriptionPurchasesDeferRequest);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)defer);
                return defer;
            }

            public Get get(String string, String string2, String string3) throws IOException {
                Get get = new Get(string, string2, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Refund refund(String string, String string2, String string3) throws IOException {
                Refund refund = new Refund(string, string2, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)refund);
                return refund;
            }

            public Revoke revoke(String string, String string2, String string3) throws IOException {
                Revoke revoke = new Revoke(string, string2, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)revoke);
                return revoke;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Revoke
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:revoke";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Revoke(String string, String string2, String string3) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter token must be specified.");
                }

                public Revoke setAlt(String string) {
                    return (Revoke)super.setAlt(string);
                }

                public Revoke setFields(String string) {
                    return (Revoke)super.setFields(string);
                }

                public Revoke setKey(String string) {
                    return (Revoke)super.setKey(string);
                }

                public Revoke setOauthToken(String string) {
                    return (Revoke)super.setOauthToken(string);
                }

                public Revoke setPrettyPrint(Boolean bl) {
                    return (Revoke)super.setPrettyPrint(bl);
                }

                public Revoke setQuotaUser(String string) {
                    return (Revoke)super.setQuotaUser(string);
                }

                public Revoke setUserIp(String string) {
                    return (Revoke)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Revoke setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Revoke setSubscriptionId(String string) {
                    this.subscriptionId = string;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Revoke setToken(String string) {
                    this.token = string;
                    return this;
                }

                @Override
                public Revoke set(String string, Object object) {
                    return (Revoke)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Refund
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:refund";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Refund(String string, String string2, String string3) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter token must be specified.");
                }

                public Refund setAlt(String string) {
                    return (Refund)super.setAlt(string);
                }

                public Refund setFields(String string) {
                    return (Refund)super.setFields(string);
                }

                public Refund setKey(String string) {
                    return (Refund)super.setKey(string);
                }

                public Refund setOauthToken(String string) {
                    return (Refund)super.setOauthToken(string);
                }

                public Refund setPrettyPrint(Boolean bl) {
                    return (Refund)super.setPrettyPrint(bl);
                }

                public Refund setQuotaUser(String string) {
                    return (Refund)super.setQuotaUser(string);
                }

                public Refund setUserIp(String string) {
                    return (Refund)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Refund setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Refund setSubscriptionId(String string) {
                    this.subscriptionId = string;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Refund setToken(String string) {
                    this.token = string;
                    return this;
                }

                @Override
                public Refund set(String string, Object object) {
                    return (Refund)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AndroidPublisherRequest<SubscriptionPurchase> {
                private static final String REST_PATH = "{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Get(String string, String string2, String string3) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, SubscriptionPurchase.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter token must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Get setSubscriptionId(String string) {
                    this.subscriptionId = string;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Get setToken(String string) {
                    this.token = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Defer
            extends AndroidPublisherRequest<SubscriptionPurchasesDeferResponse> {
                private static final String REST_PATH = "{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:defer";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Defer(String string, String string2, String string3, SubscriptionPurchasesDeferRequest subscriptionPurchasesDeferRequest) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)subscriptionPurchasesDeferRequest, SubscriptionPurchasesDeferResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter token must be specified.");
                }

                public Defer setAlt(String string) {
                    return (Defer)super.setAlt(string);
                }

                public Defer setFields(String string) {
                    return (Defer)super.setFields(string);
                }

                public Defer setKey(String string) {
                    return (Defer)super.setKey(string);
                }

                public Defer setOauthToken(String string) {
                    return (Defer)super.setOauthToken(string);
                }

                public Defer setPrettyPrint(Boolean bl) {
                    return (Defer)super.setPrettyPrint(bl);
                }

                public Defer setQuotaUser(String string) {
                    return (Defer)super.setQuotaUser(string);
                }

                public Defer setUserIp(String string) {
                    return (Defer)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Defer setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Defer setSubscriptionId(String string) {
                    this.subscriptionId = string;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Defer setToken(String string) {
                    this.token = string;
                    return this;
                }

                @Override
                public Defer set(String string, Object object) {
                    return (Defer)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Cancel
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:cancel";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Cancel(String string, String string2, String string3) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter token must be specified.");
                }

                public Cancel setAlt(String string) {
                    return (Cancel)super.setAlt(string);
                }

                public Cancel setFields(String string) {
                    return (Cancel)super.setFields(string);
                }

                public Cancel setKey(String string) {
                    return (Cancel)super.setKey(string);
                }

                public Cancel setOauthToken(String string) {
                    return (Cancel)super.setOauthToken(string);
                }

                public Cancel setPrettyPrint(Boolean bl) {
                    return (Cancel)super.setPrettyPrint(bl);
                }

                public Cancel setQuotaUser(String string) {
                    return (Cancel)super.setQuotaUser(string);
                }

                public Cancel setUserIp(String string) {
                    return (Cancel)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Cancel setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Cancel setSubscriptionId(String string) {
                    this.subscriptionId = string;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Cancel setToken(String string) {
                    this.token = string;
                    return this;
                }

                @Override
                public Cancel set(String string, Object object) {
                    return (Cancel)super.set(string, object);
                }
            }
        }

        public class Products {
            public Get get(String string, String string2, String string3) throws IOException {
                Get get = new Get(string, string2, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AndroidPublisherRequest<ProductPurchase> {
                private static final String REST_PATH = "{packageName}/purchases/products/{productId}/tokens/{token}";
                @Key
                private String packageName;
                @Key
                private String productId;
                @Key
                private String token;

                protected Get(String string, String string2, String string3) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ProductPurchase.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.productId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter productId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter token must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public Get setProductId(String string) {
                    this.productId = string;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Get setToken(String string) {
                    this.token = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }
    }

    public class Orders {
        public Refund refund(String string, String string2) throws IOException {
            Refund refund = new Refund(string, string2);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)refund);
            return refund;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Refund
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "{packageName}/orders/{orderId}:refund";
            @Key
            private String packageName;
            @Key
            private String orderId;
            @Key
            private Boolean revoke;

            protected Refund(String string, String string2) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter orderId must be specified.");
            }

            public Refund setAlt(String string) {
                return (Refund)super.setAlt(string);
            }

            public Refund setFields(String string) {
                return (Refund)super.setFields(string);
            }

            public Refund setKey(String string) {
                return (Refund)super.setKey(string);
            }

            public Refund setOauthToken(String string) {
                return (Refund)super.setOauthToken(string);
            }

            public Refund setPrettyPrint(Boolean bl) {
                return (Refund)super.setPrettyPrint(bl);
            }

            public Refund setQuotaUser(String string) {
                return (Refund)super.setQuotaUser(string);
            }

            public Refund setUserIp(String string) {
                return (Refund)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Refund setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Refund setOrderId(String string) {
                this.orderId = string;
                return this;
            }

            public Boolean getRevoke() {
                return this.revoke;
            }

            public Refund setRevoke(Boolean bl) {
                this.revoke = bl;
                return this;
            }

            @Override
            public Refund set(String string, Object object) {
                return (Refund)super.set(string, object);
            }
        }
    }

    public class Inappproducts {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, InAppProduct inAppProduct) throws IOException {
            Insert insert = new Insert(string, inAppProduct);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, InAppProduct inAppProduct) throws IOException {
            Patch patch = new Patch(string, string2, inAppProduct);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, InAppProduct inAppProduct) throws IOException {
            Update update = new Update(string, string2, inAppProduct);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;
            @Key
            private Boolean autoConvertMissingPrices;

            protected Update(String string, String string2, InAppProduct inAppProduct) {
                super(AndroidPublisher.this, "PUT", REST_PATH, (Object)inAppProduct, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sku must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Update setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Update setSku(String string) {
                this.sku = string;
                return this;
            }

            public Boolean getAutoConvertMissingPrices() {
                return this.autoConvertMissingPrices;
            }

            public Update setAutoConvertMissingPrices(Boolean bl) {
                this.autoConvertMissingPrices = bl;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;
            @Key
            private Boolean autoConvertMissingPrices;

            protected Patch(String string, String string2, InAppProduct inAppProduct) {
                super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)inAppProduct, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sku must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Patch setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Patch setSku(String string) {
                this.sku = string;
                return this;
            }

            public Boolean getAutoConvertMissingPrices() {
                return this.autoConvertMissingPrices;
            }

            public Patch setAutoConvertMissingPrices(Boolean bl) {
                this.autoConvertMissingPrices = bl;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends AndroidPublisherRequest<InappproductsListResponse> {
            private static final String REST_PATH = "{packageName}/inappproducts";
            @Key
            private String packageName;
            @Key
            private Long maxResults;
            @Key
            private Long startIndex;
            @Key
            private String token;

            protected List(String string) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, InappproductsListResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public List setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public Long getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(Long l) {
                this.startIndex = l;
                return this;
            }

            public String getToken() {
                return this.token;
            }

            public List setToken(String string) {
                this.token = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "{packageName}/inappproducts";
            @Key
            private String packageName;
            @Key
            private Boolean autoConvertMissingPrices;

            protected Insert(String string, InAppProduct inAppProduct) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)inAppProduct, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Insert setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public Boolean getAutoConvertMissingPrices() {
                return this.autoConvertMissingPrices;
            }

            public Insert setAutoConvertMissingPrices(Boolean bl) {
                this.autoConvertMissingPrices = bl;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;

            protected Get(String string, String string2) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sku must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Get setSku(String string) {
                this.sku = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;

            protected Delete(String string, String string2) {
                super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sku must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Delete setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Delete setSku(String string) {
                this.sku = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Edits {
        public Commit commit(String string, String string2) throws IOException {
            Commit commit = new Commit(string, string2);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)commit);
            return commit;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, AppEdit appEdit) throws IOException {
            Insert insert = new Insert(string, appEdit);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Validate validate(String string, String string2) throws IOException {
            Validate validate = new Validate(string, string2);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)validate);
            return validate;
        }

        public Apklistings apklistings() {
            return new Apklistings();
        }

        public Apks apks() {
            return new Apks();
        }

        public Bundles bundles() {
            return new Bundles();
        }

        public Deobfuscationfiles deobfuscationfiles() {
            return new Deobfuscationfiles();
        }

        public Details details() {
            return new Details();
        }

        public Expansionfiles expansionfiles() {
            return new Expansionfiles();
        }

        public Images images() {
            return new Images();
        }

        public Listings listings() {
            return new Listings();
        }

        public Testers testers() {
            return new Testers();
        }

        public Tracks tracks() {
            return new Tracks();
        }

        public class Tracks {
            public Get get(String string, String string2, String string3) throws IOException {
                Get get = new Get(string, string2, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, String string3, Track track) throws IOException {
                Patch patch = new Patch(string, string2, string3, track);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, Track track) throws IOException {
                Update update = new Update(string, string2, string3, track);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AndroidPublisherRequest<Track> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/tracks/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Update(String string, String string2, String string3, Track track) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)track, Track.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter track must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Update setTrack(String string) {
                    this.track = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AndroidPublisherRequest<Track> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/tracks/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Patch(String string, String string2, String string3, Track track) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)track, Track.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter track must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Patch setTrack(String string) {
                    this.track = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AndroidPublisherRequest<TracksListResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/tracks";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String string, String string2) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, TracksListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AndroidPublisherRequest<Track> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/tracks/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Get(String string, String string2, String string3) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, Track.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter track must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Get setTrack(String string) {
                    this.track = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Testers {
            public Get get(String string, String string2, String string3) throws IOException {
                Get get = new Get(string, string2, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Patch patch(String string, String string2, String string3, com.google.api.services.androidpublisher.model.Testers testers) throws IOException {
                Patch patch = new Patch(string, string2, string3, testers);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, com.google.api.services.androidpublisher.model.Testers testers) throws IOException {
                Update update = new Update(string, string2, string3, testers);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/testers/{track}";
                private final Pattern TRACK_PATTERN;
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Update(String string, String string2, String string3, com.google.api.services.androidpublisher.model.Testers testers2) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)testers2, com.google.api.services.androidpublisher.model.Testers.class);
                    this.TRACK_PATTERN = Pattern.compile("(alpha|beta|production|rollout|internal)");
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter track must be specified.");
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(string3).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Update setTrack(String string) {
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(string).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                    this.track = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/testers/{track}";
                private final Pattern TRACK_PATTERN;
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Patch(String string, String string2, String string3, com.google.api.services.androidpublisher.model.Testers testers2) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)testers2, com.google.api.services.androidpublisher.model.Testers.class);
                    this.TRACK_PATTERN = Pattern.compile("(alpha|beta|production|rollout|internal)");
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter track must be specified.");
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(string3).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Patch setTrack(String string) {
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(string).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                    this.track = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/testers/{track}";
                private final Pattern TRACK_PATTERN;
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Get(String string, String string2, String string3) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.Testers.class);
                    this.TRACK_PATTERN = Pattern.compile("(alpha|beta|production|rollout|internal)");
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter track must be specified.");
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(string3).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Get setTrack(String string) {
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(string).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                    this.track = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Listings {
            public Delete delete(String string, String string2, String string3) throws IOException {
                Delete delete = new Delete(string, string2, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Deleteall deleteall(String string, String string2) throws IOException {
                Deleteall deleteall = new Deleteall(string, string2);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)deleteall);
                return deleteall;
            }

            public Get get(String string, String string2, String string3) throws IOException {
                Get get = new Get(string, string2, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, String string3, Listing listing) throws IOException {
                Patch patch = new Patch(string, string2, string3, listing);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, Listing listing) throws IOException {
                Update update = new Update(string, string2, string3, listing);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AndroidPublisherRequest<Listing> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Update(String string, String string2, String string3, Listing listing) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)listing, Listing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Update setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AndroidPublisherRequest<Listing> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Patch(String string, String string2, String string3, Listing listing) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)listing, Listing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Patch setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AndroidPublisherRequest<ListingsListResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String string, String string2) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ListingsListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AndroidPublisherRequest<Listing> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Get(String string, String string2, String string3) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, Listing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Get setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Deleteall
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Deleteall(String string, String string2) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                }

                public Deleteall setAlt(String string) {
                    return (Deleteall)super.setAlt(string);
                }

                public Deleteall setFields(String string) {
                    return (Deleteall)super.setFields(string);
                }

                public Deleteall setKey(String string) {
                    return (Deleteall)super.setKey(string);
                }

                public Deleteall setOauthToken(String string) {
                    return (Deleteall)super.setOauthToken(string);
                }

                public Deleteall setPrettyPrint(Boolean bl) {
                    return (Deleteall)super.setPrettyPrint(bl);
                }

                public Deleteall setQuotaUser(String string) {
                    return (Deleteall)super.setQuotaUser(string);
                }

                public Deleteall setUserIp(String string) {
                    return (Deleteall)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Deleteall setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Deleteall setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                @Override
                public Deleteall set(String string, Object object) {
                    return (Deleteall)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Delete(String string, String string2, String string3) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Delete setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Delete setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Delete setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Images {
            public Delete delete(String string, String string2, String string3, String string4, String string5) throws IOException {
                Delete delete = new Delete(string, string2, string3, string4, string5);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Deleteall deleteall(String string, String string2, String string3, String string4) throws IOException {
                Deleteall deleteall = new Deleteall(string, string2, string3, string4);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)deleteall);
                return deleteall;
            }

            public List list(String string, String string2, String string3, String string4) throws IOException {
                List list = new List(string, string2, string3, string4);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Upload upload(String string, String string2, String string3, String string4) throws IOException {
                Upload upload = new Upload(string, string2, string3, string4);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            public Upload upload(String string, String string2, String string3, String string4, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Upload upload = new Upload(string, string2, string3, string4, abstractInputStreamContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Upload
            extends AndroidPublisherRequest<ImagesUploadResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}/{imageType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;

                protected Upload(String string, String string2, String string3, String string4) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, ImagesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter imageType must be specified.");
                }

                protected Upload(String string, String string2, String string3, String string4, AbstractInputStreamContent abstractInputStreamContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, ImagesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter imageType must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Upload setAlt(String string) {
                    return (Upload)super.setAlt(string);
                }

                public Upload setFields(String string) {
                    return (Upload)super.setFields(string);
                }

                public Upload setKey(String string) {
                    return (Upload)super.setKey(string);
                }

                public Upload setOauthToken(String string) {
                    return (Upload)super.setOauthToken(string);
                }

                public Upload setPrettyPrint(Boolean bl) {
                    return (Upload)super.setPrettyPrint(bl);
                }

                public Upload setQuotaUser(String string) {
                    return (Upload)super.setQuotaUser(string);
                }

                public Upload setUserIp(String string) {
                    return (Upload)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Upload setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public Upload setImageType(String string) {
                    this.imageType = string;
                    return this;
                }

                @Override
                public Upload set(String string, Object object) {
                    return (Upload)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AndroidPublisherRequest<ImagesListResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}/{imageType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;

                protected List(String string, String string2, String string3, String string4) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ImagesListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter imageType must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public List setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public List setImageType(String string) {
                    this.imageType = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Deleteall
            extends AndroidPublisherRequest<ImagesDeleteAllResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}/{imageType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;

                protected Deleteall(String string, String string2, String string3, String string4) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, ImagesDeleteAllResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter imageType must be specified.");
                }

                public Deleteall setAlt(String string) {
                    return (Deleteall)super.setAlt(string);
                }

                public Deleteall setFields(String string) {
                    return (Deleteall)super.setFields(string);
                }

                public Deleteall setKey(String string) {
                    return (Deleteall)super.setKey(string);
                }

                public Deleteall setOauthToken(String string) {
                    return (Deleteall)super.setOauthToken(string);
                }

                public Deleteall setPrettyPrint(Boolean bl) {
                    return (Deleteall)super.setPrettyPrint(bl);
                }

                public Deleteall setQuotaUser(String string) {
                    return (Deleteall)super.setQuotaUser(string);
                }

                public Deleteall setUserIp(String string) {
                    return (Deleteall)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Deleteall setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Deleteall setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Deleteall setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public Deleteall setImageType(String string) {
                    this.imageType = string;
                    return this;
                }

                @Override
                public Deleteall set(String string, Object object) {
                    return (Deleteall)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}/{imageType}/{imageId}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;
                @Key
                private String imageId;

                protected Delete(String string, String string2, String string3, String string4, String string5) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter imageType must be specified.");
                    this.imageId = (String)Preconditions.checkNotNull((Object)string5, (Object)"Required parameter imageId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Delete setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Delete setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Delete setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public Delete setImageType(String string) {
                    this.imageType = string;
                    return this;
                }

                public String getImageId() {
                    return this.imageId;
                }

                public Delete setImageId(String string) {
                    this.imageId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Expansionfiles {
            public Get get(String string, String string2, Integer n, String string3) throws IOException {
                Get get = new Get(string, string2, n, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Patch patch(String string, String string2, Integer n, String string3, ExpansionFile expansionFile) throws IOException {
                Patch patch = new Patch(string, string2, n, string3, expansionFile);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, Integer n, String string3, ExpansionFile expansionFile) throws IOException {
                Update update = new Update(string, string2, n, string3, expansionFile);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            public Upload upload(String string, String string2, Integer n, String string3) throws IOException {
                Upload upload = new Upload(string, string2, n, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            public Upload upload(String string, String string2, Integer n, String string3, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Upload upload = new Upload(string, string2, n, string3, abstractInputStreamContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Upload
            extends AndroidPublisherRequest<ExpansionFilesUploadResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Upload(String string, String string2, Integer n, String string3) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, ExpansionFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter expansionFileType must be specified.");
                }

                protected Upload(String string, String string2, Integer n, String string3, AbstractInputStreamContent abstractInputStreamContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, ExpansionFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter expansionFileType must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Upload setAlt(String string) {
                    return (Upload)super.setAlt(string);
                }

                public Upload setFields(String string) {
                    return (Upload)super.setFields(string);
                }

                public Upload setKey(String string) {
                    return (Upload)super.setKey(string);
                }

                public Upload setOauthToken(String string) {
                    return (Upload)super.setOauthToken(string);
                }

                public Upload setPrettyPrint(Boolean bl) {
                    return (Upload)super.setPrettyPrint(bl);
                }

                public Upload setQuotaUser(String string) {
                    return (Upload)super.setQuotaUser(string);
                }

                public Upload setUserIp(String string) {
                    return (Upload)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Upload setApkVersionCode(Integer n) {
                    this.apkVersionCode = n;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Upload setExpansionFileType(String string) {
                    this.expansionFileType = string;
                    return this;
                }

                @Override
                public Upload set(String string, Object object) {
                    return (Upload)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AndroidPublisherRequest<ExpansionFile> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Update(String string, String string2, Integer n, String string3, ExpansionFile expansionFile) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)expansionFile, ExpansionFile.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter expansionFileType must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Update setApkVersionCode(Integer n) {
                    this.apkVersionCode = n;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Update setExpansionFileType(String string) {
                    this.expansionFileType = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AndroidPublisherRequest<ExpansionFile> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Patch(String string, String string2, Integer n, String string3, ExpansionFile expansionFile) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)expansionFile, ExpansionFile.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter expansionFileType must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Patch setApkVersionCode(Integer n) {
                    this.apkVersionCode = n;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Patch setExpansionFileType(String string) {
                    this.expansionFileType = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AndroidPublisherRequest<ExpansionFile> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Get(String string, String string2, Integer n, String string3) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ExpansionFile.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter expansionFileType must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Get setApkVersionCode(Integer n) {
                    this.apkVersionCode = n;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Get setExpansionFileType(String string) {
                    this.expansionFileType = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Details {
            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Patch patch(String string, String string2, AppDetails appDetails) throws IOException {
                Patch patch = new Patch(string, string2, appDetails);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, AppDetails appDetails) throws IOException {
                Update update = new Update(string, string2, appDetails);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AndroidPublisherRequest<AppDetails> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/details";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Update(String string, String string2, AppDetails appDetails) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)appDetails, AppDetails.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AndroidPublisherRequest<AppDetails> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/details";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Patch(String string, String string2, AppDetails appDetails) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)appDetails, AppDetails.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AndroidPublisherRequest<AppDetails> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/details";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Get(String string, String string2) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, AppDetails.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Deobfuscationfiles {
            public Upload upload(String string, String string2, Integer n, String string3) throws IOException {
                Upload upload = new Upload(string, string2, n, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            public Upload upload(String string, String string2, Integer n, String string3, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Upload upload = new Upload(string, string2, n, string3, abstractInputStreamContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Upload
            extends AndroidPublisherRequest<DeobfuscationFilesUploadResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/deobfuscationFiles/{deobfuscationFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String deobfuscationFileType;

                protected Upload(String string, String string2, Integer n, String string3) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, DeobfuscationFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                    this.deobfuscationFileType = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter deobfuscationFileType must be specified.");
                }

                protected Upload(String string, String string2, Integer n, String string3, AbstractInputStreamContent abstractInputStreamContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, DeobfuscationFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                    this.deobfuscationFileType = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter deobfuscationFileType must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Upload setAlt(String string) {
                    return (Upload)super.setAlt(string);
                }

                public Upload setFields(String string) {
                    return (Upload)super.setFields(string);
                }

                public Upload setKey(String string) {
                    return (Upload)super.setKey(string);
                }

                public Upload setOauthToken(String string) {
                    return (Upload)super.setOauthToken(string);
                }

                public Upload setPrettyPrint(Boolean bl) {
                    return (Upload)super.setPrettyPrint(bl);
                }

                public Upload setQuotaUser(String string) {
                    return (Upload)super.setQuotaUser(string);
                }

                public Upload setUserIp(String string) {
                    return (Upload)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Upload setApkVersionCode(Integer n) {
                    this.apkVersionCode = n;
                    return this;
                }

                public String getDeobfuscationFileType() {
                    return this.deobfuscationFileType;
                }

                public Upload setDeobfuscationFileType(String string) {
                    this.deobfuscationFileType = string;
                    return this;
                }

                @Override
                public Upload set(String string, Object object) {
                    return (Upload)super.set(string, object);
                }
            }
        }

        public class Bundles {
            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Upload upload(String string, String string2) throws IOException {
                Upload upload = new Upload(string, string2);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            public Upload upload(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Upload upload = new Upload(string, string2, abstractInputStreamContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Upload
            extends AndroidPublisherRequest<Bundle> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/bundles";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Upload(String string, String string2) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Bundle.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                }

                protected Upload(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, Bundle.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Upload setAlt(String string) {
                    return (Upload)super.setAlt(string);
                }

                public Upload setFields(String string) {
                    return (Upload)super.setFields(string);
                }

                public Upload setKey(String string) {
                    return (Upload)super.setKey(string);
                }

                public Upload setOauthToken(String string) {
                    return (Upload)super.setOauthToken(string);
                }

                public Upload setPrettyPrint(Boolean bl) {
                    return (Upload)super.setPrettyPrint(bl);
                }

                public Upload setQuotaUser(String string) {
                    return (Upload)super.setQuotaUser(string);
                }

                public Upload setUserIp(String string) {
                    return (Upload)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                @Override
                public Upload set(String string, Object object) {
                    return (Upload)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AndroidPublisherRequest<BundlesListResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/bundles";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String string, String string2) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, BundlesListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Apks {
            public Addexternallyhosted addexternallyhosted(String string, String string2, ApksAddExternallyHostedRequest apksAddExternallyHostedRequest) throws IOException {
                Addexternallyhosted addexternallyhosted = new Addexternallyhosted(string, string2, apksAddExternallyHostedRequest);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)addexternallyhosted);
                return addexternallyhosted;
            }

            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Upload upload(String string, String string2) throws IOException {
                Upload upload = new Upload(string, string2);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            public Upload upload(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Upload upload = new Upload(string, string2, abstractInputStreamContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Upload
            extends AndroidPublisherRequest<Apk> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Upload(String string, String string2) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Apk.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                }

                protected Upload(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, Apk.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Upload setAlt(String string) {
                    return (Upload)super.setAlt(string);
                }

                public Upload setFields(String string) {
                    return (Upload)super.setFields(string);
                }

                public Upload setKey(String string) {
                    return (Upload)super.setKey(string);
                }

                public Upload setOauthToken(String string) {
                    return (Upload)super.setOauthToken(string);
                }

                public Upload setPrettyPrint(Boolean bl) {
                    return (Upload)super.setPrettyPrint(bl);
                }

                public Upload setQuotaUser(String string) {
                    return (Upload)super.setQuotaUser(string);
                }

                public Upload setUserIp(String string) {
                    return (Upload)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                @Override
                public Upload set(String string, Object object) {
                    return (Upload)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AndroidPublisherRequest<ApksListResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String string, String string2) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ApksListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Addexternallyhosted
            extends AndroidPublisherRequest<ApksAddExternallyHostedResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/externallyHosted";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Addexternallyhosted(String string, String string2, ApksAddExternallyHostedRequest apksAddExternallyHostedRequest) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)apksAddExternallyHostedRequest, ApksAddExternallyHostedResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                }

                public Addexternallyhosted setAlt(String string) {
                    return (Addexternallyhosted)super.setAlt(string);
                }

                public Addexternallyhosted setFields(String string) {
                    return (Addexternallyhosted)super.setFields(string);
                }

                public Addexternallyhosted setKey(String string) {
                    return (Addexternallyhosted)super.setKey(string);
                }

                public Addexternallyhosted setOauthToken(String string) {
                    return (Addexternallyhosted)super.setOauthToken(string);
                }

                public Addexternallyhosted setPrettyPrint(Boolean bl) {
                    return (Addexternallyhosted)super.setPrettyPrint(bl);
                }

                public Addexternallyhosted setQuotaUser(String string) {
                    return (Addexternallyhosted)super.setQuotaUser(string);
                }

                public Addexternallyhosted setUserIp(String string) {
                    return (Addexternallyhosted)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Addexternallyhosted setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Addexternallyhosted setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                @Override
                public Addexternallyhosted set(String string, Object object) {
                    return (Addexternallyhosted)super.set(string, object);
                }
            }
        }

        public class Apklistings {
            public Delete delete(String string, String string2, Integer n, String string3) throws IOException {
                Delete delete = new Delete(string, string2, n, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Deleteall deleteall(String string, String string2, Integer n) throws IOException {
                Deleteall deleteall = new Deleteall(string, string2, n);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)deleteall);
                return deleteall;
            }

            public Get get(String string, String string2, Integer n, String string3) throws IOException {
                Get get = new Get(string, string2, n, string3);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string, String string2, Integer n) throws IOException {
                List list = new List(string, string2, n);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, Integer n, String string3, ApkListing apkListing) throws IOException {
                Patch patch = new Patch(string, string2, n, string3, apkListing);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, Integer n, String string3, ApkListing apkListing) throws IOException {
                Update update = new Update(string, string2, n, string3, apkListing);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AndroidPublisherRequest<ApkListing> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String language;

                protected Update(String string, String string2, Integer n, String string3, ApkListing apkListing) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)apkListing, ApkListing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Update setApkVersionCode(Integer n) {
                    this.apkVersionCode = n;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Update setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AndroidPublisherRequest<ApkListing> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String language;

                protected Patch(String string, String string2, Integer n, String string3, ApkListing apkListing) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)apkListing, ApkListing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Patch setApkVersionCode(Integer n) {
                    this.apkVersionCode = n;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Patch setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AndroidPublisherRequest<ApkListingsListResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/listings";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;

                protected List(String string, String string2, Integer n) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ApkListingsListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public List setApkVersionCode(Integer n) {
                    this.apkVersionCode = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AndroidPublisherRequest<ApkListing> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String language;

                protected Get(String string, String string2, Integer n, String string3) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ApkListing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Get setApkVersionCode(Integer n) {
                    this.apkVersionCode = n;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Get setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Deleteall
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/listings";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;

                protected Deleteall(String string, String string2, Integer n) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                }

                public Deleteall setAlt(String string) {
                    return (Deleteall)super.setAlt(string);
                }

                public Deleteall setFields(String string) {
                    return (Deleteall)super.setFields(string);
                }

                public Deleteall setKey(String string) {
                    return (Deleteall)super.setKey(string);
                }

                public Deleteall setOauthToken(String string) {
                    return (Deleteall)super.setOauthToken(string);
                }

                public Deleteall setPrettyPrint(Boolean bl) {
                    return (Deleteall)super.setPrettyPrint(bl);
                }

                public Deleteall setQuotaUser(String string) {
                    return (Deleteall)super.setQuotaUser(string);
                }

                public Deleteall setUserIp(String string) {
                    return (Deleteall)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Deleteall setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Deleteall setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Deleteall setApkVersionCode(Integer n) {
                    this.apkVersionCode = n;
                    return this;
                }

                @Override
                public Deleteall set(String string, Object object) {
                    return (Deleteall)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String language;

                protected Delete(String string, String string2, Integer n, String string3) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter apkVersionCode must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter language must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Delete setPackageName(String string) {
                    this.packageName = string;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Delete setEditId(String string) {
                    this.editId = string;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Delete setApkVersionCode(Integer n) {
                    this.apkVersionCode = n;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Delete setLanguage(String string) {
                    this.language = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Validate
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "{packageName}/edits/{editId}:validate";
            @Key
            private String packageName;
            @Key
            private String editId;

            protected Validate(String string, String string2) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
            }

            public Validate setAlt(String string) {
                return (Validate)super.setAlt(string);
            }

            public Validate setFields(String string) {
                return (Validate)super.setFields(string);
            }

            public Validate setKey(String string) {
                return (Validate)super.setKey(string);
            }

            public Validate setOauthToken(String string) {
                return (Validate)super.setOauthToken(string);
            }

            public Validate setPrettyPrint(Boolean bl) {
                return (Validate)super.setPrettyPrint(bl);
            }

            public Validate setQuotaUser(String string) {
                return (Validate)super.setQuotaUser(string);
            }

            public Validate setUserIp(String string) {
                return (Validate)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Validate setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Validate setEditId(String string) {
                this.editId = string;
                return this;
            }

            @Override
            public Validate set(String string, Object object) {
                return (Validate)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "{packageName}/edits";
            @Key
            private String packageName;

            protected Insert(String string, AppEdit appEdit) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)appEdit, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Insert setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "{packageName}/edits/{editId}";
            @Key
            private String packageName;
            @Key
            private String editId;

            protected Get(String string, String string2) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Get setEditId(String string) {
                this.editId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "{packageName}/edits/{editId}";
            @Key
            private String packageName;
            @Key
            private String editId;

            protected Delete(String string, String string2) {
                super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Delete setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Delete setEditId(String string) {
                this.editId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Commit
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "{packageName}/edits/{editId}:commit";
            @Key
            private String packageName;
            @Key
            private String editId;

            protected Commit(String string, String string2) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter editId must be specified.");
            }

            public Commit setAlt(String string) {
                return (Commit)super.setAlt(string);
            }

            public Commit setFields(String string) {
                return (Commit)super.setFields(string);
            }

            public Commit setKey(String string) {
                return (Commit)super.setKey(string);
            }

            public Commit setOauthToken(String string) {
                return (Commit)super.setOauthToken(string);
            }

            public Commit setPrettyPrint(Boolean bl) {
                return (Commit)super.setPrettyPrint(bl);
            }

            public Commit setQuotaUser(String string) {
                return (Commit)super.setQuotaUser(string);
            }

            public Commit setUserIp(String string) {
                return (Commit)super.setUserIp(string);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Commit setPackageName(String string) {
                this.packageName = string;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Commit setEditId(String string) {
                this.editId = string;
                return this;
            }

            @Override
            public Commit set(String string, Object object) {
                return (Commit)super.set(string, object);
            }
        }
    }
}

