/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-22 at 04:12:34 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A VoidedPurchase resource indicates a purchase that was either canceled/refunded/charged-back.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VoidedPurchase extends com.google.api.client.json.GenericJson {

  /**
   * This kind represents a voided purchase object in the androidpublisher service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The order id which uniquely identifies a one-time purchase, subscription purchase, or
   * subscription renewal.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String orderId;

  /**
   * The time at which the purchase was made, in milliseconds since the epoch (Jan 1, 1970).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long purchaseTimeMillis;

  /**
   * The token which uniquely identifies a one-time purchase or subscription. To uniquely identify
   * subscription renewals use order_id (available starting from version 3 of the API).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String purchaseToken;

  /**
   * The reason why the purchase was voided, possible values are: - Other  - Remorse  - Not_received
   * - Defective  - Accidental_purchase  - Fraud  - Friendly_fraud  - Chargeback
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer voidedReason;

  /**
   * The initiator of voided purchase, possible values are: - User  - Developer  - Google
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer voidedSource;

  /**
   * The time at which the purchase was canceled/refunded/charged-back, in milliseconds since the
   * epoch (Jan 1, 1970).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long voidedTimeMillis;

  /**
   * This kind represents a voided purchase object in the androidpublisher service.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This kind represents a voided purchase object in the androidpublisher service.
   * @param kind kind or {@code null} for none
   */
  public VoidedPurchase setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The order id which uniquely identifies a one-time purchase, subscription purchase, or
   * subscription renewal.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrderId() {
    return orderId;
  }

  /**
   * The order id which uniquely identifies a one-time purchase, subscription purchase, or
   * subscription renewal.
   * @param orderId orderId or {@code null} for none
   */
  public VoidedPurchase setOrderId(java.lang.String orderId) {
    this.orderId = orderId;
    return this;
  }

  /**
   * The time at which the purchase was made, in milliseconds since the epoch (Jan 1, 1970).
   * @return value or {@code null} for none
   */
  public java.lang.Long getPurchaseTimeMillis() {
    return purchaseTimeMillis;
  }

  /**
   * The time at which the purchase was made, in milliseconds since the epoch (Jan 1, 1970).
   * @param purchaseTimeMillis purchaseTimeMillis or {@code null} for none
   */
  public VoidedPurchase setPurchaseTimeMillis(java.lang.Long purchaseTimeMillis) {
    this.purchaseTimeMillis = purchaseTimeMillis;
    return this;
  }

  /**
   * The token which uniquely identifies a one-time purchase or subscription. To uniquely identify
   * subscription renewals use order_id (available starting from version 3 of the API).
   * @return value or {@code null} for none
   */
  public java.lang.String getPurchaseToken() {
    return purchaseToken;
  }

  /**
   * The token which uniquely identifies a one-time purchase or subscription. To uniquely identify
   * subscription renewals use order_id (available starting from version 3 of the API).
   * @param purchaseToken purchaseToken or {@code null} for none
   */
  public VoidedPurchase setPurchaseToken(java.lang.String purchaseToken) {
    this.purchaseToken = purchaseToken;
    return this;
  }

  /**
   * The reason why the purchase was voided, possible values are: - Other  - Remorse  - Not_received
   * - Defective  - Accidental_purchase  - Fraud  - Friendly_fraud  - Chargeback
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVoidedReason() {
    return voidedReason;
  }

  /**
   * The reason why the purchase was voided, possible values are: - Other  - Remorse  - Not_received
   * - Defective  - Accidental_purchase  - Fraud  - Friendly_fraud  - Chargeback
   * @param voidedReason voidedReason or {@code null} for none
   */
  public VoidedPurchase setVoidedReason(java.lang.Integer voidedReason) {
    this.voidedReason = voidedReason;
    return this;
  }

  /**
   * The initiator of voided purchase, possible values are: - User  - Developer  - Google
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVoidedSource() {
    return voidedSource;
  }

  /**
   * The initiator of voided purchase, possible values are: - User  - Developer  - Google
   * @param voidedSource voidedSource or {@code null} for none
   */
  public VoidedPurchase setVoidedSource(java.lang.Integer voidedSource) {
    this.voidedSource = voidedSource;
    return this;
  }

  /**
   * The time at which the purchase was canceled/refunded/charged-back, in milliseconds since the
   * epoch (Jan 1, 1970).
   * @return value or {@code null} for none
   */
  public java.lang.Long getVoidedTimeMillis() {
    return voidedTimeMillis;
  }

  /**
   * The time at which the purchase was canceled/refunded/charged-back, in milliseconds since the
   * epoch (Jan 1, 1970).
   * @param voidedTimeMillis voidedTimeMillis or {@code null} for none
   */
  public VoidedPurchase setVoidedTimeMillis(java.lang.Long voidedTimeMillis) {
    this.voidedTimeMillis = voidedTimeMillis;
    return this;
  }

  @Override
  public VoidedPurchase set(String fieldName, Object value) {
    return (VoidedPurchase) super.set(fieldName, value);
  }

  @Override
  public VoidedPurchase clone() {
    return (VoidedPurchase) super.clone();
  }

}
