/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-12 at 04:11:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Contains the introductory price information for a subscription.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IntroductoryPriceInfo extends com.google.api.client.json.GenericJson {

  /**
   * Introductory price of the subscription, not including tax. The currency is the same as
   * price_currency_code. Price is expressed in micro-units, where 1,000,000 micro-units represents
   * one unit of the currency. For example, if the subscription price is €1.99, price_amount_micros
   * is 1990000.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long introductoryPriceAmountMicros;

  /**
   * ISO 4217 currency code for the introductory subscription price. For example, if the price is
   * specified in British pounds sterling, price_currency_code is "GBP".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String introductoryPriceCurrencyCode;

  /**
   * The number of billing period to offer introductory pricing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer introductoryPriceCycles;

  /**
   * Introductory price period, specified in ISO 8601 format. Common values are (but not limited to)
   * "P1W" (one week), "P1M" (one month), "P3M" (three months), "P6M" (six months), and "P1Y" (one
   * year).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String introductoryPricePeriod;

  /**
   * Introductory price of the subscription, not including tax. The currency is the same as
   * price_currency_code. Price is expressed in micro-units, where 1,000,000 micro-units represents
   * one unit of the currency. For example, if the subscription price is €1.99, price_amount_micros
   * is 1990000.
   * @return value or {@code null} for none
   */
  public java.lang.Long getIntroductoryPriceAmountMicros() {
    return introductoryPriceAmountMicros;
  }

  /**
   * Introductory price of the subscription, not including tax. The currency is the same as
   * price_currency_code. Price is expressed in micro-units, where 1,000,000 micro-units represents
   * one unit of the currency. For example, if the subscription price is €1.99, price_amount_micros
   * is 1990000.
   * @param introductoryPriceAmountMicros introductoryPriceAmountMicros or {@code null} for none
   */
  public IntroductoryPriceInfo setIntroductoryPriceAmountMicros(java.lang.Long introductoryPriceAmountMicros) {
    this.introductoryPriceAmountMicros = introductoryPriceAmountMicros;
    return this;
  }

  /**
   * ISO 4217 currency code for the introductory subscription price. For example, if the price is
   * specified in British pounds sterling, price_currency_code is "GBP".
   * @return value or {@code null} for none
   */
  public java.lang.String getIntroductoryPriceCurrencyCode() {
    return introductoryPriceCurrencyCode;
  }

  /**
   * ISO 4217 currency code for the introductory subscription price. For example, if the price is
   * specified in British pounds sterling, price_currency_code is "GBP".
   * @param introductoryPriceCurrencyCode introductoryPriceCurrencyCode or {@code null} for none
   */
  public IntroductoryPriceInfo setIntroductoryPriceCurrencyCode(java.lang.String introductoryPriceCurrencyCode) {
    this.introductoryPriceCurrencyCode = introductoryPriceCurrencyCode;
    return this;
  }

  /**
   * The number of billing period to offer introductory pricing.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIntroductoryPriceCycles() {
    return introductoryPriceCycles;
  }

  /**
   * The number of billing period to offer introductory pricing.
   * @param introductoryPriceCycles introductoryPriceCycles or {@code null} for none
   */
  public IntroductoryPriceInfo setIntroductoryPriceCycles(java.lang.Integer introductoryPriceCycles) {
    this.introductoryPriceCycles = introductoryPriceCycles;
    return this;
  }

  /**
   * Introductory price period, specified in ISO 8601 format. Common values are (but not limited to)
   * "P1W" (one week), "P1M" (one month), "P3M" (three months), "P6M" (six months), and "P1Y" (one
   * year).
   * @return value or {@code null} for none
   */
  public java.lang.String getIntroductoryPricePeriod() {
    return introductoryPricePeriod;
  }

  /**
   * Introductory price period, specified in ISO 8601 format. Common values are (but not limited to)
   * "P1W" (one week), "P1M" (one month), "P3M" (three months), "P6M" (six months), and "P1Y" (one
   * year).
   * @param introductoryPricePeriod introductoryPricePeriod or {@code null} for none
   */
  public IntroductoryPriceInfo setIntroductoryPricePeriod(java.lang.String introductoryPricePeriod) {
    this.introductoryPricePeriod = introductoryPricePeriod;
    return this;
  }

  @Override
  public IntroductoryPriceInfo set(String fieldName, Object value) {
    return (IntroductoryPriceInfo) super.set(fieldName, value);
  }

  @Override
  public IntroductoryPriceInfo clone() {
    return (IntroductoryPriceInfo) super.clone();
  }

}
