/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.androidpublisher;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.androidpublisher.AndroidPublisherRequest;
import com.google.api.services.androidpublisher.AndroidPublisherRequestInitializer;
import com.google.api.services.androidpublisher.model.Apk;
import com.google.api.services.androidpublisher.model.ApksAddExternallyHostedRequest;
import com.google.api.services.androidpublisher.model.ApksAddExternallyHostedResponse;
import com.google.api.services.androidpublisher.model.ApksListResponse;
import com.google.api.services.androidpublisher.model.AppDetails;
import com.google.api.services.androidpublisher.model.AppEdit;
import com.google.api.services.androidpublisher.model.Bundle;
import com.google.api.services.androidpublisher.model.BundlesListResponse;
import com.google.api.services.androidpublisher.model.DeobfuscationFilesUploadResponse;
import com.google.api.services.androidpublisher.model.ExpansionFile;
import com.google.api.services.androidpublisher.model.ExpansionFilesUploadResponse;
import com.google.api.services.androidpublisher.model.ImagesDeleteAllResponse;
import com.google.api.services.androidpublisher.model.ImagesListResponse;
import com.google.api.services.androidpublisher.model.ImagesUploadResponse;
import com.google.api.services.androidpublisher.model.InAppProduct;
import com.google.api.services.androidpublisher.model.InappproductsListResponse;
import com.google.api.services.androidpublisher.model.Listing;
import com.google.api.services.androidpublisher.model.ListingsListResponse;
import com.google.api.services.androidpublisher.model.ProductPurchase;
import com.google.api.services.androidpublisher.model.Review;
import com.google.api.services.androidpublisher.model.ReviewsListResponse;
import com.google.api.services.androidpublisher.model.ReviewsReplyRequest;
import com.google.api.services.androidpublisher.model.ReviewsReplyResponse;
import com.google.api.services.androidpublisher.model.SubscriptionPurchase;
import com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferRequest;
import com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferResponse;
import com.google.api.services.androidpublisher.model.Testers;
import com.google.api.services.androidpublisher.model.Track;
import com.google.api.services.androidpublisher.model.TracksListResponse;
import com.google.api.services.androidpublisher.model.VoidedPurchasesListResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class AndroidPublisher
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "androidpublisher/v3/applications/";
    public static final String DEFAULT_BATCH_PATH = "batch/androidpublisher/v3";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/androidpublisher/v3/applications/";

    public AndroidPublisher(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    AndroidPublisher(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Edits edits() {
        return new Edits();
    }

    public Inappproducts inappproducts() {
        return new Inappproducts();
    }

    public Orders orders() {
        return new Orders();
    }

    public Purchases purchases() {
        return new Purchases();
    }

    public Reviews reviews() {
        return new Reviews();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.27.0 of the Google Play Developer API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, AndroidPublisher.DEFAULT_ROOT_URL, AndroidPublisher.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(AndroidPublisher.DEFAULT_BATCH_PATH);
        }

        public AndroidPublisher build() {
            return new AndroidPublisher(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setAndroidPublisherRequestInitializer(AndroidPublisherRequestInitializer androidpublisherRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)androidpublisherRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Reviews {
        public Get get(String packageName, String reviewId) throws IOException {
            Get result = new Get(packageName, reviewId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String packageName) throws IOException {
            List result = new List(packageName);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Reply reply(String packageName, String reviewId, ReviewsReplyRequest content) throws IOException {
            Reply result = new Reply(packageName, reviewId, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Reply
        extends AndroidPublisherRequest<ReviewsReplyResponse> {
            private static final String REST_PATH = "{packageName}/reviews/{reviewId}:reply";
            @Key
            private String packageName;
            @Key
            private String reviewId;

            protected Reply(String packageName, String reviewId, ReviewsReplyRequest content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, ReviewsReplyResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.reviewId = (String)Preconditions.checkNotNull((Object)reviewId, (Object)"Required parameter reviewId must be specified.");
            }

            public Reply setAlt(String alt) {
                return (Reply)super.setAlt(alt);
            }

            public Reply setFields(String fields) {
                return (Reply)super.setFields(fields);
            }

            public Reply setKey(String key) {
                return (Reply)super.setKey(key);
            }

            public Reply setOauthToken(String oauthToken) {
                return (Reply)super.setOauthToken(oauthToken);
            }

            public Reply setPrettyPrint(Boolean prettyPrint) {
                return (Reply)super.setPrettyPrint(prettyPrint);
            }

            public Reply setQuotaUser(String quotaUser) {
                return (Reply)super.setQuotaUser(quotaUser);
            }

            public Reply setUserIp(String userIp) {
                return (Reply)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Reply setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getReviewId() {
                return this.reviewId;
            }

            public Reply setReviewId(String reviewId) {
                this.reviewId = reviewId;
                return this;
            }

            @Override
            public Reply set(String parameterName, Object value) {
                return (Reply)super.set(parameterName, value);
            }
        }

        public class List
        extends AndroidPublisherRequest<ReviewsListResponse> {
            private static final String REST_PATH = "{packageName}/reviews";
            @Key
            private String packageName;
            @Key
            private Long maxResults;
            @Key
            private Long startIndex;
            @Key
            private String token;
            @Key
            private String translationLanguage;

            protected List(String packageName) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, ReviewsListResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public List setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Long getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(Long startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            public String getToken() {
                return this.token;
            }

            public List setToken(String token) {
                this.token = token;
                return this;
            }

            public String getTranslationLanguage() {
                return this.translationLanguage;
            }

            public List setTranslationLanguage(String translationLanguage) {
                this.translationLanguage = translationLanguage;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends AndroidPublisherRequest<Review> {
            private static final String REST_PATH = "{packageName}/reviews/{reviewId}";
            @Key
            private String packageName;
            @Key
            private String reviewId;
            @Key
            private String translationLanguage;

            protected Get(String packageName, String reviewId) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, Review.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.reviewId = (String)Preconditions.checkNotNull((Object)reviewId, (Object)"Required parameter reviewId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getReviewId() {
                return this.reviewId;
            }

            public Get setReviewId(String reviewId) {
                this.reviewId = reviewId;
                return this;
            }

            public String getTranslationLanguage() {
                return this.translationLanguage;
            }

            public Get setTranslationLanguage(String translationLanguage) {
                this.translationLanguage = translationLanguage;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Purchases {
        public Products products() {
            return new Products();
        }

        public Subscriptions subscriptions() {
            return new Subscriptions();
        }

        public Voidedpurchases voidedpurchases() {
            return new Voidedpurchases();
        }

        public class Voidedpurchases {
            public List list(String packageName) throws IOException {
                List result = new List(packageName);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AndroidPublisherRequest<VoidedPurchasesListResponse> {
                private static final String REST_PATH = "{packageName}/purchases/voidedpurchases";
                @Key
                private String packageName;
                @Key
                private Long endTime;
                @Key
                private Long maxResults;
                @Key
                private Long startIndex;
                @Key
                private Long startTime;
                @Key
                private String token;

                protected List(String packageName) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, VoidedPurchasesListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public Long getEndTime() {
                    return this.endTime;
                }

                public List setEndTime(Long endTime) {
                    this.endTime = endTime;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Long getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Long startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                public Long getStartTime() {
                    return this.startTime;
                }

                public List setStartTime(Long startTime) {
                    this.startTime = startTime;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public List setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Subscriptions {
            public Cancel cancel(String packageName, String subscriptionId, String token) throws IOException {
                Cancel result = new Cancel(packageName, subscriptionId, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Defer defer(String packageName, String subscriptionId, String token, SubscriptionPurchasesDeferRequest content) throws IOException {
                Defer result = new Defer(packageName, subscriptionId, token, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String packageName, String subscriptionId, String token) throws IOException {
                Get result = new Get(packageName, subscriptionId, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Refund refund(String packageName, String subscriptionId, String token) throws IOException {
                Refund result = new Refund(packageName, subscriptionId, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Revoke revoke(String packageName, String subscriptionId, String token) throws IOException {
                Revoke result = new Revoke(packageName, subscriptionId, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Revoke
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:revoke";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Revoke(String packageName, String subscriptionId, String token) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Revoke setAlt(String alt) {
                    return (Revoke)super.setAlt(alt);
                }

                public Revoke setFields(String fields) {
                    return (Revoke)super.setFields(fields);
                }

                public Revoke setKey(String key) {
                    return (Revoke)super.setKey(key);
                }

                public Revoke setOauthToken(String oauthToken) {
                    return (Revoke)super.setOauthToken(oauthToken);
                }

                public Revoke setPrettyPrint(Boolean prettyPrint) {
                    return (Revoke)super.setPrettyPrint(prettyPrint);
                }

                public Revoke setQuotaUser(String quotaUser) {
                    return (Revoke)super.setQuotaUser(quotaUser);
                }

                public Revoke setUserIp(String userIp) {
                    return (Revoke)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Revoke setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Revoke setSubscriptionId(String subscriptionId) {
                    this.subscriptionId = subscriptionId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Revoke setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Revoke set(String parameterName, Object value) {
                    return (Revoke)super.set(parameterName, value);
                }
            }

            public class Refund
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:refund";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Refund(String packageName, String subscriptionId, String token) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Refund setAlt(String alt) {
                    return (Refund)super.setAlt(alt);
                }

                public Refund setFields(String fields) {
                    return (Refund)super.setFields(fields);
                }

                public Refund setKey(String key) {
                    return (Refund)super.setKey(key);
                }

                public Refund setOauthToken(String oauthToken) {
                    return (Refund)super.setOauthToken(oauthToken);
                }

                public Refund setPrettyPrint(Boolean prettyPrint) {
                    return (Refund)super.setPrettyPrint(prettyPrint);
                }

                public Refund setQuotaUser(String quotaUser) {
                    return (Refund)super.setQuotaUser(quotaUser);
                }

                public Refund setUserIp(String userIp) {
                    return (Refund)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Refund setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Refund setSubscriptionId(String subscriptionId) {
                    this.subscriptionId = subscriptionId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Refund setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Refund set(String parameterName, Object value) {
                    return (Refund)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<SubscriptionPurchase> {
                private static final String REST_PATH = "{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Get(String packageName, String subscriptionId, String token) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, SubscriptionPurchase.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Get setSubscriptionId(String subscriptionId) {
                    this.subscriptionId = subscriptionId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Get setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Defer
            extends AndroidPublisherRequest<SubscriptionPurchasesDeferResponse> {
                private static final String REST_PATH = "{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:defer";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Defer(String packageName, String subscriptionId, String token, SubscriptionPurchasesDeferRequest content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, SubscriptionPurchasesDeferResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Defer setAlt(String alt) {
                    return (Defer)super.setAlt(alt);
                }

                public Defer setFields(String fields) {
                    return (Defer)super.setFields(fields);
                }

                public Defer setKey(String key) {
                    return (Defer)super.setKey(key);
                }

                public Defer setOauthToken(String oauthToken) {
                    return (Defer)super.setOauthToken(oauthToken);
                }

                public Defer setPrettyPrint(Boolean prettyPrint) {
                    return (Defer)super.setPrettyPrint(prettyPrint);
                }

                public Defer setQuotaUser(String quotaUser) {
                    return (Defer)super.setQuotaUser(quotaUser);
                }

                public Defer setUserIp(String userIp) {
                    return (Defer)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Defer setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Defer setSubscriptionId(String subscriptionId) {
                    this.subscriptionId = subscriptionId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Defer setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Defer set(String parameterName, Object value) {
                    return (Defer)super.set(parameterName, value);
                }
            }

            public class Cancel
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:cancel";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Cancel(String packageName, String subscriptionId, String token) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Cancel setAlt(String alt) {
                    return (Cancel)super.setAlt(alt);
                }

                public Cancel setFields(String fields) {
                    return (Cancel)super.setFields(fields);
                }

                public Cancel setKey(String key) {
                    return (Cancel)super.setKey(key);
                }

                public Cancel setOauthToken(String oauthToken) {
                    return (Cancel)super.setOauthToken(oauthToken);
                }

                public Cancel setPrettyPrint(Boolean prettyPrint) {
                    return (Cancel)super.setPrettyPrint(prettyPrint);
                }

                public Cancel setQuotaUser(String quotaUser) {
                    return (Cancel)super.setQuotaUser(quotaUser);
                }

                public Cancel setUserIp(String userIp) {
                    return (Cancel)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Cancel setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Cancel setSubscriptionId(String subscriptionId) {
                    this.subscriptionId = subscriptionId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Cancel setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Cancel set(String parameterName, Object value) {
                    return (Cancel)super.set(parameterName, value);
                }
            }
        }

        public class Products {
            public Get get(String packageName, String productId, String token) throws IOException {
                Get result = new Get(packageName, productId, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends AndroidPublisherRequest<ProductPurchase> {
                private static final String REST_PATH = "{packageName}/purchases/products/{productId}/tokens/{token}";
                @Key
                private String packageName;
                @Key
                private String productId;
                @Key
                private String token;

                protected Get(String packageName, String productId, String token) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ProductPurchase.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public Get setProductId(String productId) {
                    this.productId = productId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Get setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }

    public class Orders {
        public Refund refund(String packageName, String orderId) throws IOException {
            Refund result = new Refund(packageName, orderId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Refund
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "{packageName}/orders/{orderId}:refund";
            @Key
            private String packageName;
            @Key
            private String orderId;
            @Key
            private Boolean revoke;

            protected Refund(String packageName, String orderId) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Refund setAlt(String alt) {
                return (Refund)super.setAlt(alt);
            }

            public Refund setFields(String fields) {
                return (Refund)super.setFields(fields);
            }

            public Refund setKey(String key) {
                return (Refund)super.setKey(key);
            }

            public Refund setOauthToken(String oauthToken) {
                return (Refund)super.setOauthToken(oauthToken);
            }

            public Refund setPrettyPrint(Boolean prettyPrint) {
                return (Refund)super.setPrettyPrint(prettyPrint);
            }

            public Refund setQuotaUser(String quotaUser) {
                return (Refund)super.setQuotaUser(quotaUser);
            }

            public Refund setUserIp(String userIp) {
                return (Refund)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Refund setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Refund setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            public Boolean getRevoke() {
                return this.revoke;
            }

            public Refund setRevoke(Boolean revoke) {
                this.revoke = revoke;
                return this;
            }

            @Override
            public Refund set(String parameterName, Object value) {
                return (Refund)super.set(parameterName, value);
            }
        }
    }

    public class Inappproducts {
        public Delete delete(String packageName, String sku) throws IOException {
            Delete result = new Delete(packageName, sku);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String packageName, String sku) throws IOException {
            Get result = new Get(packageName, sku);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String packageName, InAppProduct content) throws IOException {
            Insert result = new Insert(packageName, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String packageName) throws IOException {
            List result = new List(packageName);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String packageName, String sku, InAppProduct content) throws IOException {
            Patch result = new Patch(packageName, sku, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String packageName, String sku, InAppProduct content) throws IOException {
            Update result = new Update(packageName, sku, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;
            @Key
            private Boolean autoConvertMissingPrices;

            protected Update(String packageName, String sku, InAppProduct content) {
                super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)sku, (Object)"Required parameter sku must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Update setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Update setSku(String sku) {
                this.sku = sku;
                return this;
            }

            public Boolean getAutoConvertMissingPrices() {
                return this.autoConvertMissingPrices;
            }

            public Update setAutoConvertMissingPrices(Boolean autoConvertMissingPrices) {
                this.autoConvertMissingPrices = autoConvertMissingPrices;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;
            @Key
            private Boolean autoConvertMissingPrices;

            protected Patch(String packageName, String sku, InAppProduct content) {
                super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)sku, (Object)"Required parameter sku must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Patch setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Patch setSku(String sku) {
                this.sku = sku;
                return this;
            }

            public Boolean getAutoConvertMissingPrices() {
                return this.autoConvertMissingPrices;
            }

            public Patch setAutoConvertMissingPrices(Boolean autoConvertMissingPrices) {
                this.autoConvertMissingPrices = autoConvertMissingPrices;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends AndroidPublisherRequest<InappproductsListResponse> {
            private static final String REST_PATH = "{packageName}/inappproducts";
            @Key
            private String packageName;
            @Key
            private Long maxResults;
            @Key
            private Long startIndex;
            @Key
            private String token;

            protected List(String packageName) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, InappproductsListResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public List setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Long getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(Long startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            public String getToken() {
                return this.token;
            }

            public List setToken(String token) {
                this.token = token;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "{packageName}/inappproducts";
            @Key
            private String packageName;
            @Key
            private Boolean autoConvertMissingPrices;

            protected Insert(String packageName, InAppProduct content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Insert setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Boolean getAutoConvertMissingPrices() {
                return this.autoConvertMissingPrices;
            }

            public Insert setAutoConvertMissingPrices(Boolean autoConvertMissingPrices) {
                this.autoConvertMissingPrices = autoConvertMissingPrices;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;

            protected Get(String packageName, String sku) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)sku, (Object)"Required parameter sku must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Get setSku(String sku) {
                this.sku = sku;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;

            protected Delete(String packageName, String sku) {
                super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)sku, (Object)"Required parameter sku must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Delete setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Delete setSku(String sku) {
                this.sku = sku;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Edits {
        public Commit commit(String packageName, String editId) throws IOException {
            Commit result = new Commit(packageName, editId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String packageName, String editId) throws IOException {
            Delete result = new Delete(packageName, editId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String packageName, String editId) throws IOException {
            Get result = new Get(packageName, editId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String packageName, AppEdit content) throws IOException {
            Insert result = new Insert(packageName, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Validate validate(String packageName, String editId) throws IOException {
            Validate result = new Validate(packageName, editId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Apks apks() {
            return new Apks();
        }

        public Bundles bundles() {
            return new Bundles();
        }

        public Deobfuscationfiles deobfuscationfiles() {
            return new Deobfuscationfiles();
        }

        public Details details() {
            return new Details();
        }

        public Expansionfiles expansionfiles() {
            return new Expansionfiles();
        }

        public Images images() {
            return new Images();
        }

        public Listings listings() {
            return new Listings();
        }

        public Testers testers() {
            return new Testers();
        }

        public Tracks tracks() {
            return new Tracks();
        }

        public class Tracks {
            public Get get(String packageName, String editId, String track) throws IOException {
                Get result = new Get(packageName, editId, track);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String packageName, String editId) throws IOException {
                List result = new List(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String packageName, String editId, String track, Track content) throws IOException {
                Patch result = new Patch(packageName, editId, track, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String packageName, String editId, String track, Track content) throws IOException {
                Update result = new Update(packageName, editId, track, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AndroidPublisherRequest<Track> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/tracks/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Update(String packageName, String editId, String track, Track content) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, Track.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Update setTrack(String track) {
                    this.track = track;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AndroidPublisherRequest<Track> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/tracks/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Patch(String packageName, String editId, String track, Track content) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, Track.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Patch setTrack(String track) {
                    this.track = track;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AndroidPublisherRequest<TracksListResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/tracks";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String packageName, String editId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, TracksListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<Track> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/tracks/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Get(String packageName, String editId, String track) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, Track.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Get setTrack(String track) {
                    this.track = track;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Testers {
            public Get get(String packageName, String editId, String track) throws IOException {
                Get result = new Get(packageName, editId, track);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String packageName, String editId, String track, com.google.api.services.androidpublisher.model.Testers content) throws IOException {
                Patch result = new Patch(packageName, editId, track, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String packageName, String editId, String track, com.google.api.services.androidpublisher.model.Testers content) throws IOException {
                Update result = new Update(packageName, editId, track, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/testers/{track}";
                private final Pattern TRACK_PATTERN;
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Update(String packageName, String editId, String track, com.google.api.services.androidpublisher.model.Testers content) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, com.google.api.services.androidpublisher.model.Testers.class);
                    this.TRACK_PATTERN = Pattern.compile("(alpha|beta|production|rollout|internal)");
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(track).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Update setTrack(String track) {
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(track).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                    this.track = track;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/testers/{track}";
                private final Pattern TRACK_PATTERN;
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Patch(String packageName, String editId, String track, com.google.api.services.androidpublisher.model.Testers content) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.androidpublisher.model.Testers.class);
                    this.TRACK_PATTERN = Pattern.compile("(alpha|beta|production|rollout|internal)");
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(track).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Patch setTrack(String track) {
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(track).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                    this.track = track;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/testers/{track}";
                private final Pattern TRACK_PATTERN;
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Get(String packageName, String editId, String track) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.Testers.class);
                    this.TRACK_PATTERN = Pattern.compile("(alpha|beta|production|rollout|internal)");
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(track).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Get setTrack(String track) {
                    if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TRACK_PATTERN.matcher(track).matches(), (Object)"Parameter track must conform to the pattern (alpha|beta|production|rollout|internal)");
                    }
                    this.track = track;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Listings {
            public Delete delete(String packageName, String editId, String language) throws IOException {
                Delete result = new Delete(packageName, editId, language);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Deleteall deleteall(String packageName, String editId) throws IOException {
                Deleteall result = new Deleteall(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String packageName, String editId, String language) throws IOException {
                Get result = new Get(packageName, editId, language);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String packageName, String editId) throws IOException {
                List result = new List(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String packageName, String editId, String language, Listing content) throws IOException {
                Patch result = new Patch(packageName, editId, language, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String packageName, String editId, String language, Listing content) throws IOException {
                Update result = new Update(packageName, editId, language, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AndroidPublisherRequest<Listing> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Update(String packageName, String editId, String language, Listing content) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, Listing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Update setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AndroidPublisherRequest<Listing> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Patch(String packageName, String editId, String language, Listing content) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, Listing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Patch setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AndroidPublisherRequest<ListingsListResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String packageName, String editId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ListingsListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<Listing> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Get(String packageName, String editId, String language) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, Listing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Get setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Deleteall
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Deleteall(String packageName, String editId) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public Deleteall setAlt(String alt) {
                    return (Deleteall)super.setAlt(alt);
                }

                public Deleteall setFields(String fields) {
                    return (Deleteall)super.setFields(fields);
                }

                public Deleteall setKey(String key) {
                    return (Deleteall)super.setKey(key);
                }

                public Deleteall setOauthToken(String oauthToken) {
                    return (Deleteall)super.setOauthToken(oauthToken);
                }

                public Deleteall setPrettyPrint(Boolean prettyPrint) {
                    return (Deleteall)super.setPrettyPrint(prettyPrint);
                }

                public Deleteall setQuotaUser(String quotaUser) {
                    return (Deleteall)super.setQuotaUser(quotaUser);
                }

                public Deleteall setUserIp(String userIp) {
                    return (Deleteall)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Deleteall setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Deleteall setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Deleteall set(String parameterName, Object value) {
                    return (Deleteall)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Delete(String packageName, String editId, String language) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Delete setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Delete setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Delete setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Images {
            public Delete delete(String packageName, String editId, String language, String imageType, String imageId) throws IOException {
                Delete result = new Delete(packageName, editId, language, imageType, imageId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Deleteall deleteall(String packageName, String editId, String language, String imageType) throws IOException {
                Deleteall result = new Deleteall(packageName, editId, language, imageType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String packageName, String editId, String language, String imageType) throws IOException {
                List result = new List(packageName, editId, language, imageType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, String language, String imageType) throws IOException {
                Upload result = new Upload(packageName, editId, language, imageType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, String language, String imageType, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(packageName, editId, language, imageType, mediaContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends AndroidPublisherRequest<ImagesUploadResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}/{imageType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;

                protected Upload(String packageName, String editId, String language, String imageType) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, ImagesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)imageType, (Object)"Required parameter imageType must be specified.");
                }

                protected Upload(String packageName, String editId, String language, String imageType, AbstractInputStreamContent mediaContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, ImagesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)imageType, (Object)"Required parameter imageType must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUserIp(String userIp) {
                    return (Upload)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Upload setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public Upload setImageType(String imageType) {
                    this.imageType = imageType;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }

            public class List
            extends AndroidPublisherRequest<ImagesListResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}/{imageType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;

                protected List(String packageName, String editId, String language, String imageType) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ImagesListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)imageType, (Object)"Required parameter imageType must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public List setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public List setImageType(String imageType) {
                    this.imageType = imageType;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Deleteall
            extends AndroidPublisherRequest<ImagesDeleteAllResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}/{imageType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;

                protected Deleteall(String packageName, String editId, String language, String imageType) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, ImagesDeleteAllResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)imageType, (Object)"Required parameter imageType must be specified.");
                }

                public Deleteall setAlt(String alt) {
                    return (Deleteall)super.setAlt(alt);
                }

                public Deleteall setFields(String fields) {
                    return (Deleteall)super.setFields(fields);
                }

                public Deleteall setKey(String key) {
                    return (Deleteall)super.setKey(key);
                }

                public Deleteall setOauthToken(String oauthToken) {
                    return (Deleteall)super.setOauthToken(oauthToken);
                }

                public Deleteall setPrettyPrint(Boolean prettyPrint) {
                    return (Deleteall)super.setPrettyPrint(prettyPrint);
                }

                public Deleteall setQuotaUser(String quotaUser) {
                    return (Deleteall)super.setQuotaUser(quotaUser);
                }

                public Deleteall setUserIp(String userIp) {
                    return (Deleteall)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Deleteall setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Deleteall setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Deleteall setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public Deleteall setImageType(String imageType) {
                    this.imageType = imageType;
                    return this;
                }

                @Override
                public Deleteall set(String parameterName, Object value) {
                    return (Deleteall)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/listings/{language}/{imageType}/{imageId}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;
                @Key
                private String imageId;

                protected Delete(String packageName, String editId, String language, String imageType, String imageId) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)imageType, (Object)"Required parameter imageType must be specified.");
                    this.imageId = (String)Preconditions.checkNotNull((Object)imageId, (Object)"Required parameter imageId must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Delete setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Delete setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Delete setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public Delete setImageType(String imageType) {
                    this.imageType = imageType;
                    return this;
                }

                public String getImageId() {
                    return this.imageId;
                }

                public Delete setImageId(String imageId) {
                    this.imageId = imageId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Expansionfiles {
            public Get get(String packageName, String editId, Integer apkVersionCode, String expansionFileType) throws IOException {
                Get result = new Get(packageName, editId, apkVersionCode, expansionFileType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String packageName, String editId, Integer apkVersionCode, String expansionFileType, ExpansionFile content) throws IOException {
                Patch result = new Patch(packageName, editId, apkVersionCode, expansionFileType, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String packageName, String editId, Integer apkVersionCode, String expansionFileType, ExpansionFile content) throws IOException {
                Update result = new Update(packageName, editId, apkVersionCode, expansionFileType, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, Integer apkVersionCode, String expansionFileType) throws IOException {
                Upload result = new Upload(packageName, editId, apkVersionCode, expansionFileType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, Integer apkVersionCode, String expansionFileType, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(packageName, editId, apkVersionCode, expansionFileType, mediaContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends AndroidPublisherRequest<ExpansionFilesUploadResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Upload(String packageName, String editId, Integer apkVersionCode, String expansionFileType) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, ExpansionFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)expansionFileType, (Object)"Required parameter expansionFileType must be specified.");
                }

                protected Upload(String packageName, String editId, Integer apkVersionCode, String expansionFileType, AbstractInputStreamContent mediaContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, ExpansionFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)expansionFileType, (Object)"Required parameter expansionFileType must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUserIp(String userIp) {
                    return (Upload)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Upload setApkVersionCode(Integer apkVersionCode) {
                    this.apkVersionCode = apkVersionCode;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Upload setExpansionFileType(String expansionFileType) {
                    this.expansionFileType = expansionFileType;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }

            public class Update
            extends AndroidPublisherRequest<ExpansionFile> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Update(String packageName, String editId, Integer apkVersionCode, String expansionFileType, ExpansionFile content) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, ExpansionFile.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)expansionFileType, (Object)"Required parameter expansionFileType must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Update setApkVersionCode(Integer apkVersionCode) {
                    this.apkVersionCode = apkVersionCode;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Update setExpansionFileType(String expansionFileType) {
                    this.expansionFileType = expansionFileType;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AndroidPublisherRequest<ExpansionFile> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Patch(String packageName, String editId, Integer apkVersionCode, String expansionFileType, ExpansionFile content) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, ExpansionFile.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)expansionFileType, (Object)"Required parameter expansionFileType must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Patch setApkVersionCode(Integer apkVersionCode) {
                    this.apkVersionCode = apkVersionCode;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Patch setExpansionFileType(String expansionFileType) {
                    this.expansionFileType = expansionFileType;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<ExpansionFile> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Get(String packageName, String editId, Integer apkVersionCode, String expansionFileType) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ExpansionFile.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)expansionFileType, (Object)"Required parameter expansionFileType must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Get setApkVersionCode(Integer apkVersionCode) {
                    this.apkVersionCode = apkVersionCode;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Get setExpansionFileType(String expansionFileType) {
                    this.expansionFileType = expansionFileType;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Details {
            public Get get(String packageName, String editId) throws IOException {
                Get result = new Get(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String packageName, String editId, AppDetails content) throws IOException {
                Patch result = new Patch(packageName, editId, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String packageName, String editId, AppDetails content) throws IOException {
                Update result = new Update(packageName, editId, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AndroidPublisherRequest<AppDetails> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/details";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Update(String packageName, String editId, AppDetails content) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, AppDetails.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AndroidPublisherRequest<AppDetails> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/details";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Patch(String packageName, String editId, AppDetails content) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, AppDetails.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<AppDetails> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/details";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Get(String packageName, String editId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, AppDetails.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Deobfuscationfiles {
            public Upload upload(String packageName, String editId, Integer apkVersionCode, String deobfuscationFileType) throws IOException {
                Upload result = new Upload(packageName, editId, apkVersionCode, deobfuscationFileType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, Integer apkVersionCode, String deobfuscationFileType, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(packageName, editId, apkVersionCode, deobfuscationFileType, mediaContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends AndroidPublisherRequest<DeobfuscationFilesUploadResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/{apkVersionCode}/deobfuscationFiles/{deobfuscationFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String deobfuscationFileType;

                protected Upload(String packageName, String editId, Integer apkVersionCode, String deobfuscationFileType) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, DeobfuscationFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.deobfuscationFileType = (String)Preconditions.checkNotNull((Object)deobfuscationFileType, (Object)"Required parameter deobfuscationFileType must be specified.");
                }

                protected Upload(String packageName, String editId, Integer apkVersionCode, String deobfuscationFileType, AbstractInputStreamContent mediaContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, DeobfuscationFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.deobfuscationFileType = (String)Preconditions.checkNotNull((Object)deobfuscationFileType, (Object)"Required parameter deobfuscationFileType must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUserIp(String userIp) {
                    return (Upload)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Upload setApkVersionCode(Integer apkVersionCode) {
                    this.apkVersionCode = apkVersionCode;
                    return this;
                }

                public String getDeobfuscationFileType() {
                    return this.deobfuscationFileType;
                }

                public Upload setDeobfuscationFileType(String deobfuscationFileType) {
                    this.deobfuscationFileType = deobfuscationFileType;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }
        }

        public class Bundles {
            public List list(String packageName, String editId) throws IOException {
                List result = new List(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId) throws IOException {
                Upload result = new Upload(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(packageName, editId, mediaContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends AndroidPublisherRequest<Bundle> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/bundles";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Boolean ackBundleInstallationWarning;

                protected Upload(String packageName, String editId) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Bundle.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                protected Upload(String packageName, String editId, AbstractInputStreamContent mediaContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, Bundle.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUserIp(String userIp) {
                    return (Upload)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Boolean getAckBundleInstallationWarning() {
                    return this.ackBundleInstallationWarning;
                }

                public Upload setAckBundleInstallationWarning(Boolean ackBundleInstallationWarning) {
                    this.ackBundleInstallationWarning = ackBundleInstallationWarning;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }

            public class List
            extends AndroidPublisherRequest<BundlesListResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/bundles";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String packageName, String editId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, BundlesListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Apks {
            public Addexternallyhosted addexternallyhosted(String packageName, String editId, ApksAddExternallyHostedRequest content) throws IOException {
                Addexternallyhosted result = new Addexternallyhosted(packageName, editId, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String packageName, String editId) throws IOException {
                List result = new List(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId) throws IOException {
                Upload result = new Upload(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(packageName, editId, mediaContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends AndroidPublisherRequest<Apk> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Upload(String packageName, String editId) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Apk.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                protected Upload(String packageName, String editId, AbstractInputStreamContent mediaContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, Apk.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUserIp(String userIp) {
                    return (Upload)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }

            public class List
            extends AndroidPublisherRequest<ApksListResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String packageName, String editId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ApksListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Addexternallyhosted
            extends AndroidPublisherRequest<ApksAddExternallyHostedResponse> {
                private static final String REST_PATH = "{packageName}/edits/{editId}/apks/externallyHosted";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Addexternallyhosted(String packageName, String editId, ApksAddExternallyHostedRequest content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, ApksAddExternallyHostedResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public Addexternallyhosted setAlt(String alt) {
                    return (Addexternallyhosted)super.setAlt(alt);
                }

                public Addexternallyhosted setFields(String fields) {
                    return (Addexternallyhosted)super.setFields(fields);
                }

                public Addexternallyhosted setKey(String key) {
                    return (Addexternallyhosted)super.setKey(key);
                }

                public Addexternallyhosted setOauthToken(String oauthToken) {
                    return (Addexternallyhosted)super.setOauthToken(oauthToken);
                }

                public Addexternallyhosted setPrettyPrint(Boolean prettyPrint) {
                    return (Addexternallyhosted)super.setPrettyPrint(prettyPrint);
                }

                public Addexternallyhosted setQuotaUser(String quotaUser) {
                    return (Addexternallyhosted)super.setQuotaUser(quotaUser);
                }

                public Addexternallyhosted setUserIp(String userIp) {
                    return (Addexternallyhosted)super.setUserIp(userIp);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Addexternallyhosted setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Addexternallyhosted setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Addexternallyhosted set(String parameterName, Object value) {
                    return (Addexternallyhosted)super.set(parameterName, value);
                }
            }
        }

        public class Validate
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "{packageName}/edits/{editId}:validate";
            @Key
            private String packageName;
            @Key
            private String editId;

            protected Validate(String packageName, String editId) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
            }

            public Validate setAlt(String alt) {
                return (Validate)super.setAlt(alt);
            }

            public Validate setFields(String fields) {
                return (Validate)super.setFields(fields);
            }

            public Validate setKey(String key) {
                return (Validate)super.setKey(key);
            }

            public Validate setOauthToken(String oauthToken) {
                return (Validate)super.setOauthToken(oauthToken);
            }

            public Validate setPrettyPrint(Boolean prettyPrint) {
                return (Validate)super.setPrettyPrint(prettyPrint);
            }

            public Validate setQuotaUser(String quotaUser) {
                return (Validate)super.setQuotaUser(quotaUser);
            }

            public Validate setUserIp(String userIp) {
                return (Validate)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Validate setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Validate setEditId(String editId) {
                this.editId = editId;
                return this;
            }

            @Override
            public Validate set(String parameterName, Object value) {
                return (Validate)super.set(parameterName, value);
            }
        }

        public class Insert
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "{packageName}/edits";
            @Key
            private String packageName;

            protected Insert(String packageName, AppEdit content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Insert setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "{packageName}/edits/{editId}";
            @Key
            private String packageName;
            @Key
            private String editId;

            protected Get(String packageName, String editId) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Get setEditId(String editId) {
                this.editId = editId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "{packageName}/edits/{editId}";
            @Key
            private String packageName;
            @Key
            private String editId;

            protected Delete(String packageName, String editId) {
                super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Delete setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Delete setEditId(String editId) {
                this.editId = editId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Commit
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "{packageName}/edits/{editId}:commit";
            @Key
            private String packageName;
            @Key
            private String editId;

            protected Commit(String packageName, String editId) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
            }

            public Commit setAlt(String alt) {
                return (Commit)super.setAlt(alt);
            }

            public Commit setFields(String fields) {
                return (Commit)super.setFields(fields);
            }

            public Commit setKey(String key) {
                return (Commit)super.setKey(key);
            }

            public Commit setOauthToken(String oauthToken) {
                return (Commit)super.setOauthToken(oauthToken);
            }

            public Commit setPrettyPrint(Boolean prettyPrint) {
                return (Commit)super.setPrettyPrint(prettyPrint);
            }

            public Commit setQuotaUser(String quotaUser) {
                return (Commit)super.setQuotaUser(quotaUser);
            }

            public Commit setUserIp(String userIp) {
                return (Commit)super.setUserIp(userIp);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Commit setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Commit setEditId(String editId) {
                this.editId = editId;
                return this;
            }

            @Override
            public Commit set(String parameterName, Object value) {
                return (Commit)super.set(parameterName, value);
            }
        }
    }
}

