/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher;

/**
 * Service definition for AndroidPublisher (v3).
 *
 * <p>
 * Lets Android application developers access their Google Play accounts.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/android-publisher" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link AndroidPublisherRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class AndroidPublisher extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.30.9 of the Google Play Android Developer API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/androidpublisher";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public AndroidPublisher(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  AndroidPublisher(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Edits collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
   *   {@code AndroidPublisher.Edits.List request = androidpublisher.edits().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Edits edits() {
    return new Edits();
  }

  /**
   * The "edits" collection of methods.
   */
  public class Edits {

    /**
     * Commits an app edit.
     *
     * Create a request for the method "edits.commit".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Commit#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param editId Identifier of the edit.
     * @return the request
     */
    public Commit commit(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
      Commit result = new Commit(packageName, editId);
      initialize(result);
      return result;
    }

    public class Commit extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.AppEdit> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}:commit";

      /**
       * Commits an app edit.
       *
       * Create a request for the method "edits.commit".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Commit#execute()} method to invoke the remote operation.
       * <p> {@link
       * Commit#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @since 1.13
       */
      protected Commit(java.lang.String packageName, java.lang.String editId) {
        super(AndroidPublisher.this, "POST", REST_PATH, null, com.google.api.services.androidpublisher.model.AppEdit.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
      }

      @Override
      public Commit set$Xgafv(java.lang.String $Xgafv) {
        return (Commit) super.set$Xgafv($Xgafv);
      }

      @Override
      public Commit setAccessToken(java.lang.String accessToken) {
        return (Commit) super.setAccessToken(accessToken);
      }

      @Override
      public Commit setAlt(java.lang.String alt) {
        return (Commit) super.setAlt(alt);
      }

      @Override
      public Commit setCallback(java.lang.String callback) {
        return (Commit) super.setCallback(callback);
      }

      @Override
      public Commit setFields(java.lang.String fields) {
        return (Commit) super.setFields(fields);
      }

      @Override
      public Commit setKey(java.lang.String key) {
        return (Commit) super.setKey(key);
      }

      @Override
      public Commit setOauthToken(java.lang.String oauthToken) {
        return (Commit) super.setOauthToken(oauthToken);
      }

      @Override
      public Commit setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Commit) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Commit setQuotaUser(java.lang.String quotaUser) {
        return (Commit) super.setQuotaUser(quotaUser);
      }

      @Override
      public Commit setUploadType(java.lang.String uploadType) {
        return (Commit) super.setUploadType(uploadType);
      }

      @Override
      public Commit setUploadProtocol(java.lang.String uploadProtocol) {
        return (Commit) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Commit setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** Identifier of the edit. */
      @com.google.api.client.util.Key
      private java.lang.String editId;

      /** Identifier of the edit.
       */
      public java.lang.String getEditId() {
        return editId;
      }

      /** Identifier of the edit. */
      public Commit setEditId(java.lang.String editId) {
        this.editId = editId;
        return this;
      }

      @Override
      public Commit set(String parameterName, Object value) {
        return (Commit) super.set(parameterName, value);
      }
    }
    /**
     * Deletes an app edit.
     *
     * Create a request for the method "edits.delete".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param editId Identifier of the edit.
     * @return the request
     */
    public Delete delete(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
      Delete result = new Delete(packageName, editId);
      initialize(result);
      return result;
    }

    public class Delete extends AndroidPublisherRequest<Void> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}";

      /**
       * Deletes an app edit.
       *
       * Create a request for the method "edits.delete".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @since 1.13
       */
      protected Delete(java.lang.String packageName, java.lang.String editId) {
        super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Delete setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** Identifier of the edit. */
      @com.google.api.client.util.Key
      private java.lang.String editId;

      /** Identifier of the edit.
       */
      public java.lang.String getEditId() {
        return editId;
      }

      /** Identifier of the edit. */
      public Delete setEditId(java.lang.String editId) {
        this.editId = editId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets an app edit.
     *
     * Create a request for the method "edits.get".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param editId Identifier of the edit.
     * @return the request
     */
    public Get get(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
      Get result = new Get(packageName, editId);
      initialize(result);
      return result;
    }

    public class Get extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.AppEdit> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}";

      /**
       * Gets an app edit.
       *
       * Create a request for the method "edits.get".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @since 1.13
       */
      protected Get(java.lang.String packageName, java.lang.String editId) {
        super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.AppEdit.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Get setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** Identifier of the edit. */
      @com.google.api.client.util.Key
      private java.lang.String editId;

      /** Identifier of the edit.
       */
      public java.lang.String getEditId() {
        return editId;
      }

      /** Identifier of the edit. */
      public Get setEditId(java.lang.String editId) {
        this.editId = editId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new edit for an app.
     *
     * Create a request for the method "edits.insert".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param content the {@link com.google.api.services.androidpublisher.model.AppEdit}
     * @return the request
     */
    public Insert insert(java.lang.String packageName, com.google.api.services.androidpublisher.model.AppEdit content) throws java.io.IOException {
      Insert result = new Insert(packageName, content);
      initialize(result);
      return result;
    }

    public class Insert extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.AppEdit> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits";

      /**
       * Creates a new edit for an app.
       *
       * Create a request for the method "edits.insert".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param content the {@link com.google.api.services.androidpublisher.model.AppEdit}
       * @since 1.13
       */
      protected Insert(java.lang.String packageName, com.google.api.services.androidpublisher.model.AppEdit content) {
        super(AndroidPublisher.this, "POST", REST_PATH, content, com.google.api.services.androidpublisher.model.AppEdit.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Insert setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Validates an app edit.
     *
     * Create a request for the method "edits.validate".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Validate#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param editId Identifier of the edit.
     * @return the request
     */
    public Validate validate(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
      Validate result = new Validate(packageName, editId);
      initialize(result);
      return result;
    }

    public class Validate extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.AppEdit> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}:validate";

      /**
       * Validates an app edit.
       *
       * Create a request for the method "edits.validate".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Validate#execute()} method to invoke the remote operation.
       * <p> {@link
       * Validate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @since 1.13
       */
      protected Validate(java.lang.String packageName, java.lang.String editId) {
        super(AndroidPublisher.this, "POST", REST_PATH, null, com.google.api.services.androidpublisher.model.AppEdit.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
      }

      @Override
      public Validate set$Xgafv(java.lang.String $Xgafv) {
        return (Validate) super.set$Xgafv($Xgafv);
      }

      @Override
      public Validate setAccessToken(java.lang.String accessToken) {
        return (Validate) super.setAccessToken(accessToken);
      }

      @Override
      public Validate setAlt(java.lang.String alt) {
        return (Validate) super.setAlt(alt);
      }

      @Override
      public Validate setCallback(java.lang.String callback) {
        return (Validate) super.setCallback(callback);
      }

      @Override
      public Validate setFields(java.lang.String fields) {
        return (Validate) super.setFields(fields);
      }

      @Override
      public Validate setKey(java.lang.String key) {
        return (Validate) super.setKey(key);
      }

      @Override
      public Validate setOauthToken(java.lang.String oauthToken) {
        return (Validate) super.setOauthToken(oauthToken);
      }

      @Override
      public Validate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Validate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Validate setQuotaUser(java.lang.String quotaUser) {
        return (Validate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Validate setUploadType(java.lang.String uploadType) {
        return (Validate) super.setUploadType(uploadType);
      }

      @Override
      public Validate setUploadProtocol(java.lang.String uploadProtocol) {
        return (Validate) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Validate setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** Identifier of the edit. */
      @com.google.api.client.util.Key
      private java.lang.String editId;

      /** Identifier of the edit.
       */
      public java.lang.String getEditId() {
        return editId;
      }

      /** Identifier of the edit. */
      public Validate setEditId(java.lang.String editId) {
        this.editId = editId;
        return this;
      }

      @Override
      public Validate set(String parameterName, Object value) {
        return (Validate) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Apks collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Apks.List request = androidpublisher.apks().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Apks apks() {
      return new Apks();
    }

    /**
     * The "apks" collection of methods.
     */
    public class Apks {

      /**
       * Creates a new APK without uploading the APK itself to Google Play, instead hosting the APK at a
       * specified URL. This function is only available to organizations using Managed Play whose
       * application is configured to restrict distribution to the organizations.
       *
       * Create a request for the method "apks.addexternallyhosted".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Addexternallyhosted#execute()} method to invoke the remote
       * operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param content the {@link com.google.api.services.androidpublisher.model.ApksAddExternallyHostedRequest}
       * @return the request
       */
      public Addexternallyhosted addexternallyhosted(java.lang.String packageName, java.lang.String editId, com.google.api.services.androidpublisher.model.ApksAddExternallyHostedRequest content) throws java.io.IOException {
        Addexternallyhosted result = new Addexternallyhosted(packageName, editId, content);
        initialize(result);
        return result;
      }

      public class Addexternallyhosted extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ApksAddExternallyHostedResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/externallyHosted";

        /**
         * Creates a new APK without uploading the APK itself to Google Play, instead hosting the APK at a
         * specified URL. This function is only available to organizations using Managed Play whose
         * application is configured to restrict distribution to the organizations.
         *
         * Create a request for the method "apks.addexternallyhosted".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Addexternallyhosted#execute()} method to invoke the remote
         * operation. <p> {@link Addexternallyhosted#initialize(com.google.api.client.googleapis.services.
         * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param content the {@link com.google.api.services.androidpublisher.model.ApksAddExternallyHostedRequest}
         * @since 1.13
         */
        protected Addexternallyhosted(java.lang.String packageName, java.lang.String editId, com.google.api.services.androidpublisher.model.ApksAddExternallyHostedRequest content) {
          super(AndroidPublisher.this, "POST", REST_PATH, content, com.google.api.services.androidpublisher.model.ApksAddExternallyHostedResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
        }

        @Override
        public Addexternallyhosted set$Xgafv(java.lang.String $Xgafv) {
          return (Addexternallyhosted) super.set$Xgafv($Xgafv);
        }

        @Override
        public Addexternallyhosted setAccessToken(java.lang.String accessToken) {
          return (Addexternallyhosted) super.setAccessToken(accessToken);
        }

        @Override
        public Addexternallyhosted setAlt(java.lang.String alt) {
          return (Addexternallyhosted) super.setAlt(alt);
        }

        @Override
        public Addexternallyhosted setCallback(java.lang.String callback) {
          return (Addexternallyhosted) super.setCallback(callback);
        }

        @Override
        public Addexternallyhosted setFields(java.lang.String fields) {
          return (Addexternallyhosted) super.setFields(fields);
        }

        @Override
        public Addexternallyhosted setKey(java.lang.String key) {
          return (Addexternallyhosted) super.setKey(key);
        }

        @Override
        public Addexternallyhosted setOauthToken(java.lang.String oauthToken) {
          return (Addexternallyhosted) super.setOauthToken(oauthToken);
        }

        @Override
        public Addexternallyhosted setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Addexternallyhosted) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Addexternallyhosted setQuotaUser(java.lang.String quotaUser) {
          return (Addexternallyhosted) super.setQuotaUser(quotaUser);
        }

        @Override
        public Addexternallyhosted setUploadType(java.lang.String uploadType) {
          return (Addexternallyhosted) super.setUploadType(uploadType);
        }

        @Override
        public Addexternallyhosted setUploadProtocol(java.lang.String uploadProtocol) {
          return (Addexternallyhosted) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Addexternallyhosted setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Addexternallyhosted setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        @Override
        public Addexternallyhosted set(String parameterName, Object value) {
          return (Addexternallyhosted) super.set(parameterName, value);
        }
      }
      /**
       * Lists all current APKs of the app and edit.
       *
       * Create a request for the method "apks.list".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @return the request
       */
      public List list(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
        List result = new List(packageName, editId);
        initialize(result);
        return result;
      }

      public class List extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ApksListResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks";

        /**
         * Lists all current APKs of the app and edit.
         *
         * Create a request for the method "apks.list".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @since 1.13
         */
        protected List(java.lang.String packageName, java.lang.String editId) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.ApksListResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public List setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public List setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Uploads an APK and adds to the current edit.
       *
       * Create a request for the method "apks.upload".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @return the request
       */
      public Upload upload(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
        Upload result = new Upload(packageName, editId);
        initialize(result);
        return result;
      }

      /**
       * Uploads an APK and adds to the current edit.
       *
       * Create a request for the method "apks.upload".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param packageName Package name of the app.@param editId Identifier of the edit.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Upload upload(java.lang.String packageName, java.lang.String editId, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Upload result = new Upload(packageName, editId, mediaContent);
        initialize(result);
        return result;
      }

      public class Upload extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Apk> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks";

        /**
         * Uploads an APK and adds to the current edit.
         *
         * Create a request for the method "apks.upload".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @since 1.13
         */
        protected Upload(java.lang.String packageName, java.lang.String editId) {
          super(AndroidPublisher.this, "POST", REST_PATH, null, com.google.api.services.androidpublisher.model.Apk.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
        }

        /**
         * Uploads an APK and adds to the current edit.
         *
         * Create a request for the method "apks.upload".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param packageName Package name of the app.@param editId Identifier of the edit.
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Upload(java.lang.String packageName, java.lang.String editId, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(AndroidPublisher.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.androidpublisher.model.Apk.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Upload set$Xgafv(java.lang.String $Xgafv) {
          return (Upload) super.set$Xgafv($Xgafv);
        }

        @Override
        public Upload setAccessToken(java.lang.String accessToken) {
          return (Upload) super.setAccessToken(accessToken);
        }

        @Override
        public Upload setAlt(java.lang.String alt) {
          return (Upload) super.setAlt(alt);
        }

        @Override
        public Upload setCallback(java.lang.String callback) {
          return (Upload) super.setCallback(callback);
        }

        @Override
        public Upload setFields(java.lang.String fields) {
          return (Upload) super.setFields(fields);
        }

        @Override
        public Upload setKey(java.lang.String key) {
          return (Upload) super.setKey(key);
        }

        @Override
        public Upload setOauthToken(java.lang.String oauthToken) {
          return (Upload) super.setOauthToken(oauthToken);
        }

        @Override
        public Upload setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Upload) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Upload setQuotaUser(java.lang.String quotaUser) {
          return (Upload) super.setQuotaUser(quotaUser);
        }

        @Override
        public Upload setUploadType(java.lang.String uploadType) {
          return (Upload) super.setUploadType(uploadType);
        }

        @Override
        public Upload setUploadProtocol(java.lang.String uploadProtocol) {
          return (Upload) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Upload setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Upload setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        @Override
        public Upload set(String parameterName, Object value) {
          return (Upload) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Bundles collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Bundles.List request = androidpublisher.bundles().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Bundles bundles() {
      return new Bundles();
    }

    /**
     * The "bundles" collection of methods.
     */
    public class Bundles {

      /**
       * Lists all current Android App Bundles of the app and edit.
       *
       * Create a request for the method "bundles.list".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @return the request
       */
      public List list(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
        List result = new List(packageName, editId);
        initialize(result);
        return result;
      }

      public class List extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.BundlesListResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles";

        /**
         * Lists all current Android App Bundles of the app and edit.
         *
         * Create a request for the method "bundles.list".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @since 1.13
         */
        protected List(java.lang.String packageName, java.lang.String editId) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.BundlesListResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public List setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public List setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Uploads a new Android App Bundle to this edit. If you are using the Google API client libraries,
       * please increase the timeout of the http request before calling this endpoint (a timeout of 2
       * minutes is recommended). See [Timeouts and Errors](https://developers.google.com/api-client-
       * library/java/google-api-java-client/errors) for an example in java.
       *
       * Create a request for the method "bundles.upload".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @return the request
       */
      public Upload upload(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
        Upload result = new Upload(packageName, editId);
        initialize(result);
        return result;
      }

      /**
       * Uploads a new Android App Bundle to this edit. If you are using the Google API client libraries,
       * please increase the timeout of the http request before calling this endpoint (a timeout of 2
       * minutes is recommended). See [Timeouts and Errors](https://developers.google.com/api-client-
       * library/java/google-api-java-client/errors) for an example in java.
       *
       * Create a request for the method "bundles.upload".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param packageName Package name of the app.@param editId Identifier of the edit.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Upload upload(java.lang.String packageName, java.lang.String editId, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Upload result = new Upload(packageName, editId, mediaContent);
        initialize(result);
        return result;
      }

      public class Upload extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Bundle> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles";

        /**
         * Uploads a new Android App Bundle to this edit. If you are using the Google API client
         * libraries, please increase the timeout of the http request before calling this endpoint (a
         * timeout of 2 minutes is recommended). See [Timeouts and Errors](https://developers.google.com
         * /api-client-library/java/google-api-java-client/errors) for an example in java.
         *
         * Create a request for the method "bundles.upload".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @since 1.13
         */
        protected Upload(java.lang.String packageName, java.lang.String editId) {
          super(AndroidPublisher.this, "POST", REST_PATH, null, com.google.api.services.androidpublisher.model.Bundle.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
        }

        /**
         * Uploads a new Android App Bundle to this edit. If you are using the Google API client
         * libraries, please increase the timeout of the http request before calling this endpoint (a
         * timeout of 2 minutes is recommended). See [Timeouts and Errors](https://developers.google.com
         * /api-client-library/java/google-api-java-client/errors) for an example in java.
         *
         * Create a request for the method "bundles.upload".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param packageName Package name of the app.@param editId Identifier of the edit.
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Upload(java.lang.String packageName, java.lang.String editId, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(AndroidPublisher.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.androidpublisher.model.Bundle.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Upload set$Xgafv(java.lang.String $Xgafv) {
          return (Upload) super.set$Xgafv($Xgafv);
        }

        @Override
        public Upload setAccessToken(java.lang.String accessToken) {
          return (Upload) super.setAccessToken(accessToken);
        }

        @Override
        public Upload setAlt(java.lang.String alt) {
          return (Upload) super.setAlt(alt);
        }

        @Override
        public Upload setCallback(java.lang.String callback) {
          return (Upload) super.setCallback(callback);
        }

        @Override
        public Upload setFields(java.lang.String fields) {
          return (Upload) super.setFields(fields);
        }

        @Override
        public Upload setKey(java.lang.String key) {
          return (Upload) super.setKey(key);
        }

        @Override
        public Upload setOauthToken(java.lang.String oauthToken) {
          return (Upload) super.setOauthToken(oauthToken);
        }

        @Override
        public Upload setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Upload) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Upload setQuotaUser(java.lang.String quotaUser) {
          return (Upload) super.setQuotaUser(quotaUser);
        }

        @Override
        public Upload setUploadType(java.lang.String uploadType) {
          return (Upload) super.setUploadType(uploadType);
        }

        @Override
        public Upload setUploadProtocol(java.lang.String uploadProtocol) {
          return (Upload) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Upload setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Upload setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * Must be set to true if the bundle installation may trigger a warning on user devices (for
         * example, if installation size may be over a threshold, typically 100 MB).
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean ackBundleInstallationWarning;

        /** Must be set to true if the bundle installation may trigger a warning on user devices (for example,
       if installation size may be over a threshold, typically 100 MB).
         */
        public java.lang.Boolean getAckBundleInstallationWarning() {
          return ackBundleInstallationWarning;
        }

        /**
         * Must be set to true if the bundle installation may trigger a warning on user devices (for
         * example, if installation size may be over a threshold, typically 100 MB).
         */
        public Upload setAckBundleInstallationWarning(java.lang.Boolean ackBundleInstallationWarning) {
          this.ackBundleInstallationWarning = ackBundleInstallationWarning;
          return this;
        }

        @Override
        public Upload set(String parameterName, Object value) {
          return (Upload) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Deobfuscationfiles collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Deobfuscationfiles.List request = androidpublisher.deobfuscationfiles().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Deobfuscationfiles deobfuscationfiles() {
      return new Deobfuscationfiles();
    }

    /**
     * The "deobfuscationfiles" collection of methods.
     */
    public class Deobfuscationfiles {

      /**
       * Uploads a new deobfuscation file and attaches to the specified APK.
       *
       * Create a request for the method "deobfuscationfiles.upload".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * @param packageName Unique identifier for the Android app.
       * @param editId Unique identifier for this edit.
       * @param apkVersionCode The version code of the APK whose Deobfuscation File is being
      uploaded.
       * @param deobfuscationFileType The type of the deobfuscation file.
       * @return the request
       */
      public Upload upload(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String deobfuscationFileType) throws java.io.IOException {
        Upload result = new Upload(packageName, editId, apkVersionCode, deobfuscationFileType);
        initialize(result);
        return result;
      }

      /**
       * Uploads a new deobfuscation file and attaches to the specified APK.
       *
       * Create a request for the method "deobfuscationfiles.upload".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param packageName Unique identifier for the Android app.@param editId Unique identifier for this edit.@param apkVersionCode The version code of the APK whose Deobfuscation File is being
      uploaded.@param deobfuscationFileType The type of the deobfuscation file.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Upload upload(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String deobfuscationFileType, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Upload result = new Upload(packageName, editId, apkVersionCode, deobfuscationFileType, mediaContent);
        initialize(result);
        return result;
      }

      public class Upload extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.DeobfuscationFilesUploadResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/deobfuscationFiles/{deobfuscationFileType}";

        /**
         * Uploads a new deobfuscation file and attaches to the specified APK.
         *
         * Create a request for the method "deobfuscationfiles.upload".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Unique identifier for the Android app.
         * @param editId Unique identifier for this edit.
         * @param apkVersionCode The version code of the APK whose Deobfuscation File is being
      uploaded.
         * @param deobfuscationFileType The type of the deobfuscation file.
         * @since 1.13
         */
        protected Upload(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String deobfuscationFileType) {
          super(AndroidPublisher.this, "POST", REST_PATH, null, com.google.api.services.androidpublisher.model.DeobfuscationFilesUploadResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.apkVersionCode = com.google.api.client.util.Preconditions.checkNotNull(apkVersionCode, "Required parameter apkVersionCode must be specified.");
          this.deobfuscationFileType = com.google.api.client.util.Preconditions.checkNotNull(deobfuscationFileType, "Required parameter deobfuscationFileType must be specified.");
        }

        /**
         * Uploads a new deobfuscation file and attaches to the specified APK.
         *
         * Create a request for the method "deobfuscationfiles.upload".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param packageName Unique identifier for the Android app.@param editId Unique identifier for this edit.@param apkVersionCode The version code of the APK whose Deobfuscation File is being
      uploaded.@param deobfuscationFileType The type of the deobfuscation file.
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Upload(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String deobfuscationFileType, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(AndroidPublisher.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.androidpublisher.model.DeobfuscationFilesUploadResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.apkVersionCode = com.google.api.client.util.Preconditions.checkNotNull(apkVersionCode, "Required parameter apkVersionCode must be specified.");
          this.deobfuscationFileType = com.google.api.client.util.Preconditions.checkNotNull(deobfuscationFileType, "Required parameter deobfuscationFileType must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Upload set$Xgafv(java.lang.String $Xgafv) {
          return (Upload) super.set$Xgafv($Xgafv);
        }

        @Override
        public Upload setAccessToken(java.lang.String accessToken) {
          return (Upload) super.setAccessToken(accessToken);
        }

        @Override
        public Upload setAlt(java.lang.String alt) {
          return (Upload) super.setAlt(alt);
        }

        @Override
        public Upload setCallback(java.lang.String callback) {
          return (Upload) super.setCallback(callback);
        }

        @Override
        public Upload setFields(java.lang.String fields) {
          return (Upload) super.setFields(fields);
        }

        @Override
        public Upload setKey(java.lang.String key) {
          return (Upload) super.setKey(key);
        }

        @Override
        public Upload setOauthToken(java.lang.String oauthToken) {
          return (Upload) super.setOauthToken(oauthToken);
        }

        @Override
        public Upload setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Upload) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Upload setQuotaUser(java.lang.String quotaUser) {
          return (Upload) super.setQuotaUser(quotaUser);
        }

        @Override
        public Upload setUploadType(java.lang.String uploadType) {
          return (Upload) super.setUploadType(uploadType);
        }

        @Override
        public Upload setUploadProtocol(java.lang.String uploadProtocol) {
          return (Upload) super.setUploadProtocol(uploadProtocol);
        }

        /** Unique identifier for the Android app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Unique identifier for the Android app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Unique identifier for the Android app. */
        public Upload setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Unique identifier for this edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Unique identifier for this edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Unique identifier for this edit. */
        public Upload setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * The version code of the APK whose Deobfuscation File is being uploaded.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer apkVersionCode;

        /** The version code of the APK whose Deobfuscation File is being uploaded.
         */
        public java.lang.Integer getApkVersionCode() {
          return apkVersionCode;
        }

        /**
         * The version code of the APK whose Deobfuscation File is being uploaded.
         */
        public Upload setApkVersionCode(java.lang.Integer apkVersionCode) {
          this.apkVersionCode = apkVersionCode;
          return this;
        }

        /** The type of the deobfuscation file. */
        @com.google.api.client.util.Key
        private java.lang.String deobfuscationFileType;

        /** The type of the deobfuscation file.
         */
        public java.lang.String getDeobfuscationFileType() {
          return deobfuscationFileType;
        }

        /** The type of the deobfuscation file. */
        public Upload setDeobfuscationFileType(java.lang.String deobfuscationFileType) {
          this.deobfuscationFileType = deobfuscationFileType;
          return this;
        }

        @Override
        public Upload set(String parameterName, Object value) {
          return (Upload) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Details collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Details.List request = androidpublisher.details().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Details details() {
      return new Details();
    }

    /**
     * The "details" collection of methods.
     */
    public class Details {

      /**
       * Gets details of an app.
       *
       * Create a request for the method "details.get".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @return the request
       */
      public Get get(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
        Get result = new Get(packageName, editId);
        initialize(result);
        return result;
      }

      public class Get extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.AppDetails> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/details";

        /**
         * Gets details of an app.
         *
         * Create a request for the method "details.get".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @since 1.13
         */
        protected Get(java.lang.String packageName, java.lang.String editId) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.AppDetails.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Get setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Get setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Patches details of an app.
       *
       * Create a request for the method "details.patch".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param content the {@link com.google.api.services.androidpublisher.model.AppDetails}
       * @return the request
       */
      public Patch patch(java.lang.String packageName, java.lang.String editId, com.google.api.services.androidpublisher.model.AppDetails content) throws java.io.IOException {
        Patch result = new Patch(packageName, editId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.AppDetails> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/details";

        /**
         * Patches details of an app.
         *
         * Create a request for the method "details.patch".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param content the {@link com.google.api.services.androidpublisher.model.AppDetails}
         * @since 1.13
         */
        protected Patch(java.lang.String packageName, java.lang.String editId, com.google.api.services.androidpublisher.model.AppDetails content) {
          super(AndroidPublisher.this, "PATCH", REST_PATH, content, com.google.api.services.androidpublisher.model.AppDetails.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Patch setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Patch setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates details of an app.
       *
       * Create a request for the method "details.update".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param content the {@link com.google.api.services.androidpublisher.model.AppDetails}
       * @return the request
       */
      public Update update(java.lang.String packageName, java.lang.String editId, com.google.api.services.androidpublisher.model.AppDetails content) throws java.io.IOException {
        Update result = new Update(packageName, editId, content);
        initialize(result);
        return result;
      }

      public class Update extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.AppDetails> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/details";

        /**
         * Updates details of an app.
         *
         * Create a request for the method "details.update".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param content the {@link com.google.api.services.androidpublisher.model.AppDetails}
         * @since 1.13
         */
        protected Update(java.lang.String packageName, java.lang.String editId, com.google.api.services.androidpublisher.model.AppDetails content) {
          super(AndroidPublisher.this, "PUT", REST_PATH, content, com.google.api.services.androidpublisher.model.AppDetails.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Update setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Update setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Expansionfiles collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Expansionfiles.List request = androidpublisher.expansionfiles().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Expansionfiles expansionfiles() {
      return new Expansionfiles();
    }

    /**
     * The "expansionfiles" collection of methods.
     */
    public class Expansionfiles {

      /**
       * Fetches the expansion file configuration for the specified APK.
       *
       * Create a request for the method "expansionfiles.get".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param apkVersionCode The version code of the APK whose expansion file configuration is being
      read or modified.
       * @param expansionFileType The file type of the file configuration which is being read or modified.
       * @return the request
       */
      public Get get(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String expansionFileType) throws java.io.IOException {
        Get result = new Get(packageName, editId, apkVersionCode, expansionFileType);
        initialize(result);
        return result;
      }

      public class Get extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ExpansionFile> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";

        /**
         * Fetches the expansion file configuration for the specified APK.
         *
         * Create a request for the method "expansionfiles.get".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param apkVersionCode The version code of the APK whose expansion file configuration is being
      read or modified.
         * @param expansionFileType The file type of the file configuration which is being read or modified.
         * @since 1.13
         */
        protected Get(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String expansionFileType) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.ExpansionFile.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.apkVersionCode = com.google.api.client.util.Preconditions.checkNotNull(apkVersionCode, "Required parameter apkVersionCode must be specified.");
          this.expansionFileType = com.google.api.client.util.Preconditions.checkNotNull(expansionFileType, "Required parameter expansionFileType must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Get setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Get setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * The version code of the APK whose expansion file configuration is being read or modified.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer apkVersionCode;

        /** The version code of the APK whose expansion file configuration is being read or modified.
         */
        public java.lang.Integer getApkVersionCode() {
          return apkVersionCode;
        }

        /**
         * The version code of the APK whose expansion file configuration is being read or modified.
         */
        public Get setApkVersionCode(java.lang.Integer apkVersionCode) {
          this.apkVersionCode = apkVersionCode;
          return this;
        }

        /** The file type of the file configuration which is being read or modified. */
        @com.google.api.client.util.Key
        private java.lang.String expansionFileType;

        /** The file type of the file configuration which is being read or modified.
         */
        public java.lang.String getExpansionFileType() {
          return expansionFileType;
        }

        /** The file type of the file configuration which is being read or modified. */
        public Get setExpansionFileType(java.lang.String expansionFileType) {
          this.expansionFileType = expansionFileType;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Patches the APK's expansion file configuration to reference another APK's expansion file. To add
       * a new expansion file use the Upload method.
       *
       * Create a request for the method "expansionfiles.patch".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param apkVersionCode The version code of the APK whose expansion file configuration is being
      read or modified.
       * @param expansionFileType The file type of the expansion file configuration which is being updated.
       * @param content the {@link com.google.api.services.androidpublisher.model.ExpansionFile}
       * @return the request
       */
      public Patch patch(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String expansionFileType, com.google.api.services.androidpublisher.model.ExpansionFile content) throws java.io.IOException {
        Patch result = new Patch(packageName, editId, apkVersionCode, expansionFileType, content);
        initialize(result);
        return result;
      }

      public class Patch extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ExpansionFile> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";

        /**
         * Patches the APK's expansion file configuration to reference another APK's expansion file. To
         * add a new expansion file use the Upload method.
         *
         * Create a request for the method "expansionfiles.patch".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param apkVersionCode The version code of the APK whose expansion file configuration is being
      read or modified.
         * @param expansionFileType The file type of the expansion file configuration which is being updated.
         * @param content the {@link com.google.api.services.androidpublisher.model.ExpansionFile}
         * @since 1.13
         */
        protected Patch(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String expansionFileType, com.google.api.services.androidpublisher.model.ExpansionFile content) {
          super(AndroidPublisher.this, "PATCH", REST_PATH, content, com.google.api.services.androidpublisher.model.ExpansionFile.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.apkVersionCode = com.google.api.client.util.Preconditions.checkNotNull(apkVersionCode, "Required parameter apkVersionCode must be specified.");
          this.expansionFileType = com.google.api.client.util.Preconditions.checkNotNull(expansionFileType, "Required parameter expansionFileType must be specified.");
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Patch setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Patch setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * The version code of the APK whose expansion file configuration is being read or modified.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer apkVersionCode;

        /** The version code of the APK whose expansion file configuration is being read or modified.
         */
        public java.lang.Integer getApkVersionCode() {
          return apkVersionCode;
        }

        /**
         * The version code of the APK whose expansion file configuration is being read or modified.
         */
        public Patch setApkVersionCode(java.lang.Integer apkVersionCode) {
          this.apkVersionCode = apkVersionCode;
          return this;
        }

        /** The file type of the expansion file configuration which is being updated. */
        @com.google.api.client.util.Key
        private java.lang.String expansionFileType;

        /** The file type of the expansion file configuration which is being updated.
         */
        public java.lang.String getExpansionFileType() {
          return expansionFileType;
        }

        /** The file type of the expansion file configuration which is being updated. */
        public Patch setExpansionFileType(java.lang.String expansionFileType) {
          this.expansionFileType = expansionFileType;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates the APK's expansion file configuration to reference another APK's expansion file. To add
       * a new expansion file use the Upload method.
       *
       * Create a request for the method "expansionfiles.update".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param apkVersionCode The version code of the APK whose expansion file configuration is being
      read or modified.
       * @param expansionFileType The file type of the file configuration which is being read or modified.
       * @param content the {@link com.google.api.services.androidpublisher.model.ExpansionFile}
       * @return the request
       */
      public Update update(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String expansionFileType, com.google.api.services.androidpublisher.model.ExpansionFile content) throws java.io.IOException {
        Update result = new Update(packageName, editId, apkVersionCode, expansionFileType, content);
        initialize(result);
        return result;
      }

      public class Update extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ExpansionFile> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";

        /**
         * Updates the APK's expansion file configuration to reference another APK's expansion file. To
         * add a new expansion file use the Upload method.
         *
         * Create a request for the method "expansionfiles.update".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param apkVersionCode The version code of the APK whose expansion file configuration is being
      read or modified.
         * @param expansionFileType The file type of the file configuration which is being read or modified.
         * @param content the {@link com.google.api.services.androidpublisher.model.ExpansionFile}
         * @since 1.13
         */
        protected Update(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String expansionFileType, com.google.api.services.androidpublisher.model.ExpansionFile content) {
          super(AndroidPublisher.this, "PUT", REST_PATH, content, com.google.api.services.androidpublisher.model.ExpansionFile.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.apkVersionCode = com.google.api.client.util.Preconditions.checkNotNull(apkVersionCode, "Required parameter apkVersionCode must be specified.");
          this.expansionFileType = com.google.api.client.util.Preconditions.checkNotNull(expansionFileType, "Required parameter expansionFileType must be specified.");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Update setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Update setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * The version code of the APK whose expansion file configuration is being read or modified.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer apkVersionCode;

        /** The version code of the APK whose expansion file configuration is being read or modified.
         */
        public java.lang.Integer getApkVersionCode() {
          return apkVersionCode;
        }

        /**
         * The version code of the APK whose expansion file configuration is being read or modified.
         */
        public Update setApkVersionCode(java.lang.Integer apkVersionCode) {
          this.apkVersionCode = apkVersionCode;
          return this;
        }

        /** The file type of the file configuration which is being read or modified. */
        @com.google.api.client.util.Key
        private java.lang.String expansionFileType;

        /** The file type of the file configuration which is being read or modified.
         */
        public java.lang.String getExpansionFileType() {
          return expansionFileType;
        }

        /** The file type of the file configuration which is being read or modified. */
        public Update setExpansionFileType(java.lang.String expansionFileType) {
          this.expansionFileType = expansionFileType;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }
      /**
       * Uploads a new expansion file and attaches to the specified APK.
       *
       * Create a request for the method "expansionfiles.upload".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param apkVersionCode The version code of the APK whose expansion file configuration is being
      read or modified.
       * @param expansionFileType The file type of the expansion file configuration which is being updated.
       * @return the request
       */
      public Upload upload(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String expansionFileType) throws java.io.IOException {
        Upload result = new Upload(packageName, editId, apkVersionCode, expansionFileType);
        initialize(result);
        return result;
      }

      /**
       * Uploads a new expansion file and attaches to the specified APK.
       *
       * Create a request for the method "expansionfiles.upload".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param packageName Package name of the app.@param editId Identifier of the edit.@param apkVersionCode The version code of the APK whose expansion file configuration is being
      read or modified.@param expansionFileType The file type of the expansion file configuration which is being updated.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Upload upload(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String expansionFileType, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Upload result = new Upload(packageName, editId, apkVersionCode, expansionFileType, mediaContent);
        initialize(result);
        return result;
      }

      public class Upload extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ExpansionFilesUploadResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";

        /**
         * Uploads a new expansion file and attaches to the specified APK.
         *
         * Create a request for the method "expansionfiles.upload".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param apkVersionCode The version code of the APK whose expansion file configuration is being
      read or modified.
         * @param expansionFileType The file type of the expansion file configuration which is being updated.
         * @since 1.13
         */
        protected Upload(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String expansionFileType) {
          super(AndroidPublisher.this, "POST", REST_PATH, null, com.google.api.services.androidpublisher.model.ExpansionFilesUploadResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.apkVersionCode = com.google.api.client.util.Preconditions.checkNotNull(apkVersionCode, "Required parameter apkVersionCode must be specified.");
          this.expansionFileType = com.google.api.client.util.Preconditions.checkNotNull(expansionFileType, "Required parameter expansionFileType must be specified.");
        }

        /**
         * Uploads a new expansion file and attaches to the specified APK.
         *
         * Create a request for the method "expansionfiles.upload".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param packageName Package name of the app.@param editId Identifier of the edit.@param apkVersionCode The version code of the APK whose expansion file configuration is being
      read or modified.@param expansionFileType The file type of the expansion file configuration which is being updated.
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Upload(java.lang.String packageName, java.lang.String editId, java.lang.Integer apkVersionCode, java.lang.String expansionFileType, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(AndroidPublisher.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.androidpublisher.model.ExpansionFilesUploadResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.apkVersionCode = com.google.api.client.util.Preconditions.checkNotNull(apkVersionCode, "Required parameter apkVersionCode must be specified.");
          this.expansionFileType = com.google.api.client.util.Preconditions.checkNotNull(expansionFileType, "Required parameter expansionFileType must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Upload set$Xgafv(java.lang.String $Xgafv) {
          return (Upload) super.set$Xgafv($Xgafv);
        }

        @Override
        public Upload setAccessToken(java.lang.String accessToken) {
          return (Upload) super.setAccessToken(accessToken);
        }

        @Override
        public Upload setAlt(java.lang.String alt) {
          return (Upload) super.setAlt(alt);
        }

        @Override
        public Upload setCallback(java.lang.String callback) {
          return (Upload) super.setCallback(callback);
        }

        @Override
        public Upload setFields(java.lang.String fields) {
          return (Upload) super.setFields(fields);
        }

        @Override
        public Upload setKey(java.lang.String key) {
          return (Upload) super.setKey(key);
        }

        @Override
        public Upload setOauthToken(java.lang.String oauthToken) {
          return (Upload) super.setOauthToken(oauthToken);
        }

        @Override
        public Upload setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Upload) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Upload setQuotaUser(java.lang.String quotaUser) {
          return (Upload) super.setQuotaUser(quotaUser);
        }

        @Override
        public Upload setUploadType(java.lang.String uploadType) {
          return (Upload) super.setUploadType(uploadType);
        }

        @Override
        public Upload setUploadProtocol(java.lang.String uploadProtocol) {
          return (Upload) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Upload setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Upload setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * The version code of the APK whose expansion file configuration is being read or modified.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer apkVersionCode;

        /** The version code of the APK whose expansion file configuration is being read or modified.
         */
        public java.lang.Integer getApkVersionCode() {
          return apkVersionCode;
        }

        /**
         * The version code of the APK whose expansion file configuration is being read or modified.
         */
        public Upload setApkVersionCode(java.lang.Integer apkVersionCode) {
          this.apkVersionCode = apkVersionCode;
          return this;
        }

        /** The file type of the expansion file configuration which is being updated. */
        @com.google.api.client.util.Key
        private java.lang.String expansionFileType;

        /** The file type of the expansion file configuration which is being updated.
         */
        public java.lang.String getExpansionFileType() {
          return expansionFileType;
        }

        /** The file type of the expansion file configuration which is being updated. */
        public Upload setExpansionFileType(java.lang.String expansionFileType) {
          this.expansionFileType = expansionFileType;
          return this;
        }

        @Override
        public Upload set(String parameterName, Object value) {
          return (Upload) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Images collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Images.List request = androidpublisher.images().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Images images() {
      return new Images();
    }

    /**
     * The "images" collection of methods.
     */
    public class Images {

      /**
       * Deletes the image (specified by id) from the edit.
       *
       * Create a request for the method "images.delete".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
       * @param imageType Type of the Image.
       * @param imageId Unique identifier an image within the set of images attached to this edit.
       * @return the request
       */
      public Delete delete(java.lang.String packageName, java.lang.String editId, java.lang.String language, java.lang.String imageType, java.lang.String imageId) throws java.io.IOException {
        Delete result = new Delete(packageName, editId, language, imageType, imageId);
        initialize(result);
        return result;
      }

      public class Delete extends AndroidPublisherRequest<Void> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}/{imageId}";

        /**
         * Deletes the image (specified by id) from the edit.
         *
         * Create a request for the method "images.delete".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
         * @param imageType Type of the Image.
         * @param imageId Unique identifier an image within the set of images attached to this edit.
         * @since 1.13
         */
        protected Delete(java.lang.String packageName, java.lang.String editId, java.lang.String language, java.lang.String imageType, java.lang.String imageId) {
          super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.language = com.google.api.client.util.Preconditions.checkNotNull(language, "Required parameter language must be specified.");
          this.imageType = com.google.api.client.util.Preconditions.checkNotNull(imageType, "Required parameter imageType must be specified.");
          this.imageId = com.google.api.client.util.Preconditions.checkNotNull(imageId, "Required parameter imageId must be specified.");
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Delete setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Delete setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German).
         */
        @com.google.api.client.util.Key
        private java.lang.String language;

        /** Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian German).
         */
        public java.lang.String getLanguage() {
          return language;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German).
         */
        public Delete setLanguage(java.lang.String language) {
          this.language = language;
          return this;
        }

        /** Type of the Image. */
        @com.google.api.client.util.Key
        private java.lang.String imageType;

        /** Type of the Image.
         */
        public java.lang.String getImageType() {
          return imageType;
        }

        /** Type of the Image. */
        public Delete setImageType(java.lang.String imageType) {
          this.imageType = imageType;
          return this;
        }

        /** Unique identifier an image within the set of images attached to this edit. */
        @com.google.api.client.util.Key
        private java.lang.String imageId;

        /** Unique identifier an image within the set of images attached to this edit.
         */
        public java.lang.String getImageId() {
          return imageId;
        }

        /** Unique identifier an image within the set of images attached to this edit. */
        public Delete setImageId(java.lang.String imageId) {
          this.imageId = imageId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Deletes all images for the specified language and image type. Returns an empty response if no
       * images are found.
       *
       * Create a request for the method "images.deleteall".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Deleteall#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
       *        Providing a language that is not supported by the App is a no-op.
       * @param imageType Type of the Image.
      Providing an image type that refers to no images is a no-op.
       * @return the request
       */
      public Deleteall deleteall(java.lang.String packageName, java.lang.String editId, java.lang.String language, java.lang.String imageType) throws java.io.IOException {
        Deleteall result = new Deleteall(packageName, editId, language, imageType);
        initialize(result);
        return result;
      }

      public class Deleteall extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ImagesDeleteAllResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}";

        /**
         * Deletes all images for the specified language and image type. Returns an empty response if no
         * images are found.
         *
         * Create a request for the method "images.deleteall".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Deleteall#execute()} method to invoke the remote
         * operation. <p> {@link
         * Deleteall#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
       *        Providing a language that is not supported by the App is a no-op.
         * @param imageType Type of the Image.
      Providing an image type that refers to no images is a no-op.
         * @since 1.13
         */
        protected Deleteall(java.lang.String packageName, java.lang.String editId, java.lang.String language, java.lang.String imageType) {
          super(AndroidPublisher.this, "DELETE", REST_PATH, null, com.google.api.services.androidpublisher.model.ImagesDeleteAllResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.language = com.google.api.client.util.Preconditions.checkNotNull(language, "Required parameter language must be specified.");
          this.imageType = com.google.api.client.util.Preconditions.checkNotNull(imageType, "Required parameter imageType must be specified.");
        }

        @Override
        public Deleteall set$Xgafv(java.lang.String $Xgafv) {
          return (Deleteall) super.set$Xgafv($Xgafv);
        }

        @Override
        public Deleteall setAccessToken(java.lang.String accessToken) {
          return (Deleteall) super.setAccessToken(accessToken);
        }

        @Override
        public Deleteall setAlt(java.lang.String alt) {
          return (Deleteall) super.setAlt(alt);
        }

        @Override
        public Deleteall setCallback(java.lang.String callback) {
          return (Deleteall) super.setCallback(callback);
        }

        @Override
        public Deleteall setFields(java.lang.String fields) {
          return (Deleteall) super.setFields(fields);
        }

        @Override
        public Deleteall setKey(java.lang.String key) {
          return (Deleteall) super.setKey(key);
        }

        @Override
        public Deleteall setOauthToken(java.lang.String oauthToken) {
          return (Deleteall) super.setOauthToken(oauthToken);
        }

        @Override
        public Deleteall setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Deleteall) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Deleteall setQuotaUser(java.lang.String quotaUser) {
          return (Deleteall) super.setQuotaUser(quotaUser);
        }

        @Override
        public Deleteall setUploadType(java.lang.String uploadType) {
          return (Deleteall) super.setUploadType(uploadType);
        }

        @Override
        public Deleteall setUploadProtocol(java.lang.String uploadProtocol) {
          return (Deleteall) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Deleteall setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Deleteall setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German). Providing a language that is not supported by the App is a no-op.
         */
        @com.google.api.client.util.Key
        private java.lang.String language;

        /** Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian German).
       Providing a language that is not supported by the App is a no-op.
         */
        public java.lang.String getLanguage() {
          return language;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German). Providing a language that is not supported by the App is a no-op.
         */
        public Deleteall setLanguage(java.lang.String language) {
          this.language = language;
          return this;
        }

        /**
         * Type of the Image. Providing an image type that refers to no images is a no-op.
         */
        @com.google.api.client.util.Key
        private java.lang.String imageType;

        /** Type of the Image. Providing an image type that refers to no images is a no-op.
         */
        public java.lang.String getImageType() {
          return imageType;
        }

        /**
         * Type of the Image. Providing an image type that refers to no images is a no-op.
         */
        public Deleteall setImageType(java.lang.String imageType) {
          this.imageType = imageType;
          return this;
        }

        @Override
        public Deleteall set(String parameterName, Object value) {
          return (Deleteall) super.set(parameterName, value);
        }
      }
      /**
       * Lists all images. The response may be empty.
       *
       * Create a request for the method "images.list".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
      There
       *        must be a store listing for the specified language.
       * @param imageType Type of the Image. Providing an image type that refers to no images will
      return an empty response.
       * @return the request
       */
      public List list(java.lang.String packageName, java.lang.String editId, java.lang.String language, java.lang.String imageType) throws java.io.IOException {
        List result = new List(packageName, editId, language, imageType);
        initialize(result);
        return result;
      }

      public class List extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ImagesListResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}";

        /**
         * Lists all images. The response may be empty.
         *
         * Create a request for the method "images.list".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
      There
       *        must be a store listing for the specified language.
         * @param imageType Type of the Image. Providing an image type that refers to no images will
      return an empty response.
         * @since 1.13
         */
        protected List(java.lang.String packageName, java.lang.String editId, java.lang.String language, java.lang.String imageType) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.ImagesListResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.language = com.google.api.client.util.Preconditions.checkNotNull(language, "Required parameter language must be specified.");
          this.imageType = com.google.api.client.util.Preconditions.checkNotNull(imageType, "Required parameter imageType must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public List setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public List setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German). There must be a store listing for the specified language.
         */
        @com.google.api.client.util.Key
        private java.lang.String language;

        /** Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian German). There
       must be a store listing for the specified language.
         */
        public java.lang.String getLanguage() {
          return language;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German). There must be a store listing for the specified language.
         */
        public List setLanguage(java.lang.String language) {
          this.language = language;
          return this;
        }

        /**
         * Type of the Image. Providing an image type that refers to no images will return an empty
         * response.
         */
        @com.google.api.client.util.Key
        private java.lang.String imageType;

        /** Type of the Image. Providing an image type that refers to no images will return an empty response.
         */
        public java.lang.String getImageType() {
          return imageType;
        }

        /**
         * Type of the Image. Providing an image type that refers to no images will return an empty
         * response.
         */
        public List setImageType(java.lang.String imageType) {
          this.imageType = imageType;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Uploads an image of the specified language and image type, and adds to the edit.
       *
       * Create a request for the method "images.upload".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
       *        Providing a language that is not supported by the App is a no-op.
       * @param imageType Type of the Image.
       * @return the request
       */
      public Upload upload(java.lang.String packageName, java.lang.String editId, java.lang.String language, java.lang.String imageType) throws java.io.IOException {
        Upload result = new Upload(packageName, editId, language, imageType);
        initialize(result);
        return result;
      }

      /**
       * Uploads an image of the specified language and image type, and adds to the edit.
       *
       * Create a request for the method "images.upload".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param packageName Package name of the app.@param editId Identifier of the edit.@param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
       *        Providing a language that is not supported by the App is a no-op.@param imageType Type of the Image.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Upload upload(java.lang.String packageName, java.lang.String editId, java.lang.String language, java.lang.String imageType, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Upload result = new Upload(packageName, editId, language, imageType, mediaContent);
        initialize(result);
        return result;
      }

      public class Upload extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ImagesUploadResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}";

        /**
         * Uploads an image of the specified language and image type, and adds to the edit.
         *
         * Create a request for the method "images.upload".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
       *        Providing a language that is not supported by the App is a no-op.
         * @param imageType Type of the Image.
         * @since 1.13
         */
        protected Upload(java.lang.String packageName, java.lang.String editId, java.lang.String language, java.lang.String imageType) {
          super(AndroidPublisher.this, "POST", REST_PATH, null, com.google.api.services.androidpublisher.model.ImagesUploadResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.language = com.google.api.client.util.Preconditions.checkNotNull(language, "Required parameter language must be specified.");
          this.imageType = com.google.api.client.util.Preconditions.checkNotNull(imageType, "Required parameter imageType must be specified.");
        }

        /**
         * Uploads an image of the specified language and image type, and adds to the edit.
         *
         * Create a request for the method "images.upload".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param packageName Package name of the app.@param editId Identifier of the edit.@param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
       *        Providing a language that is not supported by the App is a no-op.@param imageType Type of the Image.
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Upload(java.lang.String packageName, java.lang.String editId, java.lang.String language, java.lang.String imageType, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(AndroidPublisher.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.androidpublisher.model.ImagesUploadResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.language = com.google.api.client.util.Preconditions.checkNotNull(language, "Required parameter language must be specified.");
          this.imageType = com.google.api.client.util.Preconditions.checkNotNull(imageType, "Required parameter imageType must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Upload set$Xgafv(java.lang.String $Xgafv) {
          return (Upload) super.set$Xgafv($Xgafv);
        }

        @Override
        public Upload setAccessToken(java.lang.String accessToken) {
          return (Upload) super.setAccessToken(accessToken);
        }

        @Override
        public Upload setAlt(java.lang.String alt) {
          return (Upload) super.setAlt(alt);
        }

        @Override
        public Upload setCallback(java.lang.String callback) {
          return (Upload) super.setCallback(callback);
        }

        @Override
        public Upload setFields(java.lang.String fields) {
          return (Upload) super.setFields(fields);
        }

        @Override
        public Upload setKey(java.lang.String key) {
          return (Upload) super.setKey(key);
        }

        @Override
        public Upload setOauthToken(java.lang.String oauthToken) {
          return (Upload) super.setOauthToken(oauthToken);
        }

        @Override
        public Upload setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Upload) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Upload setQuotaUser(java.lang.String quotaUser) {
          return (Upload) super.setQuotaUser(quotaUser);
        }

        @Override
        public Upload setUploadType(java.lang.String uploadType) {
          return (Upload) super.setUploadType(uploadType);
        }

        @Override
        public Upload setUploadProtocol(java.lang.String uploadProtocol) {
          return (Upload) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Upload setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Upload setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German). Providing a language that is not supported by the App is a no-op.
         */
        @com.google.api.client.util.Key
        private java.lang.String language;

        /** Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian German).
       Providing a language that is not supported by the App is a no-op.
         */
        public java.lang.String getLanguage() {
          return language;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German). Providing a language that is not supported by the App is a no-op.
         */
        public Upload setLanguage(java.lang.String language) {
          this.language = language;
          return this;
        }

        /** Type of the Image. */
        @com.google.api.client.util.Key
        private java.lang.String imageType;

        /** Type of the Image.
         */
        public java.lang.String getImageType() {
          return imageType;
        }

        /** Type of the Image. */
        public Upload setImageType(java.lang.String imageType) {
          this.imageType = imageType;
          return this;
        }

        @Override
        public Upload set(String parameterName, Object value) {
          return (Upload) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Listings collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Listings.List request = androidpublisher.listings().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Listings listings() {
      return new Listings();
    }

    /**
     * The "listings" collection of methods.
     */
    public class Listings {

      /**
       * Deletes a localized store listing.
       *
       * Create a request for the method "listings.delete".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
       * @return the request
       */
      public Delete delete(java.lang.String packageName, java.lang.String editId, java.lang.String language) throws java.io.IOException {
        Delete result = new Delete(packageName, editId, language);
        initialize(result);
        return result;
      }

      public class Delete extends AndroidPublisherRequest<Void> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}";

        /**
         * Deletes a localized store listing.
         *
         * Create a request for the method "listings.delete".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
         * @since 1.13
         */
        protected Delete(java.lang.String packageName, java.lang.String editId, java.lang.String language) {
          super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.language = com.google.api.client.util.Preconditions.checkNotNull(language, "Required parameter language must be specified.");
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Delete setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Delete setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German).
         */
        @com.google.api.client.util.Key
        private java.lang.String language;

        /** Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian German).
         */
        public java.lang.String getLanguage() {
          return language;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German).
         */
        public Delete setLanguage(java.lang.String language) {
          this.language = language;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Deletes all store listings.
       *
       * Create a request for the method "listings.deleteall".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Deleteall#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @return the request
       */
      public Deleteall deleteall(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
        Deleteall result = new Deleteall(packageName, editId);
        initialize(result);
        return result;
      }

      public class Deleteall extends AndroidPublisherRequest<Void> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings";

        /**
         * Deletes all store listings.
         *
         * Create a request for the method "listings.deleteall".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Deleteall#execute()} method to invoke the remote
         * operation. <p> {@link
         * Deleteall#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @since 1.13
         */
        protected Deleteall(java.lang.String packageName, java.lang.String editId) {
          super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
        }

        @Override
        public Deleteall set$Xgafv(java.lang.String $Xgafv) {
          return (Deleteall) super.set$Xgafv($Xgafv);
        }

        @Override
        public Deleteall setAccessToken(java.lang.String accessToken) {
          return (Deleteall) super.setAccessToken(accessToken);
        }

        @Override
        public Deleteall setAlt(java.lang.String alt) {
          return (Deleteall) super.setAlt(alt);
        }

        @Override
        public Deleteall setCallback(java.lang.String callback) {
          return (Deleteall) super.setCallback(callback);
        }

        @Override
        public Deleteall setFields(java.lang.String fields) {
          return (Deleteall) super.setFields(fields);
        }

        @Override
        public Deleteall setKey(java.lang.String key) {
          return (Deleteall) super.setKey(key);
        }

        @Override
        public Deleteall setOauthToken(java.lang.String oauthToken) {
          return (Deleteall) super.setOauthToken(oauthToken);
        }

        @Override
        public Deleteall setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Deleteall) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Deleteall setQuotaUser(java.lang.String quotaUser) {
          return (Deleteall) super.setQuotaUser(quotaUser);
        }

        @Override
        public Deleteall setUploadType(java.lang.String uploadType) {
          return (Deleteall) super.setUploadType(uploadType);
        }

        @Override
        public Deleteall setUploadProtocol(java.lang.String uploadProtocol) {
          return (Deleteall) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Deleteall setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Deleteall setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        @Override
        public Deleteall set(String parameterName, Object value) {
          return (Deleteall) super.set(parameterName, value);
        }
      }
      /**
       * Gets a localized store listing.
       *
       * Create a request for the method "listings.get".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
       * @return the request
       */
      public Get get(java.lang.String packageName, java.lang.String editId, java.lang.String language) throws java.io.IOException {
        Get result = new Get(packageName, editId, language);
        initialize(result);
        return result;
      }

      public class Get extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Listing> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}";

        /**
         * Gets a localized store listing.
         *
         * Create a request for the method "listings.get".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
         * @since 1.13
         */
        protected Get(java.lang.String packageName, java.lang.String editId, java.lang.String language) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.Listing.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.language = com.google.api.client.util.Preconditions.checkNotNull(language, "Required parameter language must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Get setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Get setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German).
         */
        @com.google.api.client.util.Key
        private java.lang.String language;

        /** Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian German).
         */
        public java.lang.String getLanguage() {
          return language;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German).
         */
        public Get setLanguage(java.lang.String language) {
          this.language = language;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists all localized store listings.
       *
       * Create a request for the method "listings.list".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @return the request
       */
      public List list(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
        List result = new List(packageName, editId);
        initialize(result);
        return result;
      }

      public class List extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ListingsListResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings";

        /**
         * Lists all localized store listings.
         *
         * Create a request for the method "listings.list".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @since 1.13
         */
        protected List(java.lang.String packageName, java.lang.String editId) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.ListingsListResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public List setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public List setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Patches a localized store listing.
       *
       * Create a request for the method "listings.patch".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
       * @param content the {@link com.google.api.services.androidpublisher.model.Listing}
       * @return the request
       */
      public Patch patch(java.lang.String packageName, java.lang.String editId, java.lang.String language, com.google.api.services.androidpublisher.model.Listing content) throws java.io.IOException {
        Patch result = new Patch(packageName, editId, language, content);
        initialize(result);
        return result;
      }

      public class Patch extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Listing> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}";

        /**
         * Patches a localized store listing.
         *
         * Create a request for the method "listings.patch".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
         * @param content the {@link com.google.api.services.androidpublisher.model.Listing}
         * @since 1.13
         */
        protected Patch(java.lang.String packageName, java.lang.String editId, java.lang.String language, com.google.api.services.androidpublisher.model.Listing content) {
          super(AndroidPublisher.this, "PATCH", REST_PATH, content, com.google.api.services.androidpublisher.model.Listing.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.language = com.google.api.client.util.Preconditions.checkNotNull(language, "Required parameter language must be specified.");
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Patch setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Patch setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German).
         */
        @com.google.api.client.util.Key
        private java.lang.String language;

        /** Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian German).
         */
        public java.lang.String getLanguage() {
          return language;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German).
         */
        public Patch setLanguage(java.lang.String language) {
          this.language = language;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Creates or updates a localized store listing.
       *
       * Create a request for the method "listings.update".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
       * @param content the {@link com.google.api.services.androidpublisher.model.Listing}
       * @return the request
       */
      public Update update(java.lang.String packageName, java.lang.String editId, java.lang.String language, com.google.api.services.androidpublisher.model.Listing content) throws java.io.IOException {
        Update result = new Update(packageName, editId, language, content);
        initialize(result);
        return result;
      }

      public class Update extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Listing> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}";

        /**
         * Creates or updates a localized store listing.
         *
         * Create a request for the method "listings.update".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param language Language localization code (a BCP-47 language tag; for example, "de-AT"
      for Austrian German).
         * @param content the {@link com.google.api.services.androidpublisher.model.Listing}
         * @since 1.13
         */
        protected Update(java.lang.String packageName, java.lang.String editId, java.lang.String language, com.google.api.services.androidpublisher.model.Listing content) {
          super(AndroidPublisher.this, "PUT", REST_PATH, content, com.google.api.services.androidpublisher.model.Listing.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.language = com.google.api.client.util.Preconditions.checkNotNull(language, "Required parameter language must be specified.");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Update setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Update setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German).
         */
        @com.google.api.client.util.Key
        private java.lang.String language;

        /** Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian German).
         */
        public java.lang.String getLanguage() {
          return language;
        }

        /**
         * Language localization code (a BCP-47 language tag; for example, "de-AT" for Austrian
         * German).
         */
        public Update setLanguage(java.lang.String language) {
          this.language = language;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Testers collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Testers.List request = androidpublisher.testers().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Testers testers() {
      return new Testers();
    }

    /**
     * The "testers" collection of methods.
     */
    public class Testers {

      /**
       * Gets testers.
       *
       * Create a request for the method "testers.get".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param track The track to read from.
       * @return the request
       */
      public Get get(java.lang.String packageName, java.lang.String editId, java.lang.String track) throws java.io.IOException {
        Get result = new Get(packageName, editId, track);
        initialize(result);
        return result;
      }

      public class Get extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}";

        /**
         * Gets testers.
         *
         * Create a request for the method "testers.get".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param track The track to read from.
         * @since 1.13
         */
        protected Get(java.lang.String packageName, java.lang.String editId, java.lang.String track) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.Testers.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.track = com.google.api.client.util.Preconditions.checkNotNull(track, "Required parameter track must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Get setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Get setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /** The track to read from. */
        @com.google.api.client.util.Key
        private java.lang.String track;

        /** The track to read from.
         */
        public java.lang.String getTrack() {
          return track;
        }

        /** The track to read from. */
        public Get setTrack(java.lang.String track) {
          this.track = track;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Patches testers.
       *
       * Create a request for the method "testers.patch".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param track The track to update.
       * @param content the {@link com.google.api.services.androidpublisher.model.Testers}
       * @return the request
       */
      public Patch patch(java.lang.String packageName, java.lang.String editId, java.lang.String track, com.google.api.services.androidpublisher.model.Testers content) throws java.io.IOException {
        Patch result = new Patch(packageName, editId, track, content);
        initialize(result);
        return result;
      }

      public class Patch extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}";

        /**
         * Patches testers.
         *
         * Create a request for the method "testers.patch".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param track The track to update.
         * @param content the {@link com.google.api.services.androidpublisher.model.Testers}
         * @since 1.13
         */
        protected Patch(java.lang.String packageName, java.lang.String editId, java.lang.String track, com.google.api.services.androidpublisher.model.Testers content) {
          super(AndroidPublisher.this, "PATCH", REST_PATH, content, com.google.api.services.androidpublisher.model.Testers.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.track = com.google.api.client.util.Preconditions.checkNotNull(track, "Required parameter track must be specified.");
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Patch setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Patch setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /** The track to update. */
        @com.google.api.client.util.Key
        private java.lang.String track;

        /** The track to update.
         */
        public java.lang.String getTrack() {
          return track;
        }

        /** The track to update. */
        public Patch setTrack(java.lang.String track) {
          this.track = track;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates testers.
       *
       * Create a request for the method "testers.update".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param track The track to update.
       * @param content the {@link com.google.api.services.androidpublisher.model.Testers}
       * @return the request
       */
      public Update update(java.lang.String packageName, java.lang.String editId, java.lang.String track, com.google.api.services.androidpublisher.model.Testers content) throws java.io.IOException {
        Update result = new Update(packageName, editId, track, content);
        initialize(result);
        return result;
      }

      public class Update extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}";

        /**
         * Updates testers.
         *
         * Create a request for the method "testers.update".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param track The track to update.
         * @param content the {@link com.google.api.services.androidpublisher.model.Testers}
         * @since 1.13
         */
        protected Update(java.lang.String packageName, java.lang.String editId, java.lang.String track, com.google.api.services.androidpublisher.model.Testers content) {
          super(AndroidPublisher.this, "PUT", REST_PATH, content, com.google.api.services.androidpublisher.model.Testers.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.track = com.google.api.client.util.Preconditions.checkNotNull(track, "Required parameter track must be specified.");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Update setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Update setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /** The track to update. */
        @com.google.api.client.util.Key
        private java.lang.String track;

        /** The track to update.
         */
        public java.lang.String getTrack() {
          return track;
        }

        /** The track to update. */
        public Update setTrack(java.lang.String track) {
          this.track = track;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Tracks collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Tracks.List request = androidpublisher.tracks().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Tracks tracks() {
      return new Tracks();
    }

    /**
     * The "tracks" collection of methods.
     */
    public class Tracks {

      /**
       * Gets a track.
       *
       * Create a request for the method "tracks.get".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param track Identifier of the track.
       * @return the request
       */
      public Get get(java.lang.String packageName, java.lang.String editId, java.lang.String track) throws java.io.IOException {
        Get result = new Get(packageName, editId, track);
        initialize(result);
        return result;
      }

      public class Get extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Track> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}";

        /**
         * Gets a track.
         *
         * Create a request for the method "tracks.get".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param track Identifier of the track.
         * @since 1.13
         */
        protected Get(java.lang.String packageName, java.lang.String editId, java.lang.String track) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.Track.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.track = com.google.api.client.util.Preconditions.checkNotNull(track, "Required parameter track must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Get setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Get setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /** Identifier of the track. */
        @com.google.api.client.util.Key
        private java.lang.String track;

        /** Identifier of the track.
         */
        public java.lang.String getTrack() {
          return track;
        }

        /** Identifier of the track. */
        public Get setTrack(java.lang.String track) {
          this.track = track;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists all tracks.
       *
       * Create a request for the method "tracks.list".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @return the request
       */
      public List list(java.lang.String packageName, java.lang.String editId) throws java.io.IOException {
        List result = new List(packageName, editId);
        initialize(result);
        return result;
      }

      public class List extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.TracksListResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks";

        /**
         * Lists all tracks.
         *
         * Create a request for the method "tracks.list".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @since 1.13
         */
        protected List(java.lang.String packageName, java.lang.String editId) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.TracksListResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public List setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public List setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Patches a track.
       *
       * Create a request for the method "tracks.patch".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param track Identifier of the track.
       * @param content the {@link com.google.api.services.androidpublisher.model.Track}
       * @return the request
       */
      public Patch patch(java.lang.String packageName, java.lang.String editId, java.lang.String track, com.google.api.services.androidpublisher.model.Track content) throws java.io.IOException {
        Patch result = new Patch(packageName, editId, track, content);
        initialize(result);
        return result;
      }

      public class Patch extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Track> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}";

        /**
         * Patches a track.
         *
         * Create a request for the method "tracks.patch".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param track Identifier of the track.
         * @param content the {@link com.google.api.services.androidpublisher.model.Track}
         * @since 1.13
         */
        protected Patch(java.lang.String packageName, java.lang.String editId, java.lang.String track, com.google.api.services.androidpublisher.model.Track content) {
          super(AndroidPublisher.this, "PATCH", REST_PATH, content, com.google.api.services.androidpublisher.model.Track.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.track = com.google.api.client.util.Preconditions.checkNotNull(track, "Required parameter track must be specified.");
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Patch setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Patch setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /** Identifier of the track. */
        @com.google.api.client.util.Key
        private java.lang.String track;

        /** Identifier of the track.
         */
        public java.lang.String getTrack() {
          return track;
        }

        /** Identifier of the track. */
        public Patch setTrack(java.lang.String track) {
          this.track = track;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates a track.
       *
       * Create a request for the method "tracks.update".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param packageName Package name of the app.
       * @param editId Identifier of the edit.
       * @param track Identifier of the track.
       * @param content the {@link com.google.api.services.androidpublisher.model.Track}
       * @return the request
       */
      public Update update(java.lang.String packageName, java.lang.String editId, java.lang.String track, com.google.api.services.androidpublisher.model.Track content) throws java.io.IOException {
        Update result = new Update(packageName, editId, track, content);
        initialize(result);
        return result;
      }

      public class Update extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Track> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}";

        /**
         * Updates a track.
         *
         * Create a request for the method "tracks.update".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName Package name of the app.
         * @param editId Identifier of the edit.
         * @param track Identifier of the track.
         * @param content the {@link com.google.api.services.androidpublisher.model.Track}
         * @since 1.13
         */
        protected Update(java.lang.String packageName, java.lang.String editId, java.lang.String track, com.google.api.services.androidpublisher.model.Track content) {
          super(AndroidPublisher.this, "PUT", REST_PATH, content, com.google.api.services.androidpublisher.model.Track.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.editId = com.google.api.client.util.Preconditions.checkNotNull(editId, "Required parameter editId must be specified.");
          this.track = com.google.api.client.util.Preconditions.checkNotNull(track, "Required parameter track must be specified.");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /** Package name of the app. */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** Package name of the app.
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /** Package name of the app. */
        public Update setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** Identifier of the edit. */
        @com.google.api.client.util.Key
        private java.lang.String editId;

        /** Identifier of the edit.
         */
        public java.lang.String getEditId() {
          return editId;
        }

        /** Identifier of the edit. */
        public Update setEditId(java.lang.String editId) {
          this.editId = editId;
          return this;
        }

        /** Identifier of the track. */
        @com.google.api.client.util.Key
        private java.lang.String track;

        /** Identifier of the track.
         */
        public java.lang.String getTrack() {
          return track;
        }

        /** Identifier of the track. */
        public Update setTrack(java.lang.String track) {
          this.track = track;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Inappproducts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
   *   {@code AndroidPublisher.Inappproducts.List request = androidpublisher.inappproducts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Inappproducts inappproducts() {
    return new Inappproducts();
  }

  /**
   * The "inappproducts" collection of methods.
   */
  public class Inappproducts {

    /**
     * Deletes an in-app product (i.e. a managed product or a subscriptions).
     *
     * Create a request for the method "inappproducts.delete".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param sku Unique identifier for the in-app product.
     * @return the request
     */
    public Delete delete(java.lang.String packageName, java.lang.String sku) throws java.io.IOException {
      Delete result = new Delete(packageName, sku);
      initialize(result);
      return result;
    }

    public class Delete extends AndroidPublisherRequest<Void> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}";

      /**
       * Deletes an in-app product (i.e. a managed product or a subscriptions).
       *
       * Create a request for the method "inappproducts.delete".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param sku Unique identifier for the in-app product.
       * @since 1.13
       */
      protected Delete(java.lang.String packageName, java.lang.String sku) {
        super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.sku = com.google.api.client.util.Preconditions.checkNotNull(sku, "Required parameter sku must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Delete setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** Unique identifier for the in-app product. */
      @com.google.api.client.util.Key
      private java.lang.String sku;

      /** Unique identifier for the in-app product.
       */
      public java.lang.String getSku() {
        return sku;
      }

      /** Unique identifier for the in-app product. */
      public Delete setSku(java.lang.String sku) {
        this.sku = sku;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets an in-app product, which can be a managed product or a subscription.
     *
     * Create a request for the method "inappproducts.get".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param sku Unique identifier for the in-app product.
     * @return the request
     */
    public Get get(java.lang.String packageName, java.lang.String sku) throws java.io.IOException {
      Get result = new Get(packageName, sku);
      initialize(result);
      return result;
    }

    public class Get extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.InAppProduct> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}";

      /**
       * Gets an in-app product, which can be a managed product or a subscription.
       *
       * Create a request for the method "inappproducts.get".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param sku Unique identifier for the in-app product.
       * @since 1.13
       */
      protected Get(java.lang.String packageName, java.lang.String sku) {
        super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.InAppProduct.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.sku = com.google.api.client.util.Preconditions.checkNotNull(sku, "Required parameter sku must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Get setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** Unique identifier for the in-app product. */
      @com.google.api.client.util.Key
      private java.lang.String sku;

      /** Unique identifier for the in-app product.
       */
      public java.lang.String getSku() {
        return sku;
      }

      /** Unique identifier for the in-app product. */
      public Get setSku(java.lang.String sku) {
        this.sku = sku;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an in-app product (i.e. a managed product or a subscriptions).
     *
     * Create a request for the method "inappproducts.insert".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param content the {@link com.google.api.services.androidpublisher.model.InAppProduct}
     * @return the request
     */
    public Insert insert(java.lang.String packageName, com.google.api.services.androidpublisher.model.InAppProduct content) throws java.io.IOException {
      Insert result = new Insert(packageName, content);
      initialize(result);
      return result;
    }

    public class Insert extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.InAppProduct> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts";

      /**
       * Creates an in-app product (i.e. a managed product or a subscriptions).
       *
       * Create a request for the method "inappproducts.insert".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param content the {@link com.google.api.services.androidpublisher.model.InAppProduct}
       * @since 1.13
       */
      protected Insert(java.lang.String packageName, com.google.api.services.androidpublisher.model.InAppProduct content) {
        super(AndroidPublisher.this, "POST", REST_PATH, content, com.google.api.services.androidpublisher.model.InAppProduct.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Insert setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /**
       * If true the prices for all regions targeted by the parent app that don't have a price
       * specified for this in-app product will be auto converted to the target currency based on
       * the default price. Defaults to false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean autoConvertMissingPrices;

      /** If true the prices for all regions targeted by the parent app that don't have a price specified for
     this in-app product will be auto converted to the target currency based on the default price.
     Defaults to false.
       */
      public java.lang.Boolean getAutoConvertMissingPrices() {
        return autoConvertMissingPrices;
      }

      /**
       * If true the prices for all regions targeted by the parent app that don't have a price
       * specified for this in-app product will be auto converted to the target currency based on
       * the default price. Defaults to false.
       */
      public Insert setAutoConvertMissingPrices(java.lang.Boolean autoConvertMissingPrices) {
        this.autoConvertMissingPrices = autoConvertMissingPrices;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all in-app products - both managed products and subscriptions.
     *
     * Create a request for the method "inappproducts.list".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @return the request
     */
    public List list(java.lang.String packageName) throws java.io.IOException {
      List result = new List(packageName);
      initialize(result);
      return result;
    }

    public class List extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.InappproductsListResponse> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts";

      /**
       * Lists all in-app products - both managed products and subscriptions.
       *
       * Create a request for the method "inappproducts.list".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @since 1.13
       */
      protected List(java.lang.String packageName) {
        super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.InappproductsListResponse.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public List setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** How many results the list operation should return. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** How many results the list operation should return.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** How many results the list operation should return. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The index of the first element to return. */
      @com.google.api.client.util.Key
      private java.lang.Long startIndex;

      /** The index of the first element to return.
       */
      public java.lang.Long getStartIndex() {
        return startIndex;
      }

      /** The index of the first element to return. */
      public List setStartIndex(java.lang.Long startIndex) {
        this.startIndex = startIndex;
        return this;
      }

      /** Pagination token. If empty, list starts at the first product. */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Pagination token. If empty, list starts at the first product.
       */
      public java.lang.String getToken() {
        return token;
      }

      /** Pagination token. If empty, list starts at the first product. */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Patches an in-app product (i.e. a managed product or a subscriptions).
     *
     * Create a request for the method "inappproducts.patch".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param sku Unique identifier for the in-app product.
     * @param content the {@link com.google.api.services.androidpublisher.model.InAppProduct}
     * @return the request
     */
    public Patch patch(java.lang.String packageName, java.lang.String sku, com.google.api.services.androidpublisher.model.InAppProduct content) throws java.io.IOException {
      Patch result = new Patch(packageName, sku, content);
      initialize(result);
      return result;
    }

    public class Patch extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.InAppProduct> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}";

      /**
       * Patches an in-app product (i.e. a managed product or a subscriptions).
       *
       * Create a request for the method "inappproducts.patch".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param sku Unique identifier for the in-app product.
       * @param content the {@link com.google.api.services.androidpublisher.model.InAppProduct}
       * @since 1.13
       */
      protected Patch(java.lang.String packageName, java.lang.String sku, com.google.api.services.androidpublisher.model.InAppProduct content) {
        super(AndroidPublisher.this, "PATCH", REST_PATH, content, com.google.api.services.androidpublisher.model.InAppProduct.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.sku = com.google.api.client.util.Preconditions.checkNotNull(sku, "Required parameter sku must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Patch setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** Unique identifier for the in-app product. */
      @com.google.api.client.util.Key
      private java.lang.String sku;

      /** Unique identifier for the in-app product.
       */
      public java.lang.String getSku() {
        return sku;
      }

      /** Unique identifier for the in-app product. */
      public Patch setSku(java.lang.String sku) {
        this.sku = sku;
        return this;
      }

      /**
       * If true the prices for all regions targeted by the parent app that don't have a price
       * specified for this in-app product will be auto converted to the target currency based on
       * the default price. Defaults to false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean autoConvertMissingPrices;

      /** If true the prices for all regions targeted by the parent app that don't have a price specified for
     this in-app product will be auto converted to the target currency based on the default price.
     Defaults to false.
       */
      public java.lang.Boolean getAutoConvertMissingPrices() {
        return autoConvertMissingPrices;
      }

      /**
       * If true the prices for all regions targeted by the parent app that don't have a price
       * specified for this in-app product will be auto converted to the target currency based on
       * the default price. Defaults to false.
       */
      public Patch setAutoConvertMissingPrices(java.lang.Boolean autoConvertMissingPrices) {
        this.autoConvertMissingPrices = autoConvertMissingPrices;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an in-app product (i.e. a managed product or a subscriptions).
     *
     * Create a request for the method "inappproducts.update".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param sku Unique identifier for the in-app product.
     * @param content the {@link com.google.api.services.androidpublisher.model.InAppProduct}
     * @return the request
     */
    public Update update(java.lang.String packageName, java.lang.String sku, com.google.api.services.androidpublisher.model.InAppProduct content) throws java.io.IOException {
      Update result = new Update(packageName, sku, content);
      initialize(result);
      return result;
    }

    public class Update extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.InAppProduct> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}";

      /**
       * Updates an in-app product (i.e. a managed product or a subscriptions).
       *
       * Create a request for the method "inappproducts.update".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param sku Unique identifier for the in-app product.
       * @param content the {@link com.google.api.services.androidpublisher.model.InAppProduct}
       * @since 1.13
       */
      protected Update(java.lang.String packageName, java.lang.String sku, com.google.api.services.androidpublisher.model.InAppProduct content) {
        super(AndroidPublisher.this, "PUT", REST_PATH, content, com.google.api.services.androidpublisher.model.InAppProduct.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.sku = com.google.api.client.util.Preconditions.checkNotNull(sku, "Required parameter sku must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Update setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** Unique identifier for the in-app product. */
      @com.google.api.client.util.Key
      private java.lang.String sku;

      /** Unique identifier for the in-app product.
       */
      public java.lang.String getSku() {
        return sku;
      }

      /** Unique identifier for the in-app product. */
      public Update setSku(java.lang.String sku) {
        this.sku = sku;
        return this;
      }

      /**
       * If true the prices for all regions targeted by the parent app that don't have a price
       * specified for this in-app product will be auto converted to the target currency based on
       * the default price. Defaults to false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean autoConvertMissingPrices;

      /** If true the prices for all regions targeted by the parent app that don't have a price specified for
     this in-app product will be auto converted to the target currency based on the default price.
     Defaults to false.
       */
      public java.lang.Boolean getAutoConvertMissingPrices() {
        return autoConvertMissingPrices;
      }

      /**
       * If true the prices for all regions targeted by the parent app that don't have a price
       * specified for this in-app product will be auto converted to the target currency based on
       * the default price. Defaults to false.
       */
      public Update setAutoConvertMissingPrices(java.lang.Boolean autoConvertMissingPrices) {
        this.autoConvertMissingPrices = autoConvertMissingPrices;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Internalappsharingartifacts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
   *   {@code AndroidPublisher.Internalappsharingartifacts.List request = androidpublisher.internalappsharingartifacts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Internalappsharingartifacts internalappsharingartifacts() {
    return new Internalappsharingartifacts();
  }

  /**
   * The "internalappsharingartifacts" collection of methods.
   */
  public class Internalappsharingartifacts {

    /**
     * Uploads an APK to internal app sharing. If you are using the Google API client libraries, please
     * increase the timeout of the http request before calling this endpoint (a timeout of 2 minutes is
     * recommended).
     *
     * See [Timeouts and Errors](https://developers.google.com/api-client-library/java/google-api-java-
     * client/errors) for an example in java.
     *
     * Create a request for the method "internalappsharingartifacts.uploadapk".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Uploadapk#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @return the request
     */
    public Uploadapk uploadapk(java.lang.String packageName) throws java.io.IOException {
      Uploadapk result = new Uploadapk(packageName);
      initialize(result);
      return result;
    }

    /**
     * Uploads an APK to internal app sharing. If you are using the Google API client libraries, please
     * increase the timeout of the http request before calling this endpoint (a timeout of 2 minutes is
     * recommended).
     *
     * See [Timeouts and Errors](https://developers.google.com/api-client-library/java/google-api-java-
     * client/errors) for an example in java.
     *
     * Create a request for the method "internalappsharingartifacts.uploadapk".
     *
     * This request holds the parameters needed by the the androidpublisher server.  After setting any
     * optional parameters, call the {@link Uploadapk#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param packageName Package name of the app.
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Uploadapk uploadapk(java.lang.String packageName, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Uploadapk result = new Uploadapk(packageName, mediaContent);
      initialize(result);
      return result;
    }

    public class Uploadapk extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.InternalAppSharingArtifact> {

      private static final String REST_PATH = "androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/apk";

      /**
       * Uploads an APK to internal app sharing. If you are using the Google API client libraries,
       * please increase the timeout of the http request before calling this endpoint (a timeout of 2
       * minutes is recommended).
       *
       * See [Timeouts and Errors](https://developers.google.com/api-client-library/java/google-api-
       * java-client/errors) for an example in java.
       *
       * Create a request for the method "internalappsharingartifacts.uploadapk".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Uploadapk#execute()} method to invoke the remote
       * operation. <p> {@link
       * Uploadapk#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @since 1.13
       */
      protected Uploadapk(java.lang.String packageName) {
        super(AndroidPublisher.this, "POST", REST_PATH, null, com.google.api.services.androidpublisher.model.InternalAppSharingArtifact.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
      }

      /**
       * Uploads an APK to internal app sharing. If you are using the Google API client libraries,
       * please increase the timeout of the http request before calling this endpoint (a timeout of 2
       * minutes is recommended).
       *
       * See [Timeouts and Errors](https://developers.google.com/api-client-library/java/google-api-
       * java-client/errors) for an example in java.
       *
       * Create a request for the method "internalappsharingartifacts.uploadapk".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Uploadapk#execute()} method to invoke the remote
       * operation. <p> {@link
       * Uploadapk#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param packageName Package name of the app.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Uploadapk(java.lang.String packageName, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(AndroidPublisher.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.androidpublisher.model.InternalAppSharingArtifact.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Uploadapk set$Xgafv(java.lang.String $Xgafv) {
        return (Uploadapk) super.set$Xgafv($Xgafv);
      }

      @Override
      public Uploadapk setAccessToken(java.lang.String accessToken) {
        return (Uploadapk) super.setAccessToken(accessToken);
      }

      @Override
      public Uploadapk setAlt(java.lang.String alt) {
        return (Uploadapk) super.setAlt(alt);
      }

      @Override
      public Uploadapk setCallback(java.lang.String callback) {
        return (Uploadapk) super.setCallback(callback);
      }

      @Override
      public Uploadapk setFields(java.lang.String fields) {
        return (Uploadapk) super.setFields(fields);
      }

      @Override
      public Uploadapk setKey(java.lang.String key) {
        return (Uploadapk) super.setKey(key);
      }

      @Override
      public Uploadapk setOauthToken(java.lang.String oauthToken) {
        return (Uploadapk) super.setOauthToken(oauthToken);
      }

      @Override
      public Uploadapk setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Uploadapk) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Uploadapk setQuotaUser(java.lang.String quotaUser) {
        return (Uploadapk) super.setQuotaUser(quotaUser);
      }

      @Override
      public Uploadapk setUploadType(java.lang.String uploadType) {
        return (Uploadapk) super.setUploadType(uploadType);
      }

      @Override
      public Uploadapk setUploadProtocol(java.lang.String uploadProtocol) {
        return (Uploadapk) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Uploadapk setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      @Override
      public Uploadapk set(String parameterName, Object value) {
        return (Uploadapk) super.set(parameterName, value);
      }
    }
    /**
     * Uploads an app bundle to internal app sharing. If you are using the Google API client libraries,
     * please increase the timeout of the http request before calling this endpoint (a timeout of 2
     * minutes is recommended).
     *
     * See [Timeouts and Errors](https://developers.google.com/api-client-library/java/google-api-java-
     * client/errors) for an example in java.
     *
     * Create a request for the method "internalappsharingartifacts.uploadbundle".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Uploadbundle#execute()} method to invoke the remote
     * operation.
     *
     * @param packageName Package name of the app.
     * @return the request
     */
    public Uploadbundle uploadbundle(java.lang.String packageName) throws java.io.IOException {
      Uploadbundle result = new Uploadbundle(packageName);
      initialize(result);
      return result;
    }

    /**
     * Uploads an app bundle to internal app sharing. If you are using the Google API client libraries,
     * please increase the timeout of the http request before calling this endpoint (a timeout of 2
     * minutes is recommended).
     *
     * See [Timeouts and Errors](https://developers.google.com/api-client-library/java/google-api-java-
     * client/errors) for an example in java.
     *
     * Create a request for the method "internalappsharingartifacts.uploadbundle".
     *
     * This request holds the parameters needed by the the androidpublisher server.  After setting any
     * optional parameters, call the {@link Uploadbundle#execute()} method to invoke the remote
     * operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param packageName Package name of the app.
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Uploadbundle uploadbundle(java.lang.String packageName, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Uploadbundle result = new Uploadbundle(packageName, mediaContent);
      initialize(result);
      return result;
    }

    public class Uploadbundle extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.InternalAppSharingArtifact> {

      private static final String REST_PATH = "androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/bundle";

      /**
       * Uploads an app bundle to internal app sharing. If you are using the Google API client
       * libraries, please increase the timeout of the http request before calling this endpoint (a
       * timeout of 2 minutes is recommended).
       *
       * See [Timeouts and Errors](https://developers.google.com/api-client-library/java/google-api-
       * java-client/errors) for an example in java.
       *
       * Create a request for the method "internalappsharingartifacts.uploadbundle".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Uploadbundle#execute()} method to invoke the remote
       * operation. <p> {@link
       * Uploadbundle#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @since 1.13
       */
      protected Uploadbundle(java.lang.String packageName) {
        super(AndroidPublisher.this, "POST", REST_PATH, null, com.google.api.services.androidpublisher.model.InternalAppSharingArtifact.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
      }

      /**
       * Uploads an app bundle to internal app sharing. If you are using the Google API client
       * libraries, please increase the timeout of the http request before calling this endpoint (a
       * timeout of 2 minutes is recommended).
       *
       * See [Timeouts and Errors](https://developers.google.com/api-client-library/java/google-api-
       * java-client/errors) for an example in java.
       *
       * Create a request for the method "internalappsharingartifacts.uploadbundle".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Uploadbundle#execute()} method to invoke the remote
       * operation. <p> {@link
       * Uploadbundle#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param packageName Package name of the app.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Uploadbundle(java.lang.String packageName, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(AndroidPublisher.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.androidpublisher.model.InternalAppSharingArtifact.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Uploadbundle set$Xgafv(java.lang.String $Xgafv) {
        return (Uploadbundle) super.set$Xgafv($Xgafv);
      }

      @Override
      public Uploadbundle setAccessToken(java.lang.String accessToken) {
        return (Uploadbundle) super.setAccessToken(accessToken);
      }

      @Override
      public Uploadbundle setAlt(java.lang.String alt) {
        return (Uploadbundle) super.setAlt(alt);
      }

      @Override
      public Uploadbundle setCallback(java.lang.String callback) {
        return (Uploadbundle) super.setCallback(callback);
      }

      @Override
      public Uploadbundle setFields(java.lang.String fields) {
        return (Uploadbundle) super.setFields(fields);
      }

      @Override
      public Uploadbundle setKey(java.lang.String key) {
        return (Uploadbundle) super.setKey(key);
      }

      @Override
      public Uploadbundle setOauthToken(java.lang.String oauthToken) {
        return (Uploadbundle) super.setOauthToken(oauthToken);
      }

      @Override
      public Uploadbundle setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Uploadbundle) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Uploadbundle setQuotaUser(java.lang.String quotaUser) {
        return (Uploadbundle) super.setQuotaUser(quotaUser);
      }

      @Override
      public Uploadbundle setUploadType(java.lang.String uploadType) {
        return (Uploadbundle) super.setUploadType(uploadType);
      }

      @Override
      public Uploadbundle setUploadProtocol(java.lang.String uploadProtocol) {
        return (Uploadbundle) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Uploadbundle setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      @Override
      public Uploadbundle set(String parameterName, Object value) {
        return (Uploadbundle) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Orders collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
   *   {@code AndroidPublisher.Orders.List request = androidpublisher.orders().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Orders orders() {
    return new Orders();
  }

  /**
   * The "orders" collection of methods.
   */
  public class Orders {

    /**
     * Refund a user's subscription or in-app purchase order.
     *
     * Create a request for the method "orders.refund".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Refund#execute()} method to invoke the remote operation.
     *
     * @param packageName The package name of the application for which this subscription or in-app
    item was purchased (for
     *        example, 'com.some.thing').
     * @param orderId The order ID provided to the user when the subscription or in-app order was
    purchased.
     * @return the request
     */
    public Refund refund(java.lang.String packageName, java.lang.String orderId) throws java.io.IOException {
      Refund result = new Refund(packageName, orderId);
      initialize(result);
      return result;
    }

    public class Refund extends AndroidPublisherRequest<Void> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/orders/{orderId}:refund";

      /**
       * Refund a user's subscription or in-app purchase order.
       *
       * Create a request for the method "orders.refund".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Refund#execute()} method to invoke the remote operation.
       * <p> {@link
       * Refund#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName The package name of the application for which this subscription or in-app
    item was purchased (for
     *        example, 'com.some.thing').
       * @param orderId The order ID provided to the user when the subscription or in-app order was
    purchased.
       * @since 1.13
       */
      protected Refund(java.lang.String packageName, java.lang.String orderId) {
        super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.orderId = com.google.api.client.util.Preconditions.checkNotNull(orderId, "Required parameter orderId must be specified.");
      }

      @Override
      public Refund set$Xgafv(java.lang.String $Xgafv) {
        return (Refund) super.set$Xgafv($Xgafv);
      }

      @Override
      public Refund setAccessToken(java.lang.String accessToken) {
        return (Refund) super.setAccessToken(accessToken);
      }

      @Override
      public Refund setAlt(java.lang.String alt) {
        return (Refund) super.setAlt(alt);
      }

      @Override
      public Refund setCallback(java.lang.String callback) {
        return (Refund) super.setCallback(callback);
      }

      @Override
      public Refund setFields(java.lang.String fields) {
        return (Refund) super.setFields(fields);
      }

      @Override
      public Refund setKey(java.lang.String key) {
        return (Refund) super.setKey(key);
      }

      @Override
      public Refund setOauthToken(java.lang.String oauthToken) {
        return (Refund) super.setOauthToken(oauthToken);
      }

      @Override
      public Refund setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Refund) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Refund setQuotaUser(java.lang.String quotaUser) {
        return (Refund) super.setQuotaUser(quotaUser);
      }

      @Override
      public Refund setUploadType(java.lang.String uploadType) {
        return (Refund) super.setUploadType(uploadType);
      }

      @Override
      public Refund setUploadProtocol(java.lang.String uploadProtocol) {
        return (Refund) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The package name of the application for which this subscription or in-app item was
       * purchased (for example, 'com.some.thing').
       */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** The package name of the application for which this subscription or in-app item was purchased (for
     example, 'com.some.thing').
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /**
       * The package name of the application for which this subscription or in-app item was
       * purchased (for example, 'com.some.thing').
       */
      public Refund setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /**
       * The order ID provided to the user when the subscription or in-app order was purchased.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderId;

      /** The order ID provided to the user when the subscription or in-app order was purchased.
       */
      public java.lang.String getOrderId() {
        return orderId;
      }

      /**
       * The order ID provided to the user when the subscription or in-app order was purchased.
       */
      public Refund setOrderId(java.lang.String orderId) {
        this.orderId = orderId;
        return this;
      }

      /**
       * Whether to revoke the purchased item. If set to true, access to the subscription or in-app
       * item will be terminated immediately. If the item is a recurring subscription, all future
       * payments will also be terminated. Consumed in-app items need to be handled by developer's
       * app. (optional).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean revoke;

      /** Whether to revoke the purchased item. If set to true, access to the subscription or in-app item
     will be terminated immediately. If the item is a recurring subscription, all future payments will
     also be terminated. Consumed in-app items need to be handled by developer's app. (optional).
       */
      public java.lang.Boolean getRevoke() {
        return revoke;
      }

      /**
       * Whether to revoke the purchased item. If set to true, access to the subscription or in-app
       * item will be terminated immediately. If the item is a recurring subscription, all future
       * payments will also be terminated. Consumed in-app items need to be handled by developer's
       * app. (optional).
       */
      public Refund setRevoke(java.lang.Boolean revoke) {
        this.revoke = revoke;
        return this;
      }

      @Override
      public Refund set(String parameterName, Object value) {
        return (Refund) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Purchases collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
   *   {@code AndroidPublisher.Purchases.List request = androidpublisher.purchases().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Purchases purchases() {
    return new Purchases();
  }

  /**
   * The "purchases" collection of methods.
   */
  public class Purchases {

    /**
     * An accessor for creating requests from the Products collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Products.List request = androidpublisher.products().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Products products() {
      return new Products();
    }

    /**
     * The "products" collection of methods.
     */
    public class Products {

      /**
       * Acknowledges a purchase of an inapp item.
       *
       * Create a request for the method "products.acknowledge".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Acknowledge#execute()} method to invoke the remote
       * operation.
       *
       * @param packageName The package name of the application the inapp product was sold in (for
      example, 'com.some.thing').
       * @param productId The inapp product SKU (for example, 'com.some.thing.inapp1').
       * @param token The token provided to the user's device when the inapp product was
      purchased.
       * @param content the {@link com.google.api.services.androidpublisher.model.ProductPurchasesAcknowledgeRequest}
       * @return the request
       */
      public Acknowledge acknowledge(java.lang.String packageName, java.lang.String productId, java.lang.String token, com.google.api.services.androidpublisher.model.ProductPurchasesAcknowledgeRequest content) throws java.io.IOException {
        Acknowledge result = new Acknowledge(packageName, productId, token, content);
        initialize(result);
        return result;
      }

      public class Acknowledge extends AndroidPublisherRequest<Void> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}:acknowledge";

        /**
         * Acknowledges a purchase of an inapp item.
         *
         * Create a request for the method "products.acknowledge".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Acknowledge#execute()} method to invoke the remote
         * operation. <p> {@link
         * Acknowledge#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName The package name of the application the inapp product was sold in (for
      example, 'com.some.thing').
         * @param productId The inapp product SKU (for example, 'com.some.thing.inapp1').
         * @param token The token provided to the user's device when the inapp product was
      purchased.
         * @param content the {@link com.google.api.services.androidpublisher.model.ProductPurchasesAcknowledgeRequest}
         * @since 1.13
         */
        protected Acknowledge(java.lang.String packageName, java.lang.String productId, java.lang.String token, com.google.api.services.androidpublisher.model.ProductPurchasesAcknowledgeRequest content) {
          super(AndroidPublisher.this, "POST", REST_PATH, content, Void.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.productId = com.google.api.client.util.Preconditions.checkNotNull(productId, "Required parameter productId must be specified.");
          this.token = com.google.api.client.util.Preconditions.checkNotNull(token, "Required parameter token must be specified.");
        }

        @Override
        public Acknowledge set$Xgafv(java.lang.String $Xgafv) {
          return (Acknowledge) super.set$Xgafv($Xgafv);
        }

        @Override
        public Acknowledge setAccessToken(java.lang.String accessToken) {
          return (Acknowledge) super.setAccessToken(accessToken);
        }

        @Override
        public Acknowledge setAlt(java.lang.String alt) {
          return (Acknowledge) super.setAlt(alt);
        }

        @Override
        public Acknowledge setCallback(java.lang.String callback) {
          return (Acknowledge) super.setCallback(callback);
        }

        @Override
        public Acknowledge setFields(java.lang.String fields) {
          return (Acknowledge) super.setFields(fields);
        }

        @Override
        public Acknowledge setKey(java.lang.String key) {
          return (Acknowledge) super.setKey(key);
        }

        @Override
        public Acknowledge setOauthToken(java.lang.String oauthToken) {
          return (Acknowledge) super.setOauthToken(oauthToken);
        }

        @Override
        public Acknowledge setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Acknowledge) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Acknowledge setQuotaUser(java.lang.String quotaUser) {
          return (Acknowledge) super.setQuotaUser(quotaUser);
        }

        @Override
        public Acknowledge setUploadType(java.lang.String uploadType) {
          return (Acknowledge) super.setUploadType(uploadType);
        }

        @Override
        public Acknowledge setUploadProtocol(java.lang.String uploadProtocol) {
          return (Acknowledge) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The package name of the application the inapp product was sold in (for example,
         * 'com.some.thing').
         */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** The package name of the application the inapp product was sold in (for example, 'com.some.thing').
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /**
         * The package name of the application the inapp product was sold in (for example,
         * 'com.some.thing').
         */
        public Acknowledge setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** The inapp product SKU (for example, 'com.some.thing.inapp1'). */
        @com.google.api.client.util.Key
        private java.lang.String productId;

        /** The inapp product SKU (for example, 'com.some.thing.inapp1').
         */
        public java.lang.String getProductId() {
          return productId;
        }

        /** The inapp product SKU (for example, 'com.some.thing.inapp1'). */
        public Acknowledge setProductId(java.lang.String productId) {
          this.productId = productId;
          return this;
        }

        /**
         * The token provided to the user's device when the inapp product was purchased.
         */
        @com.google.api.client.util.Key
        private java.lang.String token;

        /** The token provided to the user's device when the inapp product was purchased.
         */
        public java.lang.String getToken() {
          return token;
        }

        /**
         * The token provided to the user's device when the inapp product was purchased.
         */
        public Acknowledge setToken(java.lang.String token) {
          this.token = token;
          return this;
        }

        @Override
        public Acknowledge set(String parameterName, Object value) {
          return (Acknowledge) super.set(parameterName, value);
        }
      }
      /**
       * Checks the purchase and consumption status of an inapp item.
       *
       * Create a request for the method "products.get".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param packageName The package name of the application the inapp product was sold in (for
      example, 'com.some.thing').
       * @param productId The inapp product SKU (for example, 'com.some.thing.inapp1').
       * @param token The token provided to the user's device when the inapp product was
      purchased.
       * @return the request
       */
      public Get get(java.lang.String packageName, java.lang.String productId, java.lang.String token) throws java.io.IOException {
        Get result = new Get(packageName, productId, token);
        initialize(result);
        return result;
      }

      public class Get extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ProductPurchase> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}";

        /**
         * Checks the purchase and consumption status of an inapp item.
         *
         * Create a request for the method "products.get".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName The package name of the application the inapp product was sold in (for
      example, 'com.some.thing').
         * @param productId The inapp product SKU (for example, 'com.some.thing.inapp1').
         * @param token The token provided to the user's device when the inapp product was
      purchased.
         * @since 1.13
         */
        protected Get(java.lang.String packageName, java.lang.String productId, java.lang.String token) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.ProductPurchase.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.productId = com.google.api.client.util.Preconditions.checkNotNull(productId, "Required parameter productId must be specified.");
          this.token = com.google.api.client.util.Preconditions.checkNotNull(token, "Required parameter token must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The package name of the application the inapp product was sold in (for example,
         * 'com.some.thing').
         */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** The package name of the application the inapp product was sold in (for example, 'com.some.thing').
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /**
         * The package name of the application the inapp product was sold in (for example,
         * 'com.some.thing').
         */
        public Get setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** The inapp product SKU (for example, 'com.some.thing.inapp1'). */
        @com.google.api.client.util.Key
        private java.lang.String productId;

        /** The inapp product SKU (for example, 'com.some.thing.inapp1').
         */
        public java.lang.String getProductId() {
          return productId;
        }

        /** The inapp product SKU (for example, 'com.some.thing.inapp1'). */
        public Get setProductId(java.lang.String productId) {
          this.productId = productId;
          return this;
        }

        /**
         * The token provided to the user's device when the inapp product was purchased.
         */
        @com.google.api.client.util.Key
        private java.lang.String token;

        /** The token provided to the user's device when the inapp product was purchased.
         */
        public java.lang.String getToken() {
          return token;
        }

        /**
         * The token provided to the user's device when the inapp product was purchased.
         */
        public Get setToken(java.lang.String token) {
          this.token = token;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Subscriptions collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Subscriptions.List request = androidpublisher.subscriptions().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Subscriptions subscriptions() {
      return new Subscriptions();
    }

    /**
     * The "subscriptions" collection of methods.
     */
    public class Subscriptions {

      /**
       * Acknowledges a subscription purchase.
       *
       * Create a request for the method "subscriptions.acknowledge".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Acknowledge#execute()} method to invoke the remote
       * operation.
       *
       * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
       * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
       * @param token The token provided to the user's device when the subscription was
      purchased.
       * @param content the {@link com.google.api.services.androidpublisher.model.SubscriptionPurchasesAcknowledgeRequest}
       * @return the request
       */
      public Acknowledge acknowledge(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token, com.google.api.services.androidpublisher.model.SubscriptionPurchasesAcknowledgeRequest content) throws java.io.IOException {
        Acknowledge result = new Acknowledge(packageName, subscriptionId, token, content);
        initialize(result);
        return result;
      }

      public class Acknowledge extends AndroidPublisherRequest<Void> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:acknowledge";

        /**
         * Acknowledges a subscription purchase.
         *
         * Create a request for the method "subscriptions.acknowledge".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Acknowledge#execute()} method to invoke the remote
         * operation. <p> {@link
         * Acknowledge#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
         * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
         * @param token The token provided to the user's device when the subscription was
      purchased.
         * @param content the {@link com.google.api.services.androidpublisher.model.SubscriptionPurchasesAcknowledgeRequest}
         * @since 1.13
         */
        protected Acknowledge(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token, com.google.api.services.androidpublisher.model.SubscriptionPurchasesAcknowledgeRequest content) {
          super(AndroidPublisher.this, "POST", REST_PATH, content, Void.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.subscriptionId = com.google.api.client.util.Preconditions.checkNotNull(subscriptionId, "Required parameter subscriptionId must be specified.");
          this.token = com.google.api.client.util.Preconditions.checkNotNull(token, "Required parameter token must be specified.");
        }

        @Override
        public Acknowledge set$Xgafv(java.lang.String $Xgafv) {
          return (Acknowledge) super.set$Xgafv($Xgafv);
        }

        @Override
        public Acknowledge setAccessToken(java.lang.String accessToken) {
          return (Acknowledge) super.setAccessToken(accessToken);
        }

        @Override
        public Acknowledge setAlt(java.lang.String alt) {
          return (Acknowledge) super.setAlt(alt);
        }

        @Override
        public Acknowledge setCallback(java.lang.String callback) {
          return (Acknowledge) super.setCallback(callback);
        }

        @Override
        public Acknowledge setFields(java.lang.String fields) {
          return (Acknowledge) super.setFields(fields);
        }

        @Override
        public Acknowledge setKey(java.lang.String key) {
          return (Acknowledge) super.setKey(key);
        }

        @Override
        public Acknowledge setOauthToken(java.lang.String oauthToken) {
          return (Acknowledge) super.setOauthToken(oauthToken);
        }

        @Override
        public Acknowledge setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Acknowledge) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Acknowledge setQuotaUser(java.lang.String quotaUser) {
          return (Acknowledge) super.setQuotaUser(quotaUser);
        }

        @Override
        public Acknowledge setUploadType(java.lang.String uploadType) {
          return (Acknowledge) super.setUploadType(uploadType);
        }

        @Override
        public Acknowledge setUploadProtocol(java.lang.String uploadProtocol) {
          return (Acknowledge) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** The package name of the application for which this subscription was purchased (for example,
       'com.some.thing').
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        public Acknowledge setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** The purchased subscription ID (for example, 'monthly001'). */
        @com.google.api.client.util.Key
        private java.lang.String subscriptionId;

        /** The purchased subscription ID (for example, 'monthly001').
         */
        public java.lang.String getSubscriptionId() {
          return subscriptionId;
        }

        /** The purchased subscription ID (for example, 'monthly001'). */
        public Acknowledge setSubscriptionId(java.lang.String subscriptionId) {
          this.subscriptionId = subscriptionId;
          return this;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        @com.google.api.client.util.Key
        private java.lang.String token;

        /** The token provided to the user's device when the subscription was purchased.
         */
        public java.lang.String getToken() {
          return token;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        public Acknowledge setToken(java.lang.String token) {
          this.token = token;
          return this;
        }

        @Override
        public Acknowledge set(String parameterName, Object value) {
          return (Acknowledge) super.set(parameterName, value);
        }
      }
      /**
       * Cancels a user's subscription purchase. The subscription remains valid until its expiration time.
       *
       * Create a request for the method "subscriptions.cancel".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
       *
       * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
       * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
       * @param token The token provided to the user's device when the subscription was
      purchased.
       * @return the request
       */
      public Cancel cancel(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token) throws java.io.IOException {
        Cancel result = new Cancel(packageName, subscriptionId, token);
        initialize(result);
        return result;
      }

      public class Cancel extends AndroidPublisherRequest<Void> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:cancel";

        /**
         * Cancels a user's subscription purchase. The subscription remains valid until its expiration
         * time.
         *
         * Create a request for the method "subscriptions.cancel".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
         * <p> {@link
         * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
         * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
         * @param token The token provided to the user's device when the subscription was
      purchased.
         * @since 1.13
         */
        protected Cancel(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token) {
          super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.subscriptionId = com.google.api.client.util.Preconditions.checkNotNull(subscriptionId, "Required parameter subscriptionId must be specified.");
          this.token = com.google.api.client.util.Preconditions.checkNotNull(token, "Required parameter token must be specified.");
        }

        @Override
        public Cancel set$Xgafv(java.lang.String $Xgafv) {
          return (Cancel) super.set$Xgafv($Xgafv);
        }

        @Override
        public Cancel setAccessToken(java.lang.String accessToken) {
          return (Cancel) super.setAccessToken(accessToken);
        }

        @Override
        public Cancel setAlt(java.lang.String alt) {
          return (Cancel) super.setAlt(alt);
        }

        @Override
        public Cancel setCallback(java.lang.String callback) {
          return (Cancel) super.setCallback(callback);
        }

        @Override
        public Cancel setFields(java.lang.String fields) {
          return (Cancel) super.setFields(fields);
        }

        @Override
        public Cancel setKey(java.lang.String key) {
          return (Cancel) super.setKey(key);
        }

        @Override
        public Cancel setOauthToken(java.lang.String oauthToken) {
          return (Cancel) super.setOauthToken(oauthToken);
        }

        @Override
        public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Cancel) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Cancel setQuotaUser(java.lang.String quotaUser) {
          return (Cancel) super.setQuotaUser(quotaUser);
        }

        @Override
        public Cancel setUploadType(java.lang.String uploadType) {
          return (Cancel) super.setUploadType(uploadType);
        }

        @Override
        public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
          return (Cancel) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** The package name of the application for which this subscription was purchased (for example,
       'com.some.thing').
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        public Cancel setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** The purchased subscription ID (for example, 'monthly001'). */
        @com.google.api.client.util.Key
        private java.lang.String subscriptionId;

        /** The purchased subscription ID (for example, 'monthly001').
         */
        public java.lang.String getSubscriptionId() {
          return subscriptionId;
        }

        /** The purchased subscription ID (for example, 'monthly001'). */
        public Cancel setSubscriptionId(java.lang.String subscriptionId) {
          this.subscriptionId = subscriptionId;
          return this;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        @com.google.api.client.util.Key
        private java.lang.String token;

        /** The token provided to the user's device when the subscription was purchased.
         */
        public java.lang.String getToken() {
          return token;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        public Cancel setToken(java.lang.String token) {
          this.token = token;
          return this;
        }

        @Override
        public Cancel set(String parameterName, Object value) {
          return (Cancel) super.set(parameterName, value);
        }
      }
      /**
       * Defers a user's subscription purchase until a specified future expiration time.
       *
       * Create a request for the method "subscriptions.defer".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Defer#execute()} method to invoke the remote operation.
       *
       * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
       * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
       * @param token The token provided to the user's device when the subscription was
      purchased.
       * @param content the {@link com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferRequest}
       * @return the request
       */
      public Defer defer(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token, com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferRequest content) throws java.io.IOException {
        Defer result = new Defer(packageName, subscriptionId, token, content);
        initialize(result);
        return result;
      }

      public class Defer extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:defer";

        /**
         * Defers a user's subscription purchase until a specified future expiration time.
         *
         * Create a request for the method "subscriptions.defer".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Defer#execute()} method to invoke the remote operation.
         * <p> {@link
         * Defer#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
         * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
         * @param token The token provided to the user's device when the subscription was
      purchased.
         * @param content the {@link com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferRequest}
         * @since 1.13
         */
        protected Defer(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token, com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferRequest content) {
          super(AndroidPublisher.this, "POST", REST_PATH, content, com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.subscriptionId = com.google.api.client.util.Preconditions.checkNotNull(subscriptionId, "Required parameter subscriptionId must be specified.");
          this.token = com.google.api.client.util.Preconditions.checkNotNull(token, "Required parameter token must be specified.");
        }

        @Override
        public Defer set$Xgafv(java.lang.String $Xgafv) {
          return (Defer) super.set$Xgafv($Xgafv);
        }

        @Override
        public Defer setAccessToken(java.lang.String accessToken) {
          return (Defer) super.setAccessToken(accessToken);
        }

        @Override
        public Defer setAlt(java.lang.String alt) {
          return (Defer) super.setAlt(alt);
        }

        @Override
        public Defer setCallback(java.lang.String callback) {
          return (Defer) super.setCallback(callback);
        }

        @Override
        public Defer setFields(java.lang.String fields) {
          return (Defer) super.setFields(fields);
        }

        @Override
        public Defer setKey(java.lang.String key) {
          return (Defer) super.setKey(key);
        }

        @Override
        public Defer setOauthToken(java.lang.String oauthToken) {
          return (Defer) super.setOauthToken(oauthToken);
        }

        @Override
        public Defer setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Defer) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Defer setQuotaUser(java.lang.String quotaUser) {
          return (Defer) super.setQuotaUser(quotaUser);
        }

        @Override
        public Defer setUploadType(java.lang.String uploadType) {
          return (Defer) super.setUploadType(uploadType);
        }

        @Override
        public Defer setUploadProtocol(java.lang.String uploadProtocol) {
          return (Defer) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** The package name of the application for which this subscription was purchased (for example,
       'com.some.thing').
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        public Defer setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** The purchased subscription ID (for example, 'monthly001'). */
        @com.google.api.client.util.Key
        private java.lang.String subscriptionId;

        /** The purchased subscription ID (for example, 'monthly001').
         */
        public java.lang.String getSubscriptionId() {
          return subscriptionId;
        }

        /** The purchased subscription ID (for example, 'monthly001'). */
        public Defer setSubscriptionId(java.lang.String subscriptionId) {
          this.subscriptionId = subscriptionId;
          return this;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        @com.google.api.client.util.Key
        private java.lang.String token;

        /** The token provided to the user's device when the subscription was purchased.
         */
        public java.lang.String getToken() {
          return token;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        public Defer setToken(java.lang.String token) {
          this.token = token;
          return this;
        }

        @Override
        public Defer set(String parameterName, Object value) {
          return (Defer) super.set(parameterName, value);
        }
      }
      /**
       * Checks whether a user's subscription purchase is valid and returns its expiry time.
       *
       * Create a request for the method "subscriptions.get".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
       * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
       * @param token The token provided to the user's device when the subscription was
      purchased.
       * @return the request
       */
      public Get get(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token) throws java.io.IOException {
        Get result = new Get(packageName, subscriptionId, token);
        initialize(result);
        return result;
      }

      public class Get extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.SubscriptionPurchase> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}";

        /**
         * Checks whether a user's subscription purchase is valid and returns its expiry time.
         *
         * Create a request for the method "subscriptions.get".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
         * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
         * @param token The token provided to the user's device when the subscription was
      purchased.
         * @since 1.13
         */
        protected Get(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.SubscriptionPurchase.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.subscriptionId = com.google.api.client.util.Preconditions.checkNotNull(subscriptionId, "Required parameter subscriptionId must be specified.");
          this.token = com.google.api.client.util.Preconditions.checkNotNull(token, "Required parameter token must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** The package name of the application for which this subscription was purchased (for example,
       'com.some.thing').
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        public Get setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** The purchased subscription ID (for example, 'monthly001'). */
        @com.google.api.client.util.Key
        private java.lang.String subscriptionId;

        /** The purchased subscription ID (for example, 'monthly001').
         */
        public java.lang.String getSubscriptionId() {
          return subscriptionId;
        }

        /** The purchased subscription ID (for example, 'monthly001'). */
        public Get setSubscriptionId(java.lang.String subscriptionId) {
          this.subscriptionId = subscriptionId;
          return this;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        @com.google.api.client.util.Key
        private java.lang.String token;

        /** The token provided to the user's device when the subscription was purchased.
         */
        public java.lang.String getToken() {
          return token;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        public Get setToken(java.lang.String token) {
          this.token = token;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Refunds a user's subscription purchase, but the subscription remains valid until its expiration
       * time and it will continue to recur.
       *
       * Create a request for the method "subscriptions.refund".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Refund#execute()} method to invoke the remote operation.
       *
       * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
       * @param subscriptionId "The purchased subscription ID (for example, 'monthly001').
       * @param token The token provided to the user's device when the subscription was
      purchased.
       * @return the request
       */
      public Refund refund(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token) throws java.io.IOException {
        Refund result = new Refund(packageName, subscriptionId, token);
        initialize(result);
        return result;
      }

      public class Refund extends AndroidPublisherRequest<Void> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:refund";

        /**
         * Refunds a user's subscription purchase, but the subscription remains valid until its expiration
         * time and it will continue to recur.
         *
         * Create a request for the method "subscriptions.refund".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Refund#execute()} method to invoke the remote operation.
         * <p> {@link
         * Refund#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
         * @param subscriptionId "The purchased subscription ID (for example, 'monthly001').
         * @param token The token provided to the user's device when the subscription was
      purchased.
         * @since 1.13
         */
        protected Refund(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token) {
          super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.subscriptionId = com.google.api.client.util.Preconditions.checkNotNull(subscriptionId, "Required parameter subscriptionId must be specified.");
          this.token = com.google.api.client.util.Preconditions.checkNotNull(token, "Required parameter token must be specified.");
        }

        @Override
        public Refund set$Xgafv(java.lang.String $Xgafv) {
          return (Refund) super.set$Xgafv($Xgafv);
        }

        @Override
        public Refund setAccessToken(java.lang.String accessToken) {
          return (Refund) super.setAccessToken(accessToken);
        }

        @Override
        public Refund setAlt(java.lang.String alt) {
          return (Refund) super.setAlt(alt);
        }

        @Override
        public Refund setCallback(java.lang.String callback) {
          return (Refund) super.setCallback(callback);
        }

        @Override
        public Refund setFields(java.lang.String fields) {
          return (Refund) super.setFields(fields);
        }

        @Override
        public Refund setKey(java.lang.String key) {
          return (Refund) super.setKey(key);
        }

        @Override
        public Refund setOauthToken(java.lang.String oauthToken) {
          return (Refund) super.setOauthToken(oauthToken);
        }

        @Override
        public Refund setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Refund) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Refund setQuotaUser(java.lang.String quotaUser) {
          return (Refund) super.setQuotaUser(quotaUser);
        }

        @Override
        public Refund setUploadType(java.lang.String uploadType) {
          return (Refund) super.setUploadType(uploadType);
        }

        @Override
        public Refund setUploadProtocol(java.lang.String uploadProtocol) {
          return (Refund) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** The package name of the application for which this subscription was purchased (for example,
       'com.some.thing').
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        public Refund setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** "The purchased subscription ID (for example, 'monthly001'). */
        @com.google.api.client.util.Key
        private java.lang.String subscriptionId;

        /**" The purchased subscription ID (for example, 'monthly001').
      "

         */
        public java.lang.String getSubscriptionId() {
          return subscriptionId;
        }

        /** "The purchased subscription ID (for example, 'monthly001'). */
        public Refund setSubscriptionId(java.lang.String subscriptionId) {
          this.subscriptionId = subscriptionId;
          return this;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        @com.google.api.client.util.Key
        private java.lang.String token;

        /** The token provided to the user's device when the subscription was purchased.
         */
        public java.lang.String getToken() {
          return token;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        public Refund setToken(java.lang.String token) {
          this.token = token;
          return this;
        }

        @Override
        public Refund set(String parameterName, Object value) {
          return (Refund) super.set(parameterName, value);
        }
      }
      /**
       * Refunds and immediately revokes a user's subscription purchase. Access to the subscription will
       * be terminated immediately and it will stop recurring.
       *
       * Create a request for the method "subscriptions.revoke".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link Revoke#execute()} method to invoke the remote operation.
       *
       * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
       * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
       * @param token The token provided to the user's device when the subscription was
      purchased.
       * @return the request
       */
      public Revoke revoke(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token) throws java.io.IOException {
        Revoke result = new Revoke(packageName, subscriptionId, token);
        initialize(result);
        return result;
      }

      public class Revoke extends AndroidPublisherRequest<Void> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:revoke";

        /**
         * Refunds and immediately revokes a user's subscription purchase. Access to the subscription will
         * be terminated immediately and it will stop recurring.
         *
         * Create a request for the method "subscriptions.revoke".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link Revoke#execute()} method to invoke the remote operation.
         * <p> {@link
         * Revoke#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName The package name of the application for which this subscription was
      purchased (for example,
       *        'com.some.thing').
         * @param subscriptionId The purchased subscription ID (for example, 'monthly001').
         * @param token The token provided to the user's device when the subscription was
      purchased.
         * @since 1.13
         */
        protected Revoke(java.lang.String packageName, java.lang.String subscriptionId, java.lang.String token) {
          super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
          this.subscriptionId = com.google.api.client.util.Preconditions.checkNotNull(subscriptionId, "Required parameter subscriptionId must be specified.");
          this.token = com.google.api.client.util.Preconditions.checkNotNull(token, "Required parameter token must be specified.");
        }

        @Override
        public Revoke set$Xgafv(java.lang.String $Xgafv) {
          return (Revoke) super.set$Xgafv($Xgafv);
        }

        @Override
        public Revoke setAccessToken(java.lang.String accessToken) {
          return (Revoke) super.setAccessToken(accessToken);
        }

        @Override
        public Revoke setAlt(java.lang.String alt) {
          return (Revoke) super.setAlt(alt);
        }

        @Override
        public Revoke setCallback(java.lang.String callback) {
          return (Revoke) super.setCallback(callback);
        }

        @Override
        public Revoke setFields(java.lang.String fields) {
          return (Revoke) super.setFields(fields);
        }

        @Override
        public Revoke setKey(java.lang.String key) {
          return (Revoke) super.setKey(key);
        }

        @Override
        public Revoke setOauthToken(java.lang.String oauthToken) {
          return (Revoke) super.setOauthToken(oauthToken);
        }

        @Override
        public Revoke setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Revoke) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Revoke setQuotaUser(java.lang.String quotaUser) {
          return (Revoke) super.setQuotaUser(quotaUser);
        }

        @Override
        public Revoke setUploadType(java.lang.String uploadType) {
          return (Revoke) super.setUploadType(uploadType);
        }

        @Override
        public Revoke setUploadProtocol(java.lang.String uploadProtocol) {
          return (Revoke) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** The package name of the application for which this subscription was purchased (for example,
       'com.some.thing').
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /**
         * The package name of the application for which this subscription was purchased (for
         * example, 'com.some.thing').
         */
        public Revoke setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /** The purchased subscription ID (for example, 'monthly001'). */
        @com.google.api.client.util.Key
        private java.lang.String subscriptionId;

        /** The purchased subscription ID (for example, 'monthly001').
         */
        public java.lang.String getSubscriptionId() {
          return subscriptionId;
        }

        /** The purchased subscription ID (for example, 'monthly001'). */
        public Revoke setSubscriptionId(java.lang.String subscriptionId) {
          this.subscriptionId = subscriptionId;
          return this;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        @com.google.api.client.util.Key
        private java.lang.String token;

        /** The token provided to the user's device when the subscription was purchased.
         */
        public java.lang.String getToken() {
          return token;
        }

        /**
         * The token provided to the user's device when the subscription was purchased.
         */
        public Revoke setToken(java.lang.String token) {
          this.token = token;
          return this;
        }

        @Override
        public Revoke set(String parameterName, Object value) {
          return (Revoke) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Voidedpurchases collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
     *   {@code AndroidPublisher.Voidedpurchases.List request = androidpublisher.voidedpurchases().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Voidedpurchases voidedpurchases() {
      return new Voidedpurchases();
    }

    /**
     * The "voidedpurchases" collection of methods.
     */
    public class Voidedpurchases {

      /**
       * Lists the purchases that were canceled, refunded or charged-back.
       *
       * Create a request for the method "voidedpurchases.list".
       *
       * This request holds the parameters needed by the androidpublisher server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param packageName The package name of the application for which voided purchases need to be
      returned (for example,
       *        'com.some.thing').
       * @return the request
       */
      public List list(java.lang.String packageName) throws java.io.IOException {
        List result = new List(packageName);
        initialize(result);
        return result;
      }

      public class List extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.VoidedPurchasesListResponse> {

        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/voidedpurchases";

        /**
         * Lists the purchases that were canceled, refunded or charged-back.
         *
         * Create a request for the method "voidedpurchases.list".
         *
         * This request holds the parameters needed by the the androidpublisher server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param packageName The package name of the application for which voided purchases need to be
      returned (for example,
       *        'com.some.thing').
         * @since 1.13
         */
        protected List(java.lang.String packageName) {
          super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.VoidedPurchasesListResponse.class);
          this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The package name of the application for which voided purchases need to be returned (for
         * example, 'com.some.thing').
         */
        @com.google.api.client.util.Key
        private java.lang.String packageName;

        /** The package name of the application for which voided purchases need to be returned (for example,
       'com.some.thing').
         */
        public java.lang.String getPackageName() {
          return packageName;
        }

        /**
         * The package name of the application for which voided purchases need to be returned (for
         * example, 'com.some.thing').
         */
        public List setPackageName(java.lang.String packageName) {
          this.packageName = packageName;
          return this;
        }

        /**
         * The time, in milliseconds since the Epoch, of the newest voided purchase that you want to
         * see in the response. The value of this parameter cannot be greater than the current time
         * and is ignored if a pagination token is set. Default value is current time. Note: This
         * filter is applied on the time at which the record is seen as voided by our systems and
         * not the actual voided time returned in the response.
         */
        @com.google.api.client.util.Key
        private java.lang.Long endTime;

        /** The time, in milliseconds since the Epoch, of the newest voided purchase that you want to see in
       the response. The value of this parameter cannot be greater than the current time and is ignored if
       a pagination token is set. Default value is current time. Note: This filter is applied on the time
       at which the record is seen as voided by our systems and not the actual voided time returned in the
       response.
         */
        public java.lang.Long getEndTime() {
          return endTime;
        }

        /**
         * The time, in milliseconds since the Epoch, of the newest voided purchase that you want to
         * see in the response. The value of this parameter cannot be greater than the current time
         * and is ignored if a pagination token is set. Default value is current time. Note: This
         * filter is applied on the time at which the record is seen as voided by our systems and
         * not the actual voided time returned in the response.
         */
        public List setEndTime(java.lang.Long endTime) {
          this.endTime = endTime;
          return this;
        }

        /**
         * Defines how many results the list operation should return. The default number depends on
         * the resource collection.
         */
        @com.google.api.client.util.Key
        private java.lang.Long maxResults;

        /** Defines how many results the list operation should return. The default number depends on the
       resource collection.
         */
        public java.lang.Long getMaxResults() {
          return maxResults;
        }

        /**
         * Defines how many results the list operation should return. The default number depends on
         * the resource collection.
         */
        public List setMaxResults(java.lang.Long maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * Defines the index of the first element to return. This can only be used if indexed paging
         * is enabled.
         */
        @com.google.api.client.util.Key
        private java.lang.Long startIndex;

        /** Defines the index of the first element to return. This can only be used if indexed paging is
       enabled.
         */
        public java.lang.Long getStartIndex() {
          return startIndex;
        }

        /**
         * Defines the index of the first element to return. This can only be used if indexed paging
         * is enabled.
         */
        public List setStartIndex(java.lang.Long startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        /**
         * The time, in milliseconds since the Epoch, of the oldest voided purchase that you want to
         * see in the response. The value of this parameter cannot be older than 30 days and is
         * ignored if a pagination token is set. Default value is current time minus 30 days. Note:
         * This filter is applied on the time at which the record is seen as voided by our systems
         * and not the actual voided time returned in the response.
         */
        @com.google.api.client.util.Key
        private java.lang.Long startTime;

        /** The time, in milliseconds since the Epoch, of the oldest voided purchase that you want to see in
       the response. The value of this parameter cannot be older than 30 days and is ignored if a
       pagination token is set. Default value is current time minus 30 days. Note: This filter is applied
       on the time at which the record is seen as voided by our systems and not the actual voided time
       returned in the response.
         */
        public java.lang.Long getStartTime() {
          return startTime;
        }

        /**
         * The time, in milliseconds since the Epoch, of the oldest voided purchase that you want to
         * see in the response. The value of this parameter cannot be older than 30 days and is
         * ignored if a pagination token is set. Default value is current time minus 30 days. Note:
         * This filter is applied on the time at which the record is seen as voided by our systems
         * and not the actual voided time returned in the response.
         */
        public List setStartTime(java.lang.Long startTime) {
          this.startTime = startTime;
          return this;
        }

        /**
         * Defines the token of the page to return, usually taken from TokenPagination. This can
         * only be used if token paging is enabled.
         */
        @com.google.api.client.util.Key
        private java.lang.String token;

        /** Defines the token of the page to return, usually taken from TokenPagination. This can only be used
       if token paging is enabled.
         */
        public java.lang.String getToken() {
          return token;
        }

        /**
         * Defines the token of the page to return, usually taken from TokenPagination. This can
         * only be used if token paging is enabled.
         */
        public List setToken(java.lang.String token) {
          this.token = token;
          return this;
        }

        /**
         * The type of voided purchases that you want to see in the response. Possible values are:
         * 0. Only voided in-app product purchases will be returned in the response. This is the
         * default value. 1. Both voided in-app purchases and voided subscription purchases will be
         * returned in the response.
         *
         * Note: Before requesting to receive voided subscription purchases, you must switch to use
         * orderId in the response which uniquely identifies one-time purchases and subscriptions.
         * Otherwise, you will receive multiple subscription orders with the same PurchaseToken,
         * because subscription renewal orders share the same PurchaseToken.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer type;

        /** The type of voided purchases that you want to see in the response. Possible values are: 0. Only
       voided in-app product purchases will be returned in the response. This is the default value. 1.
       Both voided in-app purchases and voided subscription purchases will be returned in the response.

       Note: Before requesting to receive voided subscription purchases, you must switch to use orderId in
       the response which uniquely identifies one-time purchases and subscriptions. Otherwise, you will
       receive multiple subscription orders with the same PurchaseToken, because subscription renewal
       orders share the same PurchaseToken.
         */
        public java.lang.Integer getType() {
          return type;
        }

        /**
         * The type of voided purchases that you want to see in the response. Possible values are:
         * 0. Only voided in-app product purchases will be returned in the response. This is the
         * default value. 1. Both voided in-app purchases and voided subscription purchases will be
         * returned in the response.
         *
         * Note: Before requesting to receive voided subscription purchases, you must switch to use
         * orderId in the response which uniquely identifies one-time purchases and subscriptions.
         * Otherwise, you will receive multiple subscription orders with the same PurchaseToken,
         * because subscription renewal orders share the same PurchaseToken.
         */
        public List setType(java.lang.Integer type) {
          this.type = type;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Reviews collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code AndroidPublisher androidpublisher = new AndroidPublisher(...);}
   *   {@code AndroidPublisher.Reviews.List request = androidpublisher.reviews().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Reviews reviews() {
    return new Reviews();
  }

  /**
   * The "reviews" collection of methods.
   */
  public class Reviews {

    /**
     * Gets a single review.
     *
     * Create a request for the method "reviews.get".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param reviewId Unique identifier for a review.
     * @return the request
     */
    public Get get(java.lang.String packageName, java.lang.String reviewId) throws java.io.IOException {
      Get result = new Get(packageName, reviewId);
      initialize(result);
      return result;
    }

    public class Get extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Review> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/reviews/{reviewId}";

      /**
       * Gets a single review.
       *
       * Create a request for the method "reviews.get".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param reviewId Unique identifier for a review.
       * @since 1.13
       */
      protected Get(java.lang.String packageName, java.lang.String reviewId) {
        super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.Review.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.reviewId = com.google.api.client.util.Preconditions.checkNotNull(reviewId, "Required parameter reviewId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Get setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** Unique identifier for a review. */
      @com.google.api.client.util.Key
      private java.lang.String reviewId;

      /** Unique identifier for a review.
       */
      public java.lang.String getReviewId() {
        return reviewId;
      }

      /** Unique identifier for a review. */
      public Get setReviewId(java.lang.String reviewId) {
        this.reviewId = reviewId;
        return this;
      }

      /** Language localization code. */
      @com.google.api.client.util.Key
      private java.lang.String translationLanguage;

      /** Language localization code.
       */
      public java.lang.String getTranslationLanguage() {
        return translationLanguage;
      }

      /** Language localization code. */
      public Get setTranslationLanguage(java.lang.String translationLanguage) {
        this.translationLanguage = translationLanguage;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists all reviews.
     *
     * Create a request for the method "reviews.list".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @return the request
     */
    public List list(java.lang.String packageName) throws java.io.IOException {
      List result = new List(packageName);
      initialize(result);
      return result;
    }

    public class List extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ReviewsListResponse> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/reviews";

      /**
       * Lists all reviews.
       *
       * Create a request for the method "reviews.list".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @since 1.13
       */
      protected List(java.lang.String packageName) {
        super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.ReviewsListResponse.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public List setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** How many results the list operation should return. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** How many results the list operation should return.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** How many results the list operation should return. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The index of the first element to return. */
      @com.google.api.client.util.Key
      private java.lang.Long startIndex;

      /** The index of the first element to return.
       */
      public java.lang.Long getStartIndex() {
        return startIndex;
      }

      /** The index of the first element to return. */
      public List setStartIndex(java.lang.Long startIndex) {
        this.startIndex = startIndex;
        return this;
      }

      /** Pagination token. If empty, list starts at the first review. */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Pagination token. If empty, list starts at the first review.
       */
      public java.lang.String getToken() {
        return token;
      }

      /** Pagination token. If empty, list starts at the first review. */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      /** Language localization code. */
      @com.google.api.client.util.Key
      private java.lang.String translationLanguage;

      /** Language localization code.
       */
      public java.lang.String getTranslationLanguage() {
        return translationLanguage;
      }

      /** Language localization code. */
      public List setTranslationLanguage(java.lang.String translationLanguage) {
        this.translationLanguage = translationLanguage;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Replies to a single review, or updates an existing reply.
     *
     * Create a request for the method "reviews.reply".
     *
     * This request holds the parameters needed by the androidpublisher server.  After setting any
     * optional parameters, call the {@link Reply#execute()} method to invoke the remote operation.
     *
     * @param packageName Package name of the app.
     * @param reviewId Unique identifier for a review.
     * @param content the {@link com.google.api.services.androidpublisher.model.ReviewsReplyRequest}
     * @return the request
     */
    public Reply reply(java.lang.String packageName, java.lang.String reviewId, com.google.api.services.androidpublisher.model.ReviewsReplyRequest content) throws java.io.IOException {
      Reply result = new Reply(packageName, reviewId, content);
      initialize(result);
      return result;
    }

    public class Reply extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.ReviewsReplyResponse> {

      private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/reviews/{reviewId}:reply";

      /**
       * Replies to a single review, or updates an existing reply.
       *
       * Create a request for the method "reviews.reply".
       *
       * This request holds the parameters needed by the the androidpublisher server.  After setting any
       * optional parameters, call the {@link Reply#execute()} method to invoke the remote operation.
       * <p> {@link
       * Reply#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param packageName Package name of the app.
       * @param reviewId Unique identifier for a review.
       * @param content the {@link com.google.api.services.androidpublisher.model.ReviewsReplyRequest}
       * @since 1.13
       */
      protected Reply(java.lang.String packageName, java.lang.String reviewId, com.google.api.services.androidpublisher.model.ReviewsReplyRequest content) {
        super(AndroidPublisher.this, "POST", REST_PATH, content, com.google.api.services.androidpublisher.model.ReviewsReplyResponse.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        this.reviewId = com.google.api.client.util.Preconditions.checkNotNull(reviewId, "Required parameter reviewId must be specified.");
      }

      @Override
      public Reply set$Xgafv(java.lang.String $Xgafv) {
        return (Reply) super.set$Xgafv($Xgafv);
      }

      @Override
      public Reply setAccessToken(java.lang.String accessToken) {
        return (Reply) super.setAccessToken(accessToken);
      }

      @Override
      public Reply setAlt(java.lang.String alt) {
        return (Reply) super.setAlt(alt);
      }

      @Override
      public Reply setCallback(java.lang.String callback) {
        return (Reply) super.setCallback(callback);
      }

      @Override
      public Reply setFields(java.lang.String fields) {
        return (Reply) super.setFields(fields);
      }

      @Override
      public Reply setKey(java.lang.String key) {
        return (Reply) super.setKey(key);
      }

      @Override
      public Reply setOauthToken(java.lang.String oauthToken) {
        return (Reply) super.setOauthToken(oauthToken);
      }

      @Override
      public Reply setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Reply) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reply setQuotaUser(java.lang.String quotaUser) {
        return (Reply) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reply setUploadType(java.lang.String uploadType) {
        return (Reply) super.setUploadType(uploadType);
      }

      @Override
      public Reply setUploadProtocol(java.lang.String uploadProtocol) {
        return (Reply) super.setUploadProtocol(uploadProtocol);
      }

      /** Package name of the app. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /** Package name of the app.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /** Package name of the app. */
      public Reply setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        return this;
      }

      /** Unique identifier for a review. */
      @com.google.api.client.util.Key
      private java.lang.String reviewId;

      /** Unique identifier for a review.
       */
      public java.lang.String getReviewId() {
        return reviewId;
      }

      /** Unique identifier for a review. */
      public Reply setReviewId(java.lang.String reviewId) {
        this.reviewId = reviewId;
        return this;
      }

      @Override
      public Reply set(String parameterName, Object value) {
        return (Reply) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link AndroidPublisher}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link AndroidPublisher}. */
    @Override
    public AndroidPublisher build() {
      return new AndroidPublisher(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link AndroidPublisherRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setAndroidPublisherRequestInitializer(
        AndroidPublisherRequestInitializer androidpublisherRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(androidpublisherRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
