/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Response listing all in-app products.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InappproductsListResponse extends com.google.api.client.json.GenericJson {

  /**
   * All in-app products.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InAppProduct> inappproduct;

  static {
    // hack to force ProGuard to consider InAppProduct used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(InAppProduct.class);
  }

  /**
   * The kind of this response ("androidpublisher#inappproductsListResponse").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Information about the current page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PageInfo pageInfo;

  /**
   * Pagination token, to handle a number of products that is over one page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TokenPagination tokenPagination;

  /**
   * All in-app products.
   * @return value or {@code null} for none
   */
  public java.util.List<InAppProduct> getInappproduct() {
    return inappproduct;
  }

  /**
   * All in-app products.
   * @param inappproduct inappproduct or {@code null} for none
   */
  public InappproductsListResponse setInappproduct(java.util.List<InAppProduct> inappproduct) {
    this.inappproduct = inappproduct;
    return this;
  }

  /**
   * The kind of this response ("androidpublisher#inappproductsListResponse").
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of this response ("androidpublisher#inappproductsListResponse").
   * @param kind kind or {@code null} for none
   */
  public InappproductsListResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Information about the current page.
   * @return value or {@code null} for none
   */
  public PageInfo getPageInfo() {
    return pageInfo;
  }

  /**
   * Information about the current page.
   * @param pageInfo pageInfo or {@code null} for none
   */
  public InappproductsListResponse setPageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

  /**
   * Pagination token, to handle a number of products that is over one page.
   * @return value or {@code null} for none
   */
  public TokenPagination getTokenPagination() {
    return tokenPagination;
  }

  /**
   * Pagination token, to handle a number of products that is over one page.
   * @param tokenPagination tokenPagination or {@code null} for none
   */
  public InappproductsListResponse setTokenPagination(TokenPagination tokenPagination) {
    this.tokenPagination = tokenPagination;
    return this;
  }

  @Override
  public InappproductsListResponse set(String fieldName, Object value) {
    return (InappproductsListResponse) super.set(fieldName, value);
  }

  @Override
  public InappproductsListResponse clone() {
    return (InappproductsListResponse) super.clone();
  }

}
