/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * An expansion file. The resource for ExpansionFilesService.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExpansionFile extends com.google.api.client.json.GenericJson {

  /**
   * If set, this field indicates that this APK has an expansion file uploaded to it: this APK does
   * not reference another APK's expansion file. The field's value is the size of the uploaded
   * expansion file in bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long fileSize;

  /**
   * If set, this APK's expansion file references another APK's expansion file. The file_size field
   * will not be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer referencesVersion;

  /**
   * If set, this field indicates that this APK has an expansion file uploaded to it: this APK does
   * not reference another APK's expansion file. The field's value is the size of the uploaded
   * expansion file in bytes.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFileSize() {
    return fileSize;
  }

  /**
   * If set, this field indicates that this APK has an expansion file uploaded to it: this APK does
   * not reference another APK's expansion file. The field's value is the size of the uploaded
   * expansion file in bytes.
   * @param fileSize fileSize or {@code null} for none
   */
  public ExpansionFile setFileSize(java.lang.Long fileSize) {
    this.fileSize = fileSize;
    return this;
  }

  /**
   * If set, this APK's expansion file references another APK's expansion file. The file_size field
   * will not be set.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getReferencesVersion() {
    return referencesVersion;
  }

  /**
   * If set, this APK's expansion file references another APK's expansion file. The file_size field
   * will not be set.
   * @param referencesVersion referencesVersion or {@code null} for none
   */
  public ExpansionFile setReferencesVersion(java.lang.Integer referencesVersion) {
    this.referencesVersion = referencesVersion;
    return this;
  }

  @Override
  public ExpansionFile set(String fieldName, Object value) {
    return (ExpansionFile) super.set(fieldName, value);
  }

  @Override
  public ExpansionFile clone() {
    return (ExpansionFile) super.clone();
  }

}
