/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Information related to a prepaid plan.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PrepaidPlan extends com.google.api.client.json.GenericJson {

  /**
   * After this time, the subscription is allowed for a new top-up purchase. Not present if the
   * subscription is already extended by a top-up purchase.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String allowExtendAfterTime;

  /**
   * After this time, the subscription is allowed for a new top-up purchase. Not present if the
   * subscription is already extended by a top-up purchase.
   * @return value or {@code null} for none
   */
  public String getAllowExtendAfterTime() {
    return allowExtendAfterTime;
  }

  /**
   * After this time, the subscription is allowed for a new top-up purchase. Not present if the
   * subscription is already extended by a top-up purchase.
   * @param allowExtendAfterTime allowExtendAfterTime or {@code null} for none
   */
  public PrepaidPlan setAllowExtendAfterTime(String allowExtendAfterTime) {
    this.allowExtendAfterTime = allowExtendAfterTime;
    return this;
  }

  @Override
  public PrepaidPlan set(String fieldName, Object value) {
    return (PrepaidPlan) super.set(fieldName, value);
  }

  @Override
  public PrepaidPlan clone() {
    return (PrepaidPlan) super.clone();
  }

}
